/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.HashMap;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.type.DataTypeFactory;
import org.h2.util.New;

public class MVStoreBuilder {
    private final HashMap<String, Object> config = New.hashMap();

    public static MVStoreBuilder fileBased(String string) {
        return new MVStoreBuilder().fileName(string);
    }

    public static MVStoreBuilder inMemory() {
        return new MVStoreBuilder();
    }

    private MVStoreBuilder set(String string, Object object) {
        if (this.config.containsKey(string)) {
            throw new IllegalArgumentException("Parameter " + this.config.get(string) + " is already set");
        }
        this.config.put(string, object);
        return this;
    }

    private MVStoreBuilder fileName(String string) {
        return this.set("fileName", string);
    }

    public MVStoreBuilder readOnly() {
        return this.set("openMode", "r");
    }

    public MVStoreBuilder cacheSizeMB(int n) {
        return this.set("cacheSize", Integer.toString(n));
    }

    public MVStoreBuilder with(DataTypeFactory dataTypeFactory) {
        return this.set("dataTypeFactory", dataTypeFactory);
    }

    public MVStore open() {
        MVStore mVStore = new MVStore(this.config);
        mVStore.open();
        return mVStore;
    }

    public String toString() {
        return DataUtils.appendMap(new StringBuilder(), this.config).toString();
    }

    public static MVStoreBuilder fromString(String string) {
        HashMap<String, String> hashMap = DataUtils.parseMap(string);
        MVStoreBuilder mVStoreBuilder = new MVStoreBuilder();
        mVStoreBuilder.config.putAll(hashMap);
        return mVStoreBuilder;
    }
}

