/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.utils.Utils;
import azkaban.webapp.servlet.PageRenderException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class Page {
    private static final String DEFAULT_MIME_TYPE = "text/html";
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final VelocityEngine engine;
    private final VelocityContext context;
    private final String template;
    private String mimeType = "text/html";

    public Page(HttpServletRequest request, HttpServletResponse response, VelocityEngine engine, String template) {
        this.request = (HttpServletRequest)Utils.nonNull((Object)request);
        this.response = (HttpServletResponse)Utils.nonNull((Object)response);
        this.engine = (VelocityEngine)Utils.nonNull((Object)engine);
        this.template = (String)Utils.nonNull((Object)template);
        this.context = new VelocityContext();
        this.context.put("session", (Object)request.getSession(true));
        this.context.put("context", (Object)request.getContextPath());
    }

    public void render() {
        try {
            this.response.setHeader("Content-type", "text/html; charset=UTF-8");
            this.response.setCharacterEncoding("UTF-8");
            this.response.setContentType(this.mimeType);
            this.engine.mergeTemplate(this.template, "UTF-8", (Context)this.context, (Writer)this.response.getWriter());
        }
        catch (Exception e) {
            throw new PageRenderException((Throwable)e);
        }
    }

    public void add(String name, Object value) {
        this.context.put(name, value);
    }

    public void setMimeType(String type) {
        this.mimeType = type;
    }
}

