/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils.cache;

import azkaban.utils.cache.Cache;
import azkaban.utils.cache.CacheManager;
import azkaban.utils.cache.Element;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Cache {
    private long nextUpdateTime = 0L;
    private long updateFrequency = 60000L;
    private int maxCacheSize = -1;
    private long expireTimeToLive = -1L;
    private long expireTimeToIdle = -1L;
    private EjectionPolicy ejectionPolicy = EjectionPolicy.LRU;
    private CacheManager manager = null;
    private Map<Object, Element<?>> elementMap = new ConcurrentHashMap();

    Cache(CacheManager manager) {
        this.manager = manager;
    }

    public <T> T get(Object key) {
        Element element = (Element)this.elementMap.get(key);
        if (element == null) {
            return null;
        }
        return (T)element.getElement();
    }

    public <T> void put(Object key, T item) {
        Element elem = new Element(key, item);
        this.elementMap.put(key, elem);
    }

    public boolean remove(Object key) {
        Element elem = (Element)this.elementMap.remove(key);
        return elem != null;
    }

    public Cache setMaxCacheSize(int size) {
        this.maxCacheSize = size;
        return this;
    }

    public Cache setEjectionPolicy(EjectionPolicy policy) {
        this.ejectionPolicy = policy;
        return this;
    }

    public Cache setUpdateFrequencyMs(long updateFrequencyMs) {
        this.updateFrequency = updateFrequencyMs;
        return this;
    }

    public Cache setExpiryTimeToLiveMs(long time) {
        this.expireTimeToLive = time;
        if (time > 0L) {
            this.manager.update();
        }
        return this;
    }

    public Cache setExpiryIdleTimeMs(long time) {
        this.expireTimeToIdle = time;
        if (time > 0L) {
            this.manager.update();
        }
        return this;
    }

    public int getSize() {
        return this.elementMap.size();
    }

    public long getExpireTimeToLive() {
        return this.expireTimeToLive;
    }

    public long getExpireTimeToIdle() {
        return this.expireTimeToIdle;
    }

    public synchronized <T> void insertElement(Object key, T item) {
        if (this.maxCacheSize < 0 || this.elementMap.size() < this.maxCacheSize) {
            Element elem = new Element(key, item);
            this.elementMap.put(key, elem);
        } else {
            this.internalExpireCache();
            Element elem = new Element(key, item);
            if (this.elementMap.size() < this.maxCacheSize) {
                this.elementMap.put(key, elem);
            } else {
                Element element = this.getNextExpiryElement();
                if (element != null) {
                    this.elementMap.remove(element.getKey());
                }
                this.elementMap.put(key, elem);
            }
        }
    }

    private Element<?> getNextExpiryElement() {
        if (this.ejectionPolicy == EjectionPolicy.LRU) {
            long latestAccessTime = Long.MAX_VALUE;
            Element ejectionCandidate = null;
            for (Element elem : this.elementMap.values()) {
                if (latestAccessTime <= elem.getLastUpdateTime()) continue;
                latestAccessTime = elem.getLastUpdateTime();
                ejectionCandidate = elem;
            }
            return ejectionCandidate;
        }
        if (this.ejectionPolicy == EjectionPolicy.FIFO) {
            long earliestCreateTime = Long.MAX_VALUE;
            Element ejectionCandidate = null;
            for (Element elem : this.elementMap.values()) {
                if (earliestCreateTime <= elem.getCreationTime()) continue;
                earliestCreateTime = elem.getCreationTime();
                ejectionCandidate = elem;
            }
            return ejectionCandidate;
        }
        return null;
    }

    public synchronized void expireCache() {
        long currentTime = System.currentTimeMillis();
        if (this.nextUpdateTime < currentTime) {
            this.internalExpireCache();
            this.nextUpdateTime = currentTime + this.updateFrequency;
        }
    }

    private synchronized void internalExpireCache() {
        ArrayList elems = new ArrayList(this.elementMap.values());
        for (Element elem : elems) {
            if (!this.shouldExpire(elem)) continue;
            this.elementMap.remove(elem.getKey());
        }
    }

    private boolean shouldExpire(Element<?> elem) {
        if (this.expireTimeToLive > -1L && System.currentTimeMillis() - elem.getCreationTime() > this.expireTimeToLive) {
            return true;
        }
        return this.expireTimeToIdle > -1L && System.currentTimeMillis() - elem.getLastUpdateTime() > this.expireTimeToIdle;
    }
}

