/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.Iterator;
import org.h2.mvstore.CursorPos;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.Page;

public class Cursor<K>
implements Iterator<K> {
    protected final MVMap<K, ?> map;
    protected final K from;
    protected CursorPos pos;
    protected K current;
    private final Page root;
    private boolean initialized;

    protected Cursor(MVMap<K, ?> mVMap, Page page, K k) {
        this.map = mVMap;
        this.root = page;
        this.from = k;
    }

    @Override
    public K next() {
        this.hasNext();
        K k = this.current;
        this.fetchNext();
        return k;
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.min(this.root, this.from);
            this.initialized = true;
            this.fetchNext();
        }
        return this.current != null;
    }

    public void skip(long l) {
        if (!this.hasNext()) {
            return;
        }
        if (l < 10L) {
            while (l-- > 0L) {
                this.fetchNext();
            }
            return;
        }
        long l2 = this.map.getKeyIndex(this.current);
        K k = this.map.getKey(l2 + l);
        this.min(this.root, k);
        this.fetchNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void min(Page page, K k) {
        int n;
        while (true) {
            if (page.isLeaf()) {
                int n2 = n = k == null ? 0 : page.binarySearch(k);
                if (n < 0) {
                    n = -n - 1;
                }
                break;
            }
            int n3 = n = k == null ? -1 : page.binarySearch(k);
            n = n < 0 ? -n - 1 : ++n;
            this.pos = new CursorPos(page, n + 1, this.pos);
            page = page.getChildPage(n);
        }
        this.pos = new CursorPos(page, n, this.pos);
    }

    protected void fetchNext() {
        while (this.pos != null) {
            if (this.pos.index < this.pos.page.getKeyCount()) {
                this.current = this.pos.page.getKey(this.pos.index++);
                return;
            }
            this.pos = this.pos.parent;
            if (this.pos == null) break;
            if (this.pos.index >= this.map.getChildPageCount(this.pos.page)) continue;
            this.min(this.pos.page.getChildPage(this.pos.index++), null);
        }
        this.current = null;
    }
}

