/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.user;

import azkaban.user.User;
import azkaban.user.UserManagerException;
import azkaban.user.XmlUserManager;
import azkaban.utils.Props;
import azkaban.utils.UndefinedPropertyException;
import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XmlUserManagerTest {
    private Props baseProps = new Props();

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testFilePropNotSet() throws Exception {
        Props props = new Props(this.baseProps);
        try {
            XmlUserManager xmlUserManager = new XmlUserManager(props);
        }
        catch (UndefinedPropertyException e) {
            return;
        }
        Assert.fail((String)"XmlUserManager should throw an exception when the file property isn't set");
    }

    @Test
    public void testDoNotExist() throws Exception {
        Props props = new Props(this.baseProps);
        props.put("user.manager.xml.file", "unit/test-conf/doNotExist.xml");
        try {
            XmlUserManager xmlUserManager = new XmlUserManager(props);
        }
        catch (RuntimeException e) {
            return;
        }
        Assert.fail((String)"XmlUserManager should throw an exception when the file doesn't exist");
    }

    @Test
    public void testBasicLoad() throws Exception {
        Props props = new Props(this.baseProps);
        props.put("user.manager.xml.file", "unit/test-conf/azkaban-users-test1.xml");
        XmlUserManager manager = null;
        try {
            manager = new XmlUserManager(props);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            Assert.fail((String)"XmlUserManager should've found file azkaban-users.xml");
        }
        try {
            manager.getUser("user0", null);
        }
        catch (UserManagerException e) {
            System.out.println("Exception handled correctly: " + e.getMessage());
        }
        try {
            manager.getUser(null, "etw");
        }
        catch (UserManagerException e) {
            System.out.println("Exception handled correctly: " + e.getMessage());
        }
        try {
            manager.getUser("user0", "user0");
        }
        catch (UserManagerException e) {
            System.out.println("Exception handled correctly: " + e.getMessage());
        }
        try {
            manager.getUser("user0", "password0");
        }
        catch (UserManagerException e) {
            e.printStackTrace();
            Assert.fail((String)"XmlUserManager should've returned a user.");
        }
        User user0 = manager.getUser("user0", "password0");
        this.checkUser(user0, "role0", "group0");
        User user1 = manager.getUser("user1", "password1");
        this.checkUser(user1, "role0,role1", "group1,group2");
        User user2 = manager.getUser("user2", "password2");
        this.checkUser(user2, "role0,role1,role2", "group1,group2,group3");
        User user3 = manager.getUser("user3", "password3");
        this.checkUser(user3, "role1,role2", "group1,group2");
        User user4 = manager.getUser("user4", "password4");
        this.checkUser(user4, "role1,role2", "group1,group2");
        User user5 = manager.getUser("user5", "password5");
        this.checkUser(user5, "role1,role2", "group1,group2");
        User user6 = manager.getUser("user6", "password6");
        this.checkUser(user6, "role3,role2", "group1,group2");
        User user7 = manager.getUser("user7", "password7");
        this.checkUser(user7, "", "group1");
        User user8 = manager.getUser("user8", "password8");
        this.checkUser(user8, "role3", "");
        User user9 = manager.getUser("user9", "password9");
        this.checkUser(user9, "", "");
    }

    private void checkUser(User user, String rolesStr, String groupsStr) {
        String outputGroupStr;
        int n;
        HashSet roleSet = new HashSet(user.getRoles());
        if (rolesStr.isEmpty()) {
            if (!roleSet.isEmpty()) {
                String outputRoleStr = "";
                for (String role : roleSet) {
                    outputRoleStr = String.valueOf(outputRoleStr) + role + ",";
                }
                throw new RuntimeException("Roles mismatch for " + user.getUserId() + ". Expected roles to be empty but got " + outputRoleStr);
            }
        } else {
            String outputRoleStr = "";
            for (String role : roleSet) {
                outputRoleStr = String.valueOf(outputRoleStr) + role + ",";
            }
            String[] splitRoles = rolesStr.split(",");
            HashSet<Object> expectedRoles = new HashSet<Object>();
            String[] stringArray = splitRoles;
            n = splitRoles.length;
            int n2 = 0;
            while (n2 < n) {
                Object role = stringArray[n2];
                if (!roleSet.contains(role)) {
                    throw new RuntimeException("Roles mismatch for user " + user.getUserId() + " role " + (String)role + ". Expected roles to " + rolesStr + " but got " + outputRoleStr);
                }
                expectedRoles.add(role);
                ++n2;
            }
            for (Object role : roleSet) {
                if (expectedRoles.contains(role)) continue;
                throw new RuntimeException("Roles mismatch for user " + user.getUserId() + " role " + (String)role + ". Expected roles to " + rolesStr + " but got " + outputRoleStr);
            }
        }
        HashSet groupSet = new HashSet(user.getGroups());
        if (groupsStr.isEmpty()) {
            if (!groupSet.isEmpty()) {
                outputGroupStr = "";
                for (String role : roleSet) {
                    outputGroupStr = String.valueOf(outputGroupStr) + role + ",";
                }
                throw new RuntimeException("Roles mismatch for " + user.getUserId() + ". Expected roles to be empty but got " + outputGroupStr);
            }
        } else {
            outputGroupStr = "";
            for (String group : groupSet) {
                outputGroupStr = String.valueOf(outputGroupStr) + group + ",";
            }
            String[] splitGroups = groupsStr.split(",");
            HashSet<String> expectedGroups = new HashSet<String>();
            String[] stringArray = splitGroups;
            int n3 = splitGroups.length;
            n = 0;
            while (n < n3) {
                String group = stringArray[n];
                if (!groupSet.contains(group)) {
                    throw new RuntimeException("Groups mismatch for user " + user.getUserId() + " group " + group + ". Expected groups to " + groupsStr + " but got " + outputGroupStr);
                }
                expectedGroups.add(group);
                ++n;
            }
            for (String group : groupSet) {
                if (expectedGroups.contains(group)) continue;
                throw new RuntimeException("Groups mismatch for user " + user.getUserId() + " group " + group + ". Expected groups to " + groupsStr + " but got " + outputGroupStr);
            }
        }
    }
}

