/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.Status;
import azkaban.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExecutableJobInfo {
    private final int execId;
    private final int projectId;
    private final int version;
    private final String flowId;
    private final String jobId;
    private final long startTime;
    private final long endTime;
    private final Status status;
    private final int attempt;
    private ArrayList<Pair<String, String>> jobPath;

    public ExecutableJobInfo(int execId, int projectId, int version, String flowId, String jobId, long startTime, long endTime, Status status, int attempt) {
        this.execId = execId;
        this.projectId = projectId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.status = status;
        this.version = version;
        this.flowId = flowId;
        this.jobId = jobId;
        this.attempt = attempt;
        this.parseFlowId();
    }

    public int getProjectId() {
        return this.projectId;
    }

    public int getExecId() {
        return this.execId;
    }

    public int getVersion() {
        return this.version;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public String getImmediateFlowId() {
        if (this.jobPath.size() == 1) {
            return this.flowId;
        }
        Pair pair = (Pair)this.jobPath.get(this.jobPath.size() - 1);
        return (String)pair.getSecond();
    }

    public String getHeadFlowId() {
        Pair pair = (Pair)this.jobPath.get(0);
        return (String)pair.getFirst();
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public List<Pair<String, String>> getParsedFlowId() {
        return this.jobPath;
    }

    private void parseFlowId() {
        String[] flowPairs;
        this.jobPath = new ArrayList();
        String[] stringArray = flowPairs = this.flowId.split(",");
        int n = flowPairs.length;
        int n2 = 0;
        while (n2 < n) {
            String flowPair = stringArray[n2];
            String[] pairSplit = flowPair.split(":");
            Pair pair = pairSplit.length == 1 ? new Pair((Object)pairSplit[0], (Object)pairSplit[0]) : new Pair((Object)pairSplit[0], (Object)pairSplit[1]);
            this.jobPath.add(pair);
            ++n2;
        }
    }

    public String getJobIdPath() {
        String path = "";
        int i = 1;
        while (i < this.jobPath.size()) {
            Pair pair = (Pair)this.jobPath.get(i);
            path = String.valueOf(path) + (String)pair.getFirst() + ":";
            ++i;
        }
        path = String.valueOf(path) + this.jobId;
        return path;
    }

    public Map<String, Object> toObject() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("execId", this.execId);
        map.put("version", this.version);
        map.put("flowId", this.flowId);
        map.put("jobId", this.jobId);
        map.put("startTime", this.startTime);
        map.put("endTime", this.endTime);
        map.put("status", this.status.toString());
        map.put("attempt", this.attempt);
        return map;
    }
}

