/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger.builtin;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.flow.Flow;
import azkaban.project.Project;
import azkaban.project.ProjectManager;
import azkaban.sla.SlaOption;
import azkaban.trigger.Condition;
import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerAction;
import azkaban.trigger.TriggerManager;
import azkaban.trigger.builtin.KillExecutionAction;
import azkaban.trigger.builtin.SlaAlertAction;
import azkaban.trigger.builtin.SlaChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExecuteFlowAction
implements TriggerAction {
    public static final String type = "ExecuteFlowAction";
    public static final String EXEC_ID = "ExecuteFlowAction.execid";
    private static ExecutorManagerAdapter executorManager;
    private static TriggerManager triggerManager;
    private String actionId;
    private int projectId;
    private String projectName;
    private String flowName;
    private String submitUser;
    private static ProjectManager projectManager;
    private ExecutionOptions executionOptions = new ExecutionOptions();
    private List<SlaOption> slaOptions;
    private static Logger logger;

    static {
        logger = Logger.getLogger(ExecuteFlowAction.class);
    }

    public ExecuteFlowAction(String actionId, int projectId, String projectName, String flowName, String submitUser, ExecutionOptions executionOptions, List<SlaOption> slaOptions) {
        this.actionId = actionId;
        this.projectId = projectId;
        this.projectName = projectName;
        this.flowName = flowName;
        this.submitUser = submitUser;
        this.executionOptions = executionOptions;
        this.slaOptions = slaOptions;
    }

    public static void setLogger(Logger logger) {
        ExecuteFlowAction.logger = logger;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public int getProjectId() {
        return this.projectId;
    }

    protected void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    protected void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String getSubmitUser() {
        return this.submitUser;
    }

    protected void setSubmitUser(String submitUser) {
        this.submitUser = submitUser;
    }

    public ExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }

    protected void setExecutionOptions(ExecutionOptions executionOptions) {
        this.executionOptions = executionOptions;
    }

    public List<SlaOption> getSlaOptions() {
        return this.slaOptions;
    }

    protected void setSlaOptions(List<SlaOption> slaOptions) {
        this.slaOptions = slaOptions;
    }

    public static ExecutorManagerAdapter getExecutorManager() {
        return executorManager;
    }

    public static void setExecutorManager(ExecutorManagerAdapter executorManager) {
        ExecuteFlowAction.executorManager = executorManager;
    }

    public static TriggerManager getTriggerManager() {
        return triggerManager;
    }

    public static void setTriggerManager(TriggerManager triggerManager) {
        ExecuteFlowAction.triggerManager = triggerManager;
    }

    public static ProjectManager getProjectManager() {
        return projectManager;
    }

    public static void setProjectManager(ProjectManager projectManager) {
        ExecuteFlowAction.projectManager = projectManager;
    }

    public String getType() {
        return "ExecuteFlowAction";
    }

    public TriggerAction fromJson(Object obj) {
        return ExecuteFlowAction.createFromJson((HashMap)((HashMap)obj));
    }

    public static TriggerAction createFromJson(HashMap<String, Object> obj) {
        HashMap<String, Object> jsonObj = obj;
        String objType = (String)jsonObj.get("type");
        if (!objType.equals("ExecuteFlowAction")) {
            throw new RuntimeException("Cannot create action of ExecuteFlowAction from " + objType);
        }
        String actionId = (String)jsonObj.get("actionId");
        int projectId = Integer.valueOf((String)jsonObj.get("projectId"));
        String projectName = (String)jsonObj.get("projectName");
        String flowName = (String)jsonObj.get("flowName");
        String submitUser = (String)jsonObj.get("submitUser");
        ExecutionOptions executionOptions = null;
        if (jsonObj.containsKey("executionOptions")) {
            executionOptions = ExecutionOptions.createFromObject(jsonObj.get("executionOptions"));
        }
        ArrayList<SlaOption> slaOptions = null;
        if (jsonObj.containsKey("slaOptions")) {
            slaOptions = new ArrayList<SlaOption>();
            List slaOptionsObj = (List)jsonObj.get("slaOptions");
            for (Object slaObj : slaOptionsObj) {
                slaOptions.add(SlaOption.fromObject(slaObj));
            }
        }
        return new ExecuteFlowAction(actionId, projectId, projectName, flowName, submitUser, executionOptions, slaOptions);
    }

    public Object toJson() {
        HashMap<String, Object> jsonObj = new HashMap<String, Object>();
        jsonObj.put("actionId", this.actionId);
        jsonObj.put("type", "ExecuteFlowAction");
        jsonObj.put("projectId", String.valueOf(this.projectId));
        jsonObj.put("projectName", this.projectName);
        jsonObj.put("flowName", this.flowName);
        jsonObj.put("submitUser", this.submitUser);
        if (this.executionOptions != null) {
            jsonObj.put("executionOptions", this.executionOptions.toObject());
        }
        if (this.slaOptions != null) {
            ArrayList<Map> slaOptionsObj = new ArrayList<Map>();
            for (SlaOption sla : this.slaOptions) {
                slaOptionsObj.add(sla.toObject());
            }
            jsonObj.put("slaOptions", slaOptionsObj);
        }
        return jsonObj;
    }

    public void doAction() throws Exception {
        if (projectManager == null || executorManager == null) {
            throw new Exception("ExecuteFlowAction not properly initialized!");
        }
        Project project = projectManager.getProject(this.projectId);
        if (project == null) {
            logger.error((Object)("Project to execute " + this.projectId + " does not exist!"));
            throw new RuntimeException("Error finding the project to execute " + this.projectId);
        }
        Flow flow = project.getFlow(this.flowName);
        if (flow == null) {
            logger.error((Object)("Flow " + this.flowName + " cannot be found in project " + project.getName()));
            throw new RuntimeException("Error finding the flow to execute " + this.flowName);
        }
        ExecutableFlow exflow = new ExecutableFlow(project, flow);
        exflow.setSubmitUser(this.submitUser);
        exflow.addAllProxyUsers((Collection)project.getProxyUsers());
        if (this.executionOptions == null) {
            this.executionOptions = new ExecutionOptions();
        }
        if (!this.executionOptions.isFailureEmailsOverridden()) {
            this.executionOptions.setFailureEmails((Collection)flow.getFailureEmails());
        }
        if (!this.executionOptions.isSuccessEmailsOverridden()) {
            this.executionOptions.setSuccessEmails((Collection)flow.getSuccessEmails());
        }
        exflow.setExecutionOptions(this.executionOptions);
        try {
            executorManager.submitExecutableFlow(exflow, this.submitUser);
            logger.info((Object)("Invoked flow " + project.getName() + "." + this.flowName));
        }
        catch (ExecutorManagerException e) {
            throw new RuntimeException(e);
        }
        if (this.slaOptions != null && this.slaOptions.size() > 0) {
            int execId = exflow.getExecutionId();
            for (SlaOption sla : this.slaOptions) {
                logger.info((Object)("Adding sla trigger " + sla.toString() + " to execution " + execId));
                SlaChecker slaFailChecker = new SlaChecker("slaFailChecker", sla, execId);
                HashMap<String, SlaChecker> slaCheckers = new HashMap<String, SlaChecker>();
                slaCheckers.put(slaFailChecker.getId(), slaFailChecker);
                Condition triggerCond = new Condition(slaCheckers, String.valueOf(slaFailChecker.getId()) + ".isSlaFailed()");
                SlaChecker slaPassChecker = new SlaChecker("slaPassChecker", sla, execId);
                HashMap<String, SlaChecker> expireCheckers = new HashMap<String, SlaChecker>();
                expireCheckers.put(slaPassChecker.getId(), slaPassChecker);
                Condition expireCond = new Condition(expireCheckers, String.valueOf(slaPassChecker.getId()) + ".isSlaPassed()");
                ArrayList<Object> actions = new ArrayList<Object>();
                List slaActions = sla.getActions();
                for (String act : slaActions) {
                    if (act.equals("SlaAlert")) {
                        SlaAlertAction slaAlert = new SlaAlertAction("slaAlert", sla, execId);
                        actions.add(slaAlert);
                        continue;
                    }
                    if (!act.equals("SlaCancelFlow")) continue;
                    KillExecutionAction killAct = new KillExecutionAction("killExecution", execId);
                    actions.add(killAct);
                }
                Trigger slaTrigger = new Trigger("azkaban_sla", "azkaban", triggerCond, expireCond, actions);
                slaTrigger.getInfo().put("monitored.finished.execution", String.valueOf(execId));
                slaTrigger.setResetOnTrigger(false);
                slaTrigger.setResetOnExpire(false);
                logger.info((Object)"Ready to put in the sla trigger");
                triggerManager.insertTrigger(slaTrigger);
                logger.info((Object)"Sla inserted.");
            }
        }
    }

    public String getDescription() {
        return "Execute flow " + this.getFlowName() + " from project " + this.getProjectName();
    }

    public void setContext(Map<String, Object> context) {
    }

    public String getId() {
        return this.actionId;
    }
}

