/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jmx;

import azkaban.jmx.JmxJettyServerMBean;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Server;

public class JmxJettyServer
implements JmxJettyServerMBean {
    private Server server;
    private Connector connector;

    public JmxJettyServer(Server server) {
        this.server = server;
        this.connector = server.getConnectors()[0];
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public boolean isFailed() {
        return this.server.isFailed();
    }

    public boolean isStopped() {
        return this.server.isStopped();
    }

    public int getNumThreads() {
        return this.server.getThreadPool().getThreads();
    }

    public int getNumIdleThreads() {
        return this.server.getThreadPool().getIdleThreads();
    }

    public String getHost() {
        return this.connector.getHost();
    }

    public int getPort() {
        return this.connector.getPort();
    }

    public int getConfidentialPort() {
        return this.connector.getConfidentialPort();
    }

    public int getConnections() {
        return this.connector.getConnections();
    }

    public int getConnectionsOpen() {
        return this.connector.getConnectionsOpen();
    }

    public int getConnectionsOpenMax() {
        return this.connector.getConnectionsOpenMax();
    }

    public int getConnectionsOpenMin() {
        return this.connector.getConnectionsOpenMin();
    }

    public long getConnectionsDurationAve() {
        return this.connector.getConnectionsDurationAve();
    }

    public long getConnectionsDurationMax() {
        return this.connector.getConnectionsDurationMax();
    }

    public long getConnectionsDurationMin() {
        return this.connector.getConnectionsDurationMin();
    }

    public long getConnectionsDurationTotal() {
        return this.connector.getConnectionsDurationTotal();
    }

    public long getConnectionsRequestAve() {
        return this.connector.getConnectionsRequestsAve();
    }

    public long getConnectionsRequestMax() {
        return this.connector.getConnectionsRequestsMax();
    }

    public long getConnectionsRequestMin() {
        return this.connector.getConnectionsRequestsMin();
    }

    public void turnStatsOn() {
        this.connector.setStatsOn(true);
    }

    public void turnStatsOff() {
        this.connector.setStatsOn(false);
    }

    public void resetStats() {
        this.connector.statsReset();
    }

    public boolean isStatsOn() {
        return this.connector.getStatsOn();
    }
}

