/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.webapp.AzkabanServer;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;

public class AbstractServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String JSON_MIME_TYPE = "application/json";
    private AzkabanServer application;

    public void init(ServletConfig config) throws ServletException {
        this.application = (AzkabanServer)config.getServletContext().getAttribute("azkaban_app");
        if (this.application == null) {
            throw new IllegalStateException("No batch application is defined in the servlet context!");
        }
    }

    protected void writeJSON(HttpServletResponse resp, Object obj) throws IOException {
        resp.setContentType(JSON_MIME_TYPE);
        ObjectMapper mapper = new ObjectMapper();
        ServletOutputStream stream = resp.getOutputStream();
        mapper.writeValue((OutputStream)stream, obj);
    }

    public boolean hasParam(HttpServletRequest request, String param) {
        return request.getParameter(param) != null;
    }

    public String getParam(HttpServletRequest request, String name) throws ServletException {
        String p = request.getParameter(name);
        if (p == null) {
            throw new ServletException("Missing required parameter '" + name + "'.");
        }
        return p;
    }

    public String getParam(HttpServletRequest request, String name, String defaultVal) {
        String p = request.getParameter(name);
        if (p == null) {
            return defaultVal;
        }
        return p;
    }

    public int getIntParam(HttpServletRequest request, String name) throws ServletException {
        String p = this.getParam(request, name);
        return Integer.parseInt(p);
    }

    public int getIntParam(HttpServletRequest request, String name, int defaultVal) {
        if (this.hasParam(request, name)) {
            try {
                return this.getIntParam(request, name);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public long getLongParam(HttpServletRequest request, String name) throws ServletException {
        String p = this.getParam(request, name);
        return Long.parseLong(p);
    }

    public long getLongParam(HttpServletRequest request, String name, long defaultVal) {
        if (this.hasParam(request, name)) {
            try {
                return this.getLongParam(request, name);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }
}

