/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutionAttempt;
import azkaban.executor.Status;
import azkaban.flow.Node;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.TypedMapWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExecutableNode {
    public static final String ID_PARAM = "id";
    public static final String STATUS_PARAM = "status";
    public static final String STARTTIME_PARAM = "startTime";
    public static final String ENDTIME_PARAM = "endTime";
    public static final String UPDATETIME_PARAM = "updateTime";
    public static final String INNODES_PARAM = "inNodes";
    public static final String OUTNODES_PARAM = "outNodes";
    public static final String TYPE_PARAM = "type";
    public static final String PROPS_SOURCE_PARAM = "propSource";
    public static final String JOB_SOURCE_PARAM = "jobSource";
    public static final String OUTPUT_PROPS_PARAM = "outputProps";
    private String id;
    private String type = null;
    private Status status = Status.READY;
    private long startTime = -1L;
    private long endTime = -1L;
    private long updateTime = -1L;
    private String jobSource;
    private String propsSource;
    private Set<String> inNodes = new HashSet();
    private Set<String> outNodes = new HashSet();
    private Props inputProps;
    private Props outputProps;
    public static final String ATTEMPT_PARAM = "attempt";
    public static final String PASTATTEMPTS_PARAM = "pastAttempts";
    private int attempt = 0;
    private long delayExecution = 0L;
    private ArrayList<ExecutionAttempt> pastAttempts = null;
    private ExecutableFlowBase parentFlow;

    public ExecutableNode(Node node) {
        this.id = node.getId();
        this.jobSource = node.getJobSource();
        this.propsSource = node.getPropsSource();
    }

    public ExecutableNode(Node node, ExecutableFlowBase parent) {
        this(node.getId(), node.getType(), node.getJobSource(), node.getPropsSource(), parent);
    }

    public ExecutableNode(String id, String type, String jobSource, String propsSource, ExecutableFlowBase parent) {
        this.id = id;
        this.jobSource = jobSource;
        this.propsSource = propsSource;
        this.type = type;
        this.setParentFlow(parent);
    }

    public ExecutableNode() {
    }

    public ExecutableFlow getExecutableFlow() {
        if (this.parentFlow == null) {
            return null;
        }
        return this.parentFlow.getExecutableFlow();
    }

    public void setParentFlow(ExecutableFlowBase flow) {
        this.parentFlow = flow;
    }

    public ExecutableFlowBase getParentFlow() {
        return this.parentFlow;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public void addOutNode(String exNode) {
        this.outNodes.add(exNode);
    }

    public void addInNode(String exNode) {
        this.inNodes.add(exNode);
    }

    public Set<String> getOutNodes() {
        return this.outNodes;
    }

    public Set<String> getInNodes() {
        return this.inNodes;
    }

    public boolean hasJobSource() {
        return this.jobSource != null;
    }

    public boolean hasPropsSource() {
        return this.propsSource != null;
    }

    public String getJobSource() {
        return this.jobSource;
    }

    public String getPropsSource() {
        return this.propsSource;
    }

    public void setInputProps(Props input) {
        this.inputProps = input;
    }

    public void setOutputProps(Props output) {
        this.outputProps = output;
    }

    public Props getInputProps() {
        return this.inputProps;
    }

    public Props getOutputProps() {
        return this.outputProps;
    }

    public long getDelayedExecution() {
        return this.delayExecution;
    }

    public void setDelayedExecution(long delayMs) {
        this.delayExecution = delayMs;
    }

    public List<ExecutionAttempt> getPastAttemptList() {
        return this.pastAttempts;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public void setAttempt(int attempt) {
        this.attempt = attempt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetForRetry() {
        ExecutionAttempt pastAttempt = new ExecutionAttempt(this.attempt, this);
        ++this.attempt;
        ExecutableNode executableNode = this;
        synchronized (executableNode) {
            if (this.pastAttempts == null) {
                this.pastAttempts = new ArrayList();
            }
            this.pastAttempts.add(pastAttempt);
        }
        this.setStartTime(-1L);
        this.setEndTime(-1L);
        this.setUpdateTime(System.currentTimeMillis());
        this.setStatus(Status.READY);
    }

    public List<Object> getAttemptObjects() {
        ArrayList<Object> array = new ArrayList<Object>();
        for (ExecutionAttempt attempt : this.pastAttempts) {
            array.add(attempt.toObject());
        }
        return array;
    }

    public String getNestedId() {
        return this.getPrintableId(":");
    }

    public String getPrintableId(String delimiter) {
        if (this.getParentFlow() == null || this.getParentFlow() instanceof ExecutableFlow) {
            return this.getId();
        }
        return String.valueOf(this.getParentFlow().getPrintableId(delimiter)) + delimiter + this.getId();
    }

    public Map<String, Object> toObject() {
        HashMap<String, Object> mapObj = new HashMap<String, Object>();
        this.fillMapFromExecutable(mapObj);
        return mapObj;
    }

    protected void fillMapFromExecutable(Map<String, Object> objMap) {
        objMap.put(ID_PARAM, this.id);
        objMap.put(STATUS_PARAM, this.status.toString());
        objMap.put(STARTTIME_PARAM, this.startTime);
        objMap.put(ENDTIME_PARAM, this.endTime);
        objMap.put(UPDATETIME_PARAM, this.updateTime);
        objMap.put(TYPE_PARAM, this.type);
        objMap.put(ATTEMPT_PARAM, this.attempt);
        if (this.inNodes != null && !this.inNodes.isEmpty()) {
            objMap.put(INNODES_PARAM, this.inNodes);
        }
        if (this.outNodes != null && !this.outNodes.isEmpty()) {
            objMap.put(OUTNODES_PARAM, this.outNodes);
        }
        if (this.hasPropsSource()) {
            objMap.put(PROPS_SOURCE_PARAM, this.propsSource);
        }
        if (this.hasJobSource()) {
            objMap.put(JOB_SOURCE_PARAM, this.jobSource);
        }
        if (this.outputProps != null && this.outputProps.size() > 0) {
            objMap.put(OUTPUT_PROPS_PARAM, PropsUtils.toStringMap((Props)this.outputProps, (boolean)true));
        }
        if (this.pastAttempts != null) {
            ArrayList<Map> attemptsList = new ArrayList<Map>(this.pastAttempts.size());
            for (ExecutionAttempt attempts : this.pastAttempts) {
                attemptsList.add(attempts.toObject());
            }
            objMap.put(PASTATTEMPTS_PARAM, attemptsList);
        }
    }

    public void fillExecutableFromMapObject(TypedMapWrapper<String, Object> wrappedMap) {
        Collection pastAttempts;
        this.id = wrappedMap.getString((Object)ID_PARAM);
        this.type = wrappedMap.getString((Object)TYPE_PARAM);
        this.status = Status.valueOf((String)wrappedMap.getString((Object)STATUS_PARAM));
        this.startTime = wrappedMap.getLong((Object)STARTTIME_PARAM);
        this.endTime = wrappedMap.getLong((Object)ENDTIME_PARAM);
        this.updateTime = wrappedMap.getLong((Object)UPDATETIME_PARAM);
        this.attempt = wrappedMap.getInt((Object)ATTEMPT_PARAM, Integer.valueOf(0));
        this.inNodes = new HashSet();
        this.inNodes.addAll(wrappedMap.getStringCollection((Object)INNODES_PARAM, Collections.emptySet()));
        this.outNodes = new HashSet();
        this.outNodes.addAll(wrappedMap.getStringCollection((Object)OUTNODES_PARAM, Collections.emptySet()));
        this.propsSource = wrappedMap.getString((Object)PROPS_SOURCE_PARAM);
        this.jobSource = wrappedMap.getString((Object)JOB_SOURCE_PARAM);
        Map outputProps = wrappedMap.getMap((Object)OUTPUT_PROPS_PARAM);
        if (outputProps != null) {
            this.outputProps = new Props(null, new Map[]{outputProps});
        }
        if ((pastAttempts = wrappedMap.getCollection((Object)PASTATTEMPTS_PARAM)) != null) {
            ArrayList<ExecutionAttempt> attempts = new ArrayList<ExecutionAttempt>();
            for (Object attemptObj : pastAttempts) {
                ExecutionAttempt attempt = ExecutionAttempt.fromObject(attemptObj);
                attempts.add(attempt);
            }
            this.pastAttempts = attempts;
        }
    }

    public void fillExecutableFromMapObject(Map<String, Object> objMap) {
        TypedMapWrapper wrapper = new TypedMapWrapper(objMap);
        this.fillExecutableFromMapObject(wrapper);
    }

    public Map<String, Object> toUpdateObject() {
        HashMap<String, Object> updatedNodeMap = new HashMap<String, Object>();
        updatedNodeMap.put(ID_PARAM, this.getId());
        updatedNodeMap.put(STATUS_PARAM, this.getStatus().getNumVal());
        updatedNodeMap.put(STARTTIME_PARAM, this.getStartTime());
        updatedNodeMap.put(ENDTIME_PARAM, this.getEndTime());
        updatedNodeMap.put(UPDATETIME_PARAM, this.getUpdateTime());
        updatedNodeMap.put(ATTEMPT_PARAM, this.getAttempt());
        if (this.getAttempt() > 0) {
            ArrayList<Map> pastAttempts = new ArrayList<Map>();
            for (ExecutionAttempt attempt : this.getPastAttemptList()) {
                pastAttempts.add(attempt.toObject());
            }
            updatedNodeMap.put(PASTATTEMPTS_PARAM, pastAttempts);
        }
        return updatedNodeMap;
    }

    public void applyUpdateObject(TypedMapWrapper<String, Object> updateData) {
        this.status = Status.fromInteger((int)updateData.getInt((Object)STATUS_PARAM, Integer.valueOf(this.status.getNumVal())));
        this.startTime = updateData.getLong((Object)STARTTIME_PARAM);
        this.updateTime = updateData.getLong((Object)UPDATETIME_PARAM);
        this.endTime = updateData.getLong((Object)ENDTIME_PARAM);
        if (updateData.containsKey((Object)ATTEMPT_PARAM)) {
            this.attempt = updateData.getInt((Object)ATTEMPT_PARAM);
            if (this.attempt > 0) {
                this.updatePastAttempts(updateData.getList((Object)PASTATTEMPTS_PARAM, Collections.emptyList()));
            }
        }
    }

    public void applyUpdateObject(Map<String, Object> updateData) {
        TypedMapWrapper wrapper = new TypedMapWrapper(updateData);
        this.applyUpdateObject(wrapper);
    }

    public void cancelNode(long cancelTime) {
        if (this.status == Status.DISABLED) {
            this.skipNode(cancelTime);
        } else {
            this.setStatus(Status.CANCELLED);
            this.setStartTime(cancelTime);
            this.setEndTime(cancelTime);
            this.setUpdateTime(cancelTime);
        }
    }

    public void skipNode(long skipTime) {
        this.setStatus(Status.SKIPPED);
        this.setStartTime(skipTime);
        this.setEndTime(skipTime);
        this.setUpdateTime(skipTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePastAttempts(List<Object> pastAttemptsList) {
        if (pastAttemptsList == null) {
            return;
        }
        ExecutableNode executableNode = this;
        synchronized (executableNode) {
            if (this.pastAttempts == null) {
                this.pastAttempts = new ArrayList();
            }
            if (pastAttemptsList.size() <= this.pastAttempts.size()) {
                return;
            }
            Object[] pastAttemptArray = pastAttemptsList.toArray();
            int i = this.pastAttempts.size();
            while (i < pastAttemptArray.length) {
                ExecutionAttempt attempt = ExecutionAttempt.fromObject((Object)pastAttemptArray[i]);
                this.pastAttempts.add(attempt);
                ++i;
            }
        }
    }

    public int getRetries() {
        return this.inputProps.getInt("retries", 0);
    }

    public long getRetryBackoff() {
        return this.inputProps.getLong("retry.backoff", 0L);
    }
}

