/*
 * Decompiled with CFR 0.152.
 */
package azkaban.restli;

import azkaban.restli.user.User;
import azkaban.user.UserManager;
import azkaban.user.UserManagerException;
import azkaban.webapp.AzkabanWebServer;
import azkaban.webapp.session.Session;
import com.linkedin.restli.server.annotations.Action;
import com.linkedin.restli.server.annotations.ActionParam;
import com.linkedin.restli.server.annotations.RestLiActions;
import com.linkedin.restli.server.resources.ResourceContextHolder;
import java.util.UUID;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

@RestLiActions(name="user", namespace="azkaban.restli")
public class UserManagerResource
extends ResourceContextHolder {
    private static final Logger logger = Logger.getLogger(UserManagerResource.class);

    public AzkabanWebServer getAzkaban() {
        return AzkabanWebServer.getInstance();
    }

    @Action(name="login")
    public String login(@ActionParam(value="username") String username, @ActionParam(value="password") String password) throws UserManagerException, ServletException {
        String ip = (String)this.getContext().getRawRequestContext().getLocalAttr("REMOTE_ADDR");
        logger.info((Object)("Attempting to login for " + username + " from ip '" + ip + "'"));
        Session session = this.createSession(username, password, ip);
        logger.info((Object)("Session id " + session.getSessionId() + " created for user '" + username + "' and ip " + ip));
        return session.getSessionId();
    }

    @Action(name="getUserFromSessionId")
    public User getUserFromSessionId(@ActionParam(value="sessionId") String sessionId) {
        String ip = (String)this.getContext().getRawRequestContext().getLocalAttr("REMOTE_ADDR");
        Session session = this.getSessionFromSessionId(sessionId, ip);
        azkaban.user.User azUser = session.getUser();
        User user = new User();
        user.setUserId(azUser.getUserId());
        user.setEmail(azUser.getEmail());
        return user;
    }

    private Session createSession(String username, String password, String ip) throws UserManagerException, ServletException {
        UserManager manager = this.getAzkaban().getUserManager();
        azkaban.user.User user = manager.getUser(username, password);
        String randomUID = UUID.randomUUID().toString();
        Session session = new Session(randomUID, user, ip);
        this.getAzkaban().getSessionCache().addSession(session);
        return session;
    }

    private Session getSessionFromSessionId(String sessionId, String remoteIp) {
        if (sessionId == null) {
            return null;
        }
        Session session = this.getAzkaban().getSessionCache().getSession(sessionId);
        if (session == null || !remoteIp.equals(session.getIp())) {
            return null;
        }
        return session;
    }
}

