/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.database.AbstractJdbcLoader;
import azkaban.flow.Flow;
import azkaban.project.JdbcProjectLoader;
import azkaban.project.Project;
import azkaban.project.ProjectFileHandler;
import azkaban.project.ProjectLoader;
import azkaban.project.ProjectLogEvent;
import azkaban.project.ProjectManagerException;
import azkaban.user.Permission;
import azkaban.user.User;
import azkaban.utils.GZIPUtils;
import azkaban.utils.JSONUtils;
import azkaban.utils.Md5Hasher;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.Triple;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class JdbcProjectLoader
extends AbstractJdbcLoader
implements ProjectLoader {
    private static final Logger logger = Logger.getLogger(JdbcProjectLoader.class);
    private static final int CHUCK_SIZE = 0xA00000;
    private File tempDir;
    private AbstractJdbcLoader.EncodingType defaultEncodingType = AbstractJdbcLoader.EncodingType.GZIP;

    public JdbcProjectLoader(Props props) {
        super(props);
        this.tempDir = new File(props.getString("project.temp.dir", "temp"));
        if (!this.tempDir.exists()) {
            this.tempDir.mkdirs();
        }
    }

    public List<Project> fetchAllActiveProjects() throws ProjectManagerException {
        Connection connection = this.getConnection();
        List projects = null;
        try {
            projects = this.fetchAllActiveProjects(connection);
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        return projects;
    }

    private List<Project> fetchAllActiveProjects(Connection connection) throws ProjectManagerException {
        QueryRunner runner = new QueryRunner();
        ProjectResultHandler handler = new ProjectResultHandler(null);
        List projects = null;
        try {
            try {
                projects = (List)runner.query(connection, ProjectResultHandler.access$2(), (ResultSetHandler)handler);
                for (Project project : projects) {
                    List permissions = this.fetchPermissionsForProject(connection, project);
                    for (Triple entry : permissions) {
                        if (((Boolean)entry.getSecond()).booleanValue()) {
                            project.setGroupPermission((String)entry.getFirst(), (Permission)entry.getThird());
                            continue;
                        }
                        project.setUserPermission((String)entry.getFirst(), (Permission)entry.getThird());
                    }
                }
            }
            catch (SQLException e) {
                throw new ProjectManagerException("Error retrieving all projects", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        return projects;
    }

    public Project fetchProjectById(int id) throws ProjectManagerException {
        Connection connection = this.getConnection();
        Project project = null;
        try {
            project = this.fetchProjectById(connection, id);
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        return project;
    }

    private Project fetchProjectById(Connection connection, int id) throws ProjectManagerException {
        QueryRunner runner = new QueryRunner();
        Project project = null;
        ProjectResultHandler handler = new ProjectResultHandler(null);
        try {
            List projects = (List)runner.query(connection, ProjectResultHandler.access$3(), (ResultSetHandler)handler, new Object[]{id});
            if (projects.isEmpty()) {
                throw new ProjectManagerException("No active project with id " + id + " exists in db.");
            }
            project = (Project)projects.get(0);
        }
        catch (SQLException e) {
            logger.error((Object)(String.valueOf(ProjectResultHandler.access$3()) + " failed."));
            throw new ProjectManagerException("Query for existing project failed. Project " + id, (Throwable)e);
        }
        List permissions = this.fetchPermissionsForProject(connection, project);
        for (Triple perm : permissions) {
            if (((Permission)perm.getThird()).toFlags() == 0) continue;
            if (((Boolean)perm.getSecond()).booleanValue()) {
                project.setGroupPermission((String)perm.getFirst(), (Permission)perm.getThird());
                continue;
            }
            project.setUserPermission((String)perm.getFirst(), (Permission)perm.getThird());
        }
        return project;
    }

    private List<Triple<String, Boolean, Permission>> fetchPermissionsForProject(Connection connection, Project project) throws ProjectManagerException {
        ProjectPermissionsResultHandler permHander = new ProjectPermissionsResultHandler(null);
        QueryRunner runner = new QueryRunner();
        List permissions = null;
        try {
            permissions = (List)runner.query(connection, ProjectPermissionsResultHandler.access$2(), (ResultSetHandler)permHander, new Object[]{project.getId()});
        }
        catch (SQLException e) {
            throw new ProjectManagerException("Query for permissions for " + project.getName() + " failed.", (Throwable)e);
        }
        return permissions;
    }

    public Project createNewProject(String name, String description, User creator) throws ProjectManagerException {
        Project project;
        Connection connection = this.getConnection();
        try {
            project = this.createNewProject(connection, name, description, creator);
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        return project;
    }

    private synchronized Project createNewProject(Connection connection, String name, String description, User creator) throws ProjectManagerException {
        QueryRunner runner = new QueryRunner();
        ProjectResultHandler handler = new ProjectResultHandler(null);
        try {
            List project = (List)runner.query(connection, ProjectResultHandler.access$4(), (ResultSetHandler)handler, new Object[]{name});
            if (!project.isEmpty()) {
                throw new ProjectManagerException("Active project with name " + name + " already exists in db.");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new ProjectManagerException("Checking for existing project failed. " + name, (Throwable)e);
        }
        String INSERT_PROJECT = "INSERT INTO projects ( name, active, modified_time, create_time, version, last_modified_by, description, enc_type, settings_blob) values (?,?,?,?,?,?,?,?,?)";
        try {
            long time = System.currentTimeMillis();
            int i = runner.update(connection, "INSERT INTO projects ( name, active, modified_time, create_time, version, last_modified_by, description, enc_type, settings_blob) values (?,?,?,?,?,?,?,?,?)", new Object[]{name, true, time, time, null, creator.getUserId(), description, this.defaultEncodingType.getNumVal(), null});
            if (i == 0) {
                throw new ProjectManagerException("No projects have been inserted.");
            }
            connection.commit();
        }
        catch (SQLException e) {
            logger.error((Object)"INSERT INTO projects ( name, active, modified_time, create_time, version, last_modified_by, description, enc_type, settings_blob) values (?,?,?,?,?,?,?,?,?) failed.");
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            throw new ProjectManagerException("Insert project for existing project failed. " + name, (Throwable)e);
        }
        Project project = null;
        try {
            List projects = (List)runner.query(connection, ProjectResultHandler.access$4(), (ResultSetHandler)handler, new Object[]{name});
            if (projects.isEmpty()) {
                throw new ProjectManagerException("No active project with name " + name + " exists in db.");
            }
            if (projects.size() > 1) {
                throw new ProjectManagerException("More than one active project " + name);
            }
            project = (Project)projects.get(0);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new ProjectManagerException("Checking for existing project failed. " + name, (Throwable)e);
        }
        return project;
    }

    public void uploadProjectFile(Project project, int version, String filetype, String filename, File localFile, String uploader) throws ProjectManagerException {
        logger.info((Object)("Uploading to " + project.getName() + " version:" + version + " file:" + filename));
        Connection connection = this.getConnection();
        try {
            try {
                this.uploadProjectFile(connection, project, version, filetype, filename, localFile, uploader);
                connection.commit();
                logger.info((Object)("Commiting upload " + localFile.getName()));
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new ProjectManagerException("Error getting DB connection.", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    private void uploadProjectFile(Connection connection, Project project, int version, String filetype, String filename, File localFile, String uploader) throws ProjectManagerException {
        QueryRunner runner = new QueryRunner();
        long updateTime = System.currentTimeMillis();
        logger.info((Object)("Creating message digest for upload " + localFile.getName()));
        byte[] md5 = null;
        try {
            md5 = Md5Hasher.md5Hash((File)localFile);
        }
        catch (IOException e) {
            throw new ProjectManagerException("Error getting md5 hash.", (Throwable)e);
        }
        logger.info((Object)"Md5 hash created");
        byte[] buffer = new byte[0xA00000];
        String INSERT_PROJECT_FILES = "INSERT INTO project_files (project_id, version, chunk, size, file) values (?,?,?,?,?)";
        BufferedInputStream bufferedStream = null;
        int chunk = 0;
        try {
            try {
                bufferedStream = new BufferedInputStream(new FileInputStream(localFile));
                int size = bufferedStream.read(buffer);
                while (size >= 0) {
                    logger.info((Object)("Read bytes for " + filename + " size:" + size));
                    byte[] buf = buffer;
                    if (size < buffer.length) {
                        buf = Arrays.copyOfRange(buffer, 0, size);
                    }
                    try {
                        logger.info((Object)("Running update for " + filename + " chunk " + chunk));
                        runner.update(connection, "INSERT INTO project_files (project_id, version, chunk, size, file) values (?,?,?,?,?)", new Object[]{project.getId(), version, chunk, size, buf});
                        logger.info((Object)("Finished update for " + filename + " chunk " + chunk));
                    }
                    catch (SQLException e) {
                        throw new ProjectManagerException("Error chunking", (Throwable)e);
                    }
                    ++chunk;
                    size = bufferedStream.read(buffer);
                }
            }
            catch (IOException e) {
                throw new ProjectManagerException("Error chunking file " + filename);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bufferedStream);
        String INSERT_PROJECT_VERSION = "INSERT INTO project_versions (project_id, version, upload_time, uploader, file_type, file_name, md5, num_chunks) values (?,?,?,?,?,?,?,?)";
        try {
            runner.update(connection, "INSERT INTO project_versions (project_id, version, upload_time, uploader, file_type, file_name, md5, num_chunks) values (?,?,?,?,?,?,?,?)", new Object[]{project.getId(), version, updateTime, uploader, filetype, filename, md5, chunk});
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new ProjectManagerException("Error updating project version " + project.getName(), (Throwable)e);
        }
    }

    public ProjectFileHandler getUploadedFile(Project project, int version) throws ProjectManagerException {
        logger.info((Object)("Retrieving to " + project.getName() + " version:" + version));
        Connection connection = this.getConnection();
        ProjectFileHandler handler = null;
        try {
            handler = this.getUploadedFile(connection, project.getId(), version);
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        return handler;
    }

    public ProjectFileHandler getUploadedFile(int projectId, int version) throws ProjectManagerException {
        logger.info((Object)("Retrieving to " + projectId + " version:" + version));
        Connection connection = this.getConnection();
        ProjectFileHandler handler = null;
        try {
            handler = this.getUploadedFile(connection, projectId, version);
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        return handler;
    }

    private ProjectFileHandler getUploadedFile(Connection connection, int projectId, int version) throws ProjectManagerException {
        QueryRunner runner = new QueryRunner();
        ProjectVersionResultHandler pfHandler = new ProjectVersionResultHandler(null);
        List projectFiles = null;
        try {
            projectFiles = (List)runner.query(connection, ProjectVersionResultHandler.access$2(), (ResultSetHandler)pfHandler, new Object[]{projectId, version});
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new ProjectManagerException("Query for uploaded file for project id " + projectId + " failed.", (Throwable)e);
        }
        if (projectFiles == null || projectFiles.isEmpty()) {
            return null;
        }
        ProjectFileHandler projHandler = (ProjectFileHandler)projectFiles.get(0);
        int numChunks = projHandler.getNumChunks();
        BufferedOutputStream bStream = null;
        File file = null;
        try {
            try {
                file = File.createTempFile(projHandler.getFileName(), String.valueOf(version), this.tempDir);
                bStream = new BufferedOutputStream(new FileOutputStream(file));
            }
            catch (IOException e) {
                throw new ProjectManagerException("Error creating temp file for stream.");
            }
            int collect = 5;
            int fromChunk = 0;
            int toChunk = collect;
            do {
                ProjectFileChunkResultHandler chunkHandler = new ProjectFileChunkResultHandler(null);
                List data = null;
                try {
                    data = (List)runner.query(connection, ProjectFileChunkResultHandler.access$2(), (ResultSetHandler)chunkHandler, new Object[]{projectId, version, fromChunk, toChunk});
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new ProjectManagerException("Query for uploaded file for " + projectId + " failed.", (Throwable)e);
                }
                try {
                    for (byte[] d : data) {
                        bStream.write(d);
                    }
                }
                catch (IOException e) {
                    throw new ProjectManagerException("Error writing file", (Throwable)e);
                }
                toChunk += collect;
            } while ((fromChunk += collect) <= numChunks);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)bStream);
        byte[] md5 = null;
        try {
            md5 = Md5Hasher.md5Hash((File)file);
        }
        catch (IOException e) {
            throw new ProjectManagerException("Error getting md5 hash.", (Throwable)e);
        }
        if (!Arrays.equals(projHandler.getMd5Hash(), md5)) {
            throw new ProjectManagerException("Md5 Hash failed on retrieval of file");
        }
        logger.info((Object)"Md5 Hash is valid");
        projHandler.setLocalFile(file);
        return projHandler;
    }

    public void changeProjectVersion(Project project, int version, String user) throws ProjectManagerException {
        long timestamp = System.currentTimeMillis();
        QueryRunner runner = this.createQueryRunner();
        try {
            String UPDATE_PROJECT_VERSION = "UPDATE projects SET version=?,modified_time=?,last_modified_by=? WHERE id=?";
            runner.update("UPDATE projects SET version=?,modified_time=?,last_modified_by=? WHERE id=?", new Object[]{version, timestamp, user, project.getId()});
            project.setVersion(version);
            project.setLastModifiedTimestamp(timestamp);
            project.setLastModifiedUser(user);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new ProjectManagerException("Error updating switching project version " + project.getName(), (Throwable)e);
        }
    }

    public void updatePermission(Project project, String name, Permission perm, boolean isGroup) throws ProjectManagerException {
        QueryRunner runner = this.createQueryRunner();
        if (this.allowsOnDuplicateKey()) {
            long updateTime = System.currentTimeMillis();
            String INSERT_PROJECT_PERMISSION = "INSERT INTO project_permissions (project_id, modified_time, name, permissions, isGroup) values (?,?,?,?,?)ON DUPLICATE KEY UPDATE modified_time = VALUES(modified_time), permissions = VALUES(permissions)";
            try {
                runner.update("INSERT INTO project_permissions (project_id, modified_time, name, permissions, isGroup) values (?,?,?,?,?)ON DUPLICATE KEY UPDATE modified_time = VALUES(modified_time), permissions = VALUES(permissions)", new Object[]{project.getId(), updateTime, name, perm.toFlags(), isGroup});
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new ProjectManagerException("Error updating project " + project.getName() + " permissions for " + name, (Throwable)e);
            }
        }
        long updateTime = System.currentTimeMillis();
        String MERGE_PROJECT_PERMISSION = "MERGE INTO project_permissions (project_id, modified_time, name, permissions, isGroup) KEY (project_id, name) values (?,?,?,?,?)";
        try {
            runner.update("MERGE INTO project_permissions (project_id, modified_time, name, permissions, isGroup) KEY (project_id, name) values (?,?,?,?,?)", new Object[]{project.getId(), updateTime, name, perm.toFlags(), isGroup});
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new ProjectManagerException("Error updating project " + project.getName() + " permissions for " + name, (Throwable)e);
        }
        if (isGroup) {
            project.setGroupPermission(name, perm);
        } else {
            project.setUserPermission(name, perm);
        }
    }

    public void updateProjectSettings(Project project) throws ProjectManagerException {
        Connection connection = this.getConnection();
        try {
            try {
                this.updateProjectSettings(connection, project, this.defaultEncodingType);
                connection.commit();
            }
            catch (SQLException e) {
                throw new ProjectManagerException("Error updating project settings", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    private void updateProjectSettings(Connection connection, Project project, AbstractJdbcLoader.EncodingType encType) throws ProjectManagerException {
        QueryRunner runner = new QueryRunner();
        String UPDATE_PROJECT_SETTINGS = "UPDATE projects SET enc_type=?, settings_blob=? WHERE id=?";
        String json = JSONUtils.toJSON((Object)project.toObject());
        byte[] data = null;
        try {
            byte[] stringData;
            data = stringData = json.getBytes("UTF-8");
            if (encType == AbstractJdbcLoader.EncodingType.GZIP) {
                data = GZIPUtils.gzipBytes((byte[])stringData);
            }
            logger.debug((Object)("NumChars: " + json.length() + " UTF-8:" + stringData.length + " Gzip:" + data.length));
        }
        catch (IOException e) {
            throw new ProjectManagerException("Failed to encode. ", (Throwable)e);
        }
        try {
            runner.update(connection, "UPDATE projects SET enc_type=?, settings_blob=? WHERE id=?", new Object[]{encType.getNumVal(), data, project.getId()});
            connection.commit();
        }
        catch (SQLException e) {
            throw new ProjectManagerException("Error updating project " + project.getName() + " version " + project.getVersion(), (Throwable)e);
        }
    }

    public void removePermission(Project project, String name, boolean isGroup) throws ProjectManagerException {
        QueryRunner runner = this.createQueryRunner();
        String DELETE_PROJECT_PERMISSION = "DELETE FROM project_permissions WHERE project_id=? AND name=? AND isGroup=?";
        try {
            runner.update("DELETE FROM project_permissions WHERE project_id=? AND name=? AND isGroup=?", new Object[]{project.getId(), name, isGroup});
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new ProjectManagerException("Error deleting project " + project.getName() + " permissions for " + name, (Throwable)e);
        }
        if (isGroup) {
            project.removeGroupPermission(name);
        } else {
            project.removeUserPermission(name);
        }
    }

    public List<Triple<String, Boolean, Permission>> getProjectPermissions(int projectId) throws ProjectManagerException {
        ProjectPermissionsResultHandler permHander = new ProjectPermissionsResultHandler(null);
        QueryRunner runner = this.createQueryRunner();
        List permissions = null;
        try {
            permissions = (List)runner.query(ProjectPermissionsResultHandler.access$2(), (ResultSetHandler)permHander, new Object[]{projectId});
        }
        catch (SQLException e) {
            throw new ProjectManagerException("Query for permissions for " + projectId + " failed.", (Throwable)e);
        }
        return permissions;
    }

    public void removeProject(Project project, String user) throws ProjectManagerException {
        QueryRunner runner = this.createQueryRunner();
        long updateTime = System.currentTimeMillis();
        String UPDATE_INACTIVE_PROJECT = "UPDATE projects SET active=false,modified_time=?,last_modified_by=? WHERE id=?";
        try {
            runner.update("UPDATE projects SET active=false,modified_time=?,last_modified_by=? WHERE id=?", new Object[]{updateTime, user, project.getId()});
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new ProjectManagerException("Error marking project " + project.getName() + " as inactive", (Throwable)e);
        }
    }

    public boolean postEvent(Project project, ProjectLogEvent.EventType type, String user, String message) {
        QueryRunner runner = this.createQueryRunner();
        String INSERT_PROJECT_EVENTS = "INSERT INTO project_events (project_id, event_type, event_time, username, message) values (?,?,?,?,?)";
        long updateTime = System.currentTimeMillis();
        try {
            runner.update("INSERT INTO project_events (project_id, event_type, event_time, username, message) values (?,?,?,?,?)", new Object[]{project.getId(), type.getNumVal(), updateTime, user, message});
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public List<ProjectLogEvent> getProjectEvents(Project project, int num, int skip) throws ProjectManagerException {
        QueryRunner runner = this.createQueryRunner();
        ProjectLogsResultHandler logHandler = new ProjectLogsResultHandler(null);
        List events = null;
        try {
            events = (List)runner.query(ProjectLogsResultHandler.access$2(), (ResultSetHandler)logHandler, new Object[]{project.getId(), num, skip});
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return events;
    }

    public void updateDescription(Project project, String description, String user) throws ProjectManagerException {
        QueryRunner runner = this.createQueryRunner();
        String UPDATE_PROJECT_DESCRIPTION = "UPDATE projects SET description=?,modified_time=?,last_modified_by=? WHERE id=?";
        long updateTime = System.currentTimeMillis();
        try {
            runner.update("UPDATE projects SET description=?,modified_time=?,last_modified_by=? WHERE id=?", new Object[]{description, updateTime, user, project.getId()});
            project.setDescription(description);
            project.setLastModifiedTimestamp(updateTime);
            project.setLastModifiedUser(user);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new ProjectManagerException("Error marking project " + project.getName() + " as inactive", (Throwable)e);
        }
    }

    public int getLatestProjectVersion(Project project) throws ProjectManagerException {
        QueryRunner runner = this.createQueryRunner();
        IntHander handler = new IntHander(null);
        try {
            return (Integer)runner.query(IntHander.access$2(), (ResultSetHandler)handler, new Object[]{project.getId()});
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new ProjectManagerException("Error marking project " + project.getName() + " as inactive", (Throwable)e);
        }
    }

    public void uploadFlows(Project project, int version, Collection<Flow> flows) throws ProjectManagerException {
        logger.info((Object)"Uploading flows");
        Connection connection = this.getConnection();
        try {
            try {
                for (Flow flow : flows) {
                    this.uploadFlow(connection, project, version, flow, this.defaultEncodingType);
                }
                connection.commit();
            }
            catch (IOException e) {
                throw new ProjectManagerException("Flow Upload failed.", (Throwable)e);
            }
            catch (SQLException e) {
                throw new ProjectManagerException("Flow Upload failed.", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    public void uploadFlow(Project project, int version, Flow flow) throws ProjectManagerException {
        logger.info((Object)"Uploading flows");
        Connection connection = this.getConnection();
        try {
            try {
                this.uploadFlow(connection, project, version, flow, this.defaultEncodingType);
                connection.commit();
            }
            catch (IOException e) {
                throw new ProjectManagerException("Flow Upload failed.", (Throwable)e);
            }
            catch (SQLException e) {
                throw new ProjectManagerException("Flow Upload failed commit.", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    public void updateFlow(Project project, int version, Flow flow) throws ProjectManagerException {
        logger.info((Object)"Uploading flows");
        Connection connection = this.getConnection();
        try {
            try {
                byte[] stringData;
                QueryRunner runner = new QueryRunner();
                String json = JSONUtils.toJSON((Object)flow.toObject());
                byte[] data = stringData = json.getBytes("UTF-8");
                logger.info((Object)("UTF-8 size:" + data.length));
                if (this.defaultEncodingType == AbstractJdbcLoader.EncodingType.GZIP) {
                    data = GZIPUtils.gzipBytes((byte[])stringData);
                }
                logger.info((Object)("Flow upload " + flow.getId() + " is byte size " + data.length));
                String UPDATE_FLOW = "UPDATE project_flows SET encoding_type=?,json=? WHERE project_id=? AND version=? AND flow_id=?";
                try {
                    runner.update(connection, "UPDATE project_flows SET encoding_type=?,json=? WHERE project_id=? AND version=? AND flow_id=?", new Object[]{this.defaultEncodingType.getNumVal(), data, project.getId(), version, flow.getId()});
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new ProjectManagerException("Error inserting flow " + flow.getId(), (Throwable)e);
                }
                connection.commit();
            }
            catch (IOException e) {
                throw new ProjectManagerException("Flow Upload failed.", (Throwable)e);
            }
            catch (SQLException e) {
                throw new ProjectManagerException("Flow Upload failed commit.", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    public AbstractJdbcLoader.EncodingType getDefaultEncodingType() {
        return this.defaultEncodingType;
    }

    public void setDefaultEncodingType(AbstractJdbcLoader.EncodingType defaultEncodingType) {
        this.defaultEncodingType = defaultEncodingType;
    }

    private void uploadFlow(Connection connection, Project project, int version, Flow flow, AbstractJdbcLoader.EncodingType encType) throws ProjectManagerException, IOException {
        byte[] stringData;
        QueryRunner runner = new QueryRunner();
        String json = JSONUtils.toJSON((Object)flow.toObject());
        byte[] data = stringData = json.getBytes("UTF-8");
        logger.info((Object)("UTF-8 size:" + data.length));
        if (encType == AbstractJdbcLoader.EncodingType.GZIP) {
            data = GZIPUtils.gzipBytes((byte[])stringData);
        }
        logger.info((Object)("Flow upload " + flow.getId() + " is byte size " + data.length));
        String INSERT_FLOW = "INSERT INTO project_flows (project_id, version, flow_id, modified_time, encoding_type, json) values (?,?,?,?,?,?)";
        try {
            runner.update(connection, "INSERT INTO project_flows (project_id, version, flow_id, modified_time, encoding_type, json) values (?,?,?,?,?,?)", new Object[]{project.getId(), version, flow.getId(), System.currentTimeMillis(), encType.getNumVal(), data});
        }
        catch (SQLException e) {
            throw new ProjectManagerException("Error inserting flow " + flow.getId(), (Throwable)e);
        }
    }

    public Flow fetchFlow(Project project, String flowId) throws ProjectManagerException {
        List flows;
        block3: {
            QueryRunner runner = this.createQueryRunner();
            ProjectFlowsResultHandler handler = new ProjectFlowsResultHandler(null);
            try {
                flows = (List)runner.query(ProjectFlowsResultHandler.access$2(), (ResultSetHandler)handler, new Object[]{project.getId(), project.getVersion(), flowId});
                if (!flows.isEmpty()) break block3;
                return null;
            }
            catch (SQLException e) {
                throw new ProjectManagerException("Error fetching flow " + flowId, (Throwable)e);
            }
        }
        return (Flow)flows.get(0);
    }

    public List<Flow> fetchAllProjectFlows(Project project) throws ProjectManagerException {
        QueryRunner runner = this.createQueryRunner();
        ProjectFlowsResultHandler handler = new ProjectFlowsResultHandler(null);
        List flows = null;
        try {
            flows = (List)runner.query(ProjectFlowsResultHandler.access$3(), (ResultSetHandler)handler, new Object[]{project.getId(), project.getVersion()});
        }
        catch (SQLException e) {
            throw new ProjectManagerException("Error fetching flows from project " + project.getName() + " version " + project.getVersion(), (Throwable)e);
        }
        return flows;
    }

    public void uploadProjectProperties(Project project, List<Props> properties) throws ProjectManagerException {
        Connection connection = this.getConnection();
        try {
            try {
                for (Props props : properties) {
                    this.uploadProjectProperty(connection, project, props.getSource(), props);
                }
                connection.commit();
            }
            catch (SQLException e) {
                throw new ProjectManagerException("Error uploading project property files", (Throwable)e);
            }
            catch (IOException e) {
                throw new ProjectManagerException("Error uploading project property files", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    public void uploadProjectProperty(Project project, Props props) throws ProjectManagerException {
        Connection connection = this.getConnection();
        try {
            try {
                this.uploadProjectProperty(connection, project, props.getSource(), props);
                connection.commit();
            }
            catch (SQLException e) {
                throw new ProjectManagerException("Error uploading project property files", (Throwable)e);
            }
            catch (IOException e) {
                throw new ProjectManagerException("Error uploading project property file", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    public void updateProjectProperty(Project project, Props props) throws ProjectManagerException {
        Connection connection = this.getConnection();
        try {
            try {
                this.updateProjectProperty(connection, project, props.getSource(), props);
                connection.commit();
            }
            catch (SQLException e) {
                throw new ProjectManagerException("Error uploading project property files", (Throwable)e);
            }
            catch (IOException e) {
                throw new ProjectManagerException("Error uploading project property file", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    private void updateProjectProperty(Connection connection, Project project, String name, Props props) throws ProjectManagerException, IOException {
        QueryRunner runner = new QueryRunner();
        String UPDATE_PROPERTIES = "UPDATE project_properties SET property=? WHERE project_id=? AND version=? AND name=?";
        String propertyJSON = PropsUtils.toJSONString((Props)props, (boolean)true);
        byte[] data = propertyJSON.getBytes("UTF-8");
        logger.info((Object)("UTF-8 size:" + data.length));
        if (this.defaultEncodingType == AbstractJdbcLoader.EncodingType.GZIP) {
            data = GZIPUtils.gzipBytes((byte[])data);
        }
        try {
            runner.update(connection, "UPDATE project_properties SET property=? WHERE project_id=? AND version=? AND name=?", new Object[]{data, project.getId(), project.getVersion(), name});
            connection.commit();
        }
        catch (SQLException e) {
            throw new ProjectManagerException("Error updating property " + project.getName() + " version " + project.getVersion(), (Throwable)e);
        }
    }

    private void uploadProjectProperty(Connection connection, Project project, String name, Props props) throws ProjectManagerException, IOException {
        QueryRunner runner = new QueryRunner();
        String INSERT_PROPERTIES = "INSERT INTO project_properties (project_id, version, name, modified_time, encoding_type, property) values (?,?,?,?,?,?)";
        String propertyJSON = PropsUtils.toJSONString((Props)props, (boolean)true);
        byte[] data = propertyJSON.getBytes("UTF-8");
        logger.info((Object)("UTF-8 size:" + data.length));
        if (this.defaultEncodingType == AbstractJdbcLoader.EncodingType.GZIP) {
            data = GZIPUtils.gzipBytes((byte[])data);
        }
        try {
            runner.update(connection, "INSERT INTO project_properties (project_id, version, name, modified_time, encoding_type, property) values (?,?,?,?,?,?)", new Object[]{project.getId(), project.getVersion(), name, System.currentTimeMillis(), this.defaultEncodingType.getNumVal(), data});
            connection.commit();
        }
        catch (SQLException e) {
            throw new ProjectManagerException("Error uploading project properties " + name + " into " + project.getName() + " version " + project.getVersion(), (Throwable)e);
        }
    }

    public Props fetchProjectProperty(int projectId, int projectVer, String propsName) throws ProjectManagerException {
        List properties;
        block3: {
            QueryRunner runner = this.createQueryRunner();
            ProjectPropertiesResultsHandler handler = new ProjectPropertiesResultsHandler(null);
            try {
                properties = (List)runner.query(ProjectPropertiesResultsHandler.access$2(), (ResultSetHandler)handler, new Object[]{projectId, projectVer, propsName});
                if (properties != null && !properties.isEmpty()) break block3;
                return null;
            }
            catch (SQLException e) {
                throw new ProjectManagerException("Error fetching property " + propsName, (Throwable)e);
            }
        }
        return (Props)((Pair)properties.get(0)).getSecond();
    }

    public Props fetchProjectProperty(Project project, String propsName) throws ProjectManagerException {
        List properties;
        block3: {
            QueryRunner runner = this.createQueryRunner();
            ProjectPropertiesResultsHandler handler = new ProjectPropertiesResultsHandler(null);
            try {
                properties = (List)runner.query(ProjectPropertiesResultsHandler.access$2(), (ResultSetHandler)handler, new Object[]{project.getId(), project.getVersion(), propsName});
                if (properties != null && !properties.isEmpty()) break block3;
                return null;
            }
            catch (SQLException e) {
                throw new ProjectManagerException("Error fetching property " + propsName, (Throwable)e);
            }
        }
        return (Props)((Pair)properties.get(0)).getSecond();
    }

    public void cleanOlderProjectVersion(int projectId, int version) throws ProjectManagerException {
        Connection connection = this.getConnection();
        try {
            this.cleanOlderProjectVersionFlows(connection, projectId, version);
            this.cleanOlderProjectVersionProperties(connection, projectId, version);
            this.cleanOlderProjectFiles(connection, projectId, version);
            this.cleanOlderProjectVersion(connection, projectId, version);
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    private void cleanOlderProjectVersionFlows(Connection connection, int projectId, int version) throws ProjectManagerException {
        String DELETE_FLOW = "DELETE FROM project_flows WHERE project_id=? AND version<?";
        QueryRunner runner = new QueryRunner();
        try {
            runner.update(connection, "DELETE FROM project_flows WHERE project_id=? AND version<?", new Object[]{projectId, version});
            connection.commit();
        }
        catch (SQLException e) {
            throw new ProjectManagerException("Error deleting project version flows " + projectId + ":" + version, (Throwable)e);
        }
    }

    private void cleanOlderProjectVersionProperties(Connection connection, int projectId, int version) throws ProjectManagerException {
        String DELETE_PROPERTIES = "DELETE FROM project_properties WHERE project_id=? AND version<?";
        QueryRunner runner = new QueryRunner();
        try {
            runner.update(connection, "DELETE FROM project_properties WHERE project_id=? AND version<?", new Object[]{projectId, version});
            connection.commit();
        }
        catch (SQLException e) {
            throw new ProjectManagerException("Error deleting project version properties " + projectId + ":" + version, (Throwable)e);
        }
    }

    private void cleanOlderProjectFiles(Connection connection, int projectId, int version) throws ProjectManagerException {
        String DELETE_PROJECT_FILES = "DELETE FROM project_files WHERE project_id=? AND version<?";
        QueryRunner runner = new QueryRunner();
        try {
            runner.update(connection, "DELETE FROM project_files WHERE project_id=? AND version<?", new Object[]{projectId, version});
            connection.commit();
        }
        catch (SQLException e) {
            throw new ProjectManagerException("Error deleting project version files " + projectId + ":" + version, (Throwable)e);
        }
    }

    private void cleanOlderProjectVersion(Connection connection, int projectId, int version) throws ProjectManagerException {
        String UPDATE_PROJECT_VERSIONS = "UPDATE project_versions SET num_chunks=0 WHERE project_id=? AND version<?";
        QueryRunner runner = new QueryRunner();
        try {
            runner.update(connection, "UPDATE project_versions SET num_chunks=0 WHERE project_id=? AND version<?", new Object[]{projectId, version});
            connection.commit();
        }
        catch (SQLException e) {
            throw new ProjectManagerException("Error updating project version chunksize " + projectId + ":" + version, (Throwable)e);
        }
    }

    public Map<String, Props> fetchProjectProperties(int projectId, int version) throws ProjectManagerException {
        List properties;
        block4: {
            QueryRunner runner = this.createQueryRunner();
            ProjectPropertiesResultsHandler handler = new ProjectPropertiesResultsHandler(null);
            properties = (List)runner.query(ProjectPropertiesResultsHandler.access$3(), (ResultSetHandler)handler, new Object[]{projectId, version});
            if (properties != null && !properties.isEmpty()) break block4;
            return null;
        }
        try {
            HashMap<String, Props> props = new HashMap<String, Props>();
            for (Pair pair : properties) {
                props.put((String)pair.getFirst(), (Props)pair.getSecond());
            }
            return props;
        }
        catch (SQLException e) {
            throw new ProjectManagerException("Error fetching properties", (Throwable)e);
        }
    }

    private Connection getConnection() throws ProjectManagerException {
        Connection connection = null;
        try {
            connection = super.getDBConnection(false);
        }
        catch (Exception e) {
            DbUtils.closeQuietly((Connection)connection);
            throw new ProjectManagerException("Error getting DB connection.", (Throwable)e);
        }
        return connection;
    }
}

