/*
 * Decompiled with CFR 0.152.
 */
package azkaban.database;

import azkaban.database.AzkabanDataSource;
import azkaban.database.DataSourceUtils;
import azkaban.utils.Props;
import java.io.IOException;
import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;

public abstract class AbstractJdbcLoader {
    private AzkabanDataSource dataSource;

    public AbstractJdbcLoader(Props props) {
        this.dataSource = DataSourceUtils.getDataSource((Props)props);
    }

    protected Connection getDBConnection(boolean autoCommit) throws IOException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(autoCommit);
        }
        catch (Exception e) {
            DbUtils.closeQuietly((Connection)connection);
            throw new IOException("Error getting DB connection.", e);
        }
        return connection;
    }

    protected QueryRunner createQueryRunner() {
        return new QueryRunner((DataSource)this.dataSource);
    }

    protected boolean allowsOnDuplicateKey() {
        return this.dataSource.allowsOnDuplicateKey();
    }
}

