/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger;

import azkaban.trigger.ConditionChecker;
import azkaban.trigger.TriggerException;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckerTypeLoader {
    private static Logger logger = Logger.getLogger(CheckerTypeLoader.class);
    public static final String DEFAULT_CONDITION_CHECKER_PLUGIN_DIR = "plugins/conditioncheckers";
    protected static Map<String, Class<? extends ConditionChecker>> checkerToClass = new HashMap();

    public void init(Props props) throws TriggerException {
    }

    public synchronized void registerCheckerType(String type, Class<? extends ConditionChecker> checkerClass) {
        logger.info((Object)("Registering checker " + type));
        if (!checkerToClass.containsKey(type)) {
            checkerToClass.put(type, checkerClass);
        }
    }

    public static void registerBuiltinCheckers(Map<String, Class<? extends ConditionChecker>> builtinCheckers) {
        checkerToClass.putAll(checkerToClass);
        for (String type : builtinCheckers.keySet()) {
            logger.info((Object)("Loaded " + type + " checker."));
        }
    }

    public ConditionChecker createCheckerFromJson(String type, Object obj) throws Exception {
        ConditionChecker checker = null;
        Class checkerClass = (Class)checkerToClass.get(type);
        if (checkerClass == null) {
            throw new Exception("Checker type " + type + " not supported!");
        }
        checker = (ConditionChecker)Utils.invokeStaticMethod((ClassLoader)checkerClass.getClassLoader(), (String)checkerClass.getName(), (String)"createFromJson", (Object[])new Object[]{obj});
        return checker;
    }

    public ConditionChecker createChecker(String type, Object ... args) {
        ConditionChecker checker = null;
        Class checkerClass = (Class)checkerToClass.get(type);
        checker = (ConditionChecker)Utils.callConstructor((Class)checkerClass, (Object[])args);
        return checker;
    }

    public Map<String, Class<? extends ConditionChecker>> getSupportedCheckers() {
        return checkerToClass;
    }
}

