/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.executor;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.Status;
import azkaban.flow.Flow;
import azkaban.project.Project;
import azkaban.utils.DirectoryFlowLoader;
import azkaban.utils.JSONUtils;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExecutableFlowTest {
    private Project project;

    @Before
    public void setUp() throws Exception {
        Logger logger = Logger.getLogger(this.getClass());
        DirectoryFlowLoader loader = new DirectoryFlowLoader(logger);
        loader.loadProjectFlow(new File("unit/executions/embedded"));
        Assert.assertEquals((long)0L, (long)loader.getErrors().size());
        this.project = new Project(11, "myTestProject");
        this.project.setFlows(loader.getFlowMap());
        this.project.setVersion(123);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testExecutorFlowCreation() throws Exception {
        Flow flow = this.project.getFlow("jobe");
        Assert.assertNotNull((Object)flow);
        ExecutableFlow exFlow = new ExecutableFlow(this.project, flow);
        Assert.assertNotNull((Object)exFlow.getExecutableNode("joba"));
        Assert.assertNotNull((Object)exFlow.getExecutableNode("jobb"));
        Assert.assertNotNull((Object)exFlow.getExecutableNode("jobc"));
        Assert.assertNotNull((Object)exFlow.getExecutableNode("jobd"));
        Assert.assertNotNull((Object)exFlow.getExecutableNode("jobe"));
        Assert.assertFalse((boolean)(exFlow.getExecutableNode("joba") instanceof ExecutableFlowBase));
        Assert.assertTrue((boolean)(exFlow.getExecutableNode("jobb") instanceof ExecutableFlowBase));
        Assert.assertTrue((boolean)(exFlow.getExecutableNode("jobc") instanceof ExecutableFlowBase));
        Assert.assertTrue((boolean)(exFlow.getExecutableNode("jobd") instanceof ExecutableFlowBase));
        Assert.assertFalse((boolean)(exFlow.getExecutableNode("jobe") instanceof ExecutableFlowBase));
        ExecutableFlowBase jobbFlow = (ExecutableFlowBase)exFlow.getExecutableNode("jobb");
        ExecutableFlowBase jobcFlow = (ExecutableFlowBase)exFlow.getExecutableNode("jobc");
        ExecutableFlowBase jobdFlow = (ExecutableFlowBase)exFlow.getExecutableNode("jobd");
        Assert.assertEquals((Object)"innerFlow", (Object)jobbFlow.getFlowId());
        Assert.assertEquals((Object)"jobb", (Object)jobbFlow.getId());
        Assert.assertEquals((long)4L, (long)jobbFlow.getExecutableNodes().size());
        Assert.assertEquals((Object)"innerFlow", (Object)jobcFlow.getFlowId());
        Assert.assertEquals((Object)"jobc", (Object)jobcFlow.getId());
        Assert.assertEquals((long)4L, (long)jobcFlow.getExecutableNodes().size());
        Assert.assertEquals((Object)"innerFlow", (Object)jobdFlow.getFlowId());
        Assert.assertEquals((Object)"jobd", (Object)jobdFlow.getId());
        Assert.assertEquals((long)4L, (long)jobdFlow.getExecutableNodes().size());
    }

    @Test
    public void testExecutorFlowJson() throws Exception {
        Flow flow = this.project.getFlow("jobe");
        Assert.assertNotNull((Object)flow);
        ExecutableFlow exFlow = new ExecutableFlow(this.project, flow);
        Map obj = exFlow.toObject();
        String exFlowJSON = JSONUtils.toJSON((Object)obj);
        Map flowObjMap = (Map)JSONUtils.parseJSONFromString((String)exFlowJSON);
        ExecutableFlow parsedExFlow = ExecutableFlow.createExecutableFlowFromObject((Object)flowObjMap);
        ExecutableFlowTest.testEquals((ExecutableNode)exFlow, (ExecutableNode)parsedExFlow);
    }

    @Test
    public void testExecutorFlowJson2() throws Exception {
        Flow flow = this.project.getFlow("jobe");
        Assert.assertNotNull((Object)flow);
        ExecutableFlow exFlow = new ExecutableFlow(this.project, flow);
        exFlow.setExecutionId(101);
        exFlow.setAttempt(2);
        exFlow.setDelayedExecution(1000L);
        ExecutionOptions options = new ExecutionOptions();
        options.setConcurrentOption("blah");
        Object[] objectArray = new Object[3];
        objectArray[0] = "bee";
        objectArray[2] = "boo";
        options.setDisabledJobs(Arrays.asList(objectArray));
        options.setFailureAction(ExecutionOptions.FailureAction.CANCEL_ALL);
        String[] stringArray = new String[3];
        stringArray[0] = "doo";
        stringArray[2] = "daa";
        options.setFailureEmails(Arrays.asList(stringArray));
        String[] stringArray2 = new String[3];
        stringArray2[0] = "dee";
        stringArray2[2] = "dae";
        options.setSuccessEmails(Arrays.asList(stringArray2));
        options.setPipelineLevel(Integer.valueOf(2));
        options.setPipelineExecutionId(Integer.valueOf(3));
        options.setNotifyOnFirstFailure(true);
        options.setNotifyOnLastFailure(true);
        HashMap<String, String> flowProps = new HashMap<String, String>();
        flowProps.put("la", "fa");
        options.addAllFlowParameters(flowProps);
        exFlow.setExecutionOptions(options);
        Map obj = exFlow.toObject();
        String exFlowJSON = JSONUtils.toJSON((Object)obj);
        Map flowObjMap = (Map)JSONUtils.parseJSONFromString((String)exFlowJSON);
        ExecutableFlow parsedExFlow = ExecutableFlow.createExecutableFlowFromObject((Object)flowObjMap);
        ExecutableFlowTest.testEquals((ExecutableNode)exFlow, (ExecutableNode)parsedExFlow);
    }

    @Test
    public void testExecutorFlowUpdates() throws Exception {
        Flow flow = this.project.getFlow("jobe");
        ExecutableFlow exFlow = new ExecutableFlow(this.project, flow);
        exFlow.setExecutionId(101);
        Map obj = exFlow.toObject();
        String exFlowJSON = JSONUtils.toJSON((Object)obj);
        Map flowObjMap = (Map)JSONUtils.parseJSONFromString((String)exFlowJSON);
        ExecutableFlow copyFlow = ExecutableFlow.createExecutableFlowFromObject((Object)flowObjMap);
        ExecutableFlowTest.testEquals((ExecutableNode)exFlow, (ExecutableNode)copyFlow);
        ExecutableNode joba = exFlow.getExecutableNode("joba");
        ExecutableFlowBase jobb = (ExecutableFlowBase)exFlow.getExecutableNode("jobb");
        ExecutableFlowBase jobc = (ExecutableFlowBase)exFlow.getExecutableNode("jobc");
        ExecutableFlowBase jobd = (ExecutableFlowBase)exFlow.getExecutableNode("jobd");
        ExecutableNode jobe = exFlow.getExecutableNode("jobe");
        this.assertNotNull(new ExecutableNode[]{joba, jobb, jobc, jobd, jobe});
        ExecutableNode jobbInnerFlowA = jobb.getExecutableNode("innerJobA");
        ExecutableNode jobbInnerFlowB = jobb.getExecutableNode("innerJobB");
        ExecutableNode jobbInnerFlowC = jobb.getExecutableNode("innerJobC");
        ExecutableNode jobbInnerFlow = jobb.getExecutableNode("innerFlow");
        this.assertNotNull(new ExecutableNode[]{jobbInnerFlowA, jobbInnerFlowB, jobbInnerFlowC, jobbInnerFlow});
        ExecutableNode jobcInnerFlowA = jobc.getExecutableNode("innerJobA");
        ExecutableNode jobcInnerFlowB = jobc.getExecutableNode("innerJobB");
        ExecutableNode jobcInnerFlowC = jobc.getExecutableNode("innerJobC");
        ExecutableNode jobcInnerFlow = jobc.getExecutableNode("innerFlow");
        this.assertNotNull(new ExecutableNode[]{jobcInnerFlowA, jobcInnerFlowB, jobcInnerFlowC, jobcInnerFlow});
        ExecutableNode jobdInnerFlowA = jobd.getExecutableNode("innerJobA");
        ExecutableNode jobdInnerFlowB = jobd.getExecutableNode("innerJobB");
        ExecutableNode jobdInnerFlowC = jobd.getExecutableNode("innerJobC");
        ExecutableNode jobdInnerFlow = jobd.getExecutableNode("innerFlow");
        this.assertNotNull(new ExecutableNode[]{jobdInnerFlowA, jobdInnerFlowB, jobdInnerFlowC, jobdInnerFlow});
        exFlow.setEndTime(1000L);
        exFlow.setStartTime(500L);
        exFlow.setStatus(Status.RUNNING);
        exFlow.setUpdateTime(133L);
        long time = System.currentTimeMillis();
        jobe.setEndTime(time);
        jobe.setUpdateTime(time);
        jobe.setStatus(Status.DISABLED);
        jobe.setStartTime(time - 1L);
        Map updateObject = exFlow.toUpdateObject(0L);
        Assert.assertEquals((long)1L, (long)((List)updateObject.get("nodes")).size());
        copyFlow.applyUpdateObject(updateObject);
        ExecutableFlowTest.testEquals((ExecutableNode)exFlow, (ExecutableNode)copyFlow);
        updateObject = exFlow.toUpdateObject(System.currentTimeMillis());
        Assert.assertNull(updateObject.get("nodes"));
        long currentTime = time + 1L;
        jobbInnerFlowA.setEndTime(currentTime);
        jobbInnerFlowA.setUpdateTime(currentTime);
        jobbInnerFlowA.setStatus(Status.DISABLED);
        jobbInnerFlowA.setStartTime(currentTime - 100L);
        updateObject = exFlow.toUpdateObject(0L);
        Assert.assertEquals((long)2L, (long)((List)updateObject.get("nodes")).size());
        updateObject = exFlow.toUpdateObject(jobe.getUpdateTime());
        Assert.assertNotNull(updateObject.get("nodes"));
        Assert.assertEquals((long)1L, (long)((List)updateObject.get("nodes")).size());
        copyFlow.applyUpdateObject(updateObject);
        ExecutableFlowTest.testEquals((ExecutableNode)exFlow, (ExecutableNode)copyFlow);
        updateObject = exFlow.toUpdateObject(jobbInnerFlowA.getUpdateTime());
        Assert.assertNull(updateObject.get("nodes"));
    }

    private void assertNotNull(ExecutableNode ... nodes) {
        ExecutableNode[] executableNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutableNode node = executableNodeArray[n2];
            Assert.assertNotNull((Object)node);
            ++n2;
        }
    }

    public static void testEquals(ExecutableNode a, ExecutableNode b) {
        ExecutableFlow exB;
        ExecutableFlow exA;
        if (a instanceof ExecutableFlow) {
            if (b instanceof ExecutableFlow) {
                exA = (ExecutableFlow)a;
                exB = (ExecutableFlow)b;
                Assert.assertEquals((long)exA.getScheduleId(), (long)exB.getScheduleId());
                Assert.assertEquals((long)exA.getProjectId(), (long)exB.getProjectId());
                Assert.assertEquals((long)exA.getVersion(), (long)exB.getVersion());
                Assert.assertEquals((long)exA.getSubmitTime(), (long)exB.getSubmitTime());
                Assert.assertEquals((Object)exA.getSubmitUser(), (Object)exB.getSubmitUser());
                Assert.assertEquals((Object)exA.getExecutionPath(), (Object)exB.getExecutionPath());
                ExecutableFlowTest.testEquals((ExecutionOptions)exA.getExecutionOptions(), (ExecutionOptions)exB.getExecutionOptions());
            } else {
                Assert.fail((String)"A is ExecutableFlow, but B is not");
            }
        }
        if (a instanceof ExecutableFlowBase) {
            if (b instanceof ExecutableFlowBase) {
                exA = (ExecutableFlowBase)a;
                exB = (ExecutableFlowBase)b;
                Assert.assertEquals((Object)exA.getFlowId(), (Object)exB.getFlowId());
                Assert.assertEquals((long)exA.getExecutableNodes().size(), (long)exB.getExecutableNodes().size());
                for (ExecutableNode nodeA : exA.getExecutableNodes()) {
                    ExecutableNode nodeB = exB.getExecutableNode(nodeA.getId());
                    Assert.assertNotNull((Object)nodeB);
                    Assert.assertEquals((Object)a, (Object)nodeA.getParentFlow());
                    Assert.assertEquals((Object)b, (Object)nodeB.getParentFlow());
                    ExecutableFlowTest.testEquals((ExecutableNode)nodeA, (ExecutableNode)nodeB);
                }
            } else {
                Assert.fail((String)"A is ExecutableFlowBase, but B is not");
            }
        }
        Assert.assertEquals((Object)a.getId(), (Object)b.getId());
        Assert.assertEquals((Object)a.getStatus(), (Object)b.getStatus());
        Assert.assertEquals((long)a.getStartTime(), (long)b.getStartTime());
        Assert.assertEquals((long)a.getEndTime(), (long)b.getEndTime());
        Assert.assertEquals((long)a.getUpdateTime(), (long)b.getUpdateTime());
        Assert.assertEquals((long)a.getAttempt(), (long)b.getAttempt());
        Assert.assertEquals((Object)a.getJobSource(), (Object)b.getJobSource());
        Assert.assertEquals((Object)a.getPropsSource(), (Object)b.getPropsSource());
        Assert.assertEquals((Object)a.getInNodes(), (Object)a.getInNodes());
        Assert.assertEquals((Object)a.getOutNodes(), (Object)a.getOutNodes());
    }

    public static void testEquals(ExecutionOptions optionsA, ExecutionOptions optionsB) {
        Assert.assertEquals((Object)optionsA.getConcurrentOption(), (Object)optionsB.getConcurrentOption());
        Assert.assertEquals((Object)optionsA.getNotifyOnFirstFailure(), (Object)optionsB.getNotifyOnFirstFailure());
        Assert.assertEquals((Object)optionsA.getNotifyOnLastFailure(), (Object)optionsB.getNotifyOnLastFailure());
        Assert.assertEquals((Object)optionsA.getFailureAction(), (Object)optionsB.getFailureAction());
        Assert.assertEquals((Object)optionsA.getPipelineExecutionId(), (Object)optionsB.getPipelineExecutionId());
        Assert.assertEquals((Object)optionsA.getPipelineLevel(), (Object)optionsB.getPipelineLevel());
        Assert.assertEquals((Object)optionsA.isFailureEmailsOverridden(), (Object)optionsB.isFailureEmailsOverridden());
        Assert.assertEquals((Object)optionsA.isSuccessEmailsOverridden(), (Object)optionsB.isSuccessEmailsOverridden());
        ExecutableFlowTest.testDisabledEquals((List)optionsA.getDisabledJobs(), (List)optionsB.getDisabledJobs());
        ExecutableFlowTest.testEquals((List)optionsA.getSuccessEmails(), (List)optionsB.getSuccessEmails());
        ExecutableFlowTest.testEquals((List)optionsA.getFailureEmails(), (List)optionsB.getFailureEmails());
        ExecutableFlowTest.testEquals((Map)optionsA.getFlowParameters(), (Map)optionsB.getFlowParameters());
    }

    public static void testEquals(Set<String> a, Set<String> b) {
        if (a == b) {
            return;
        }
        if (a == null || b == null) {
            Assert.fail();
        }
        Assert.assertEquals((long)a.size(), (long)b.size());
        for (String aStr : a) {
            Assert.assertTrue((boolean)b.contains(aStr));
        }
    }

    public static void testEquals(List<String> a, List<String> b) {
        if (a == b) {
            return;
        }
        if (a == null || b == null) {
            Assert.fail();
        }
        Assert.assertEquals((long)a.size(), (long)b.size());
        Iterator<String> iterA = a.iterator();
        Iterator<String> iterB = b.iterator();
        while (iterA.hasNext()) {
            String aStr = iterA.next();
            String bStr = iterB.next();
            Assert.assertEquals((Object)aStr, (Object)bStr);
        }
    }

    public static void testDisabledEquals(List<Object> a, List<Object> b) {
        if (a == b) {
            return;
        }
        if (a == null || b == null) {
            Assert.fail();
        }
        Assert.assertEquals((long)a.size(), (long)b.size());
        Iterator<Object> iterA = a.iterator();
        Iterator<Object> iterB = b.iterator();
        while (iterA.hasNext()) {
            Object aStr = iterA.next();
            Object bStr = iterB.next();
            if (aStr instanceof Map && bStr instanceof Map) {
                Map aMap = (Map)aStr;
                Map bMap = (Map)bStr;
                Assert.assertEquals((Object)((String)aMap.get("id")), (Object)((String)bMap.get("id")));
                ExecutableFlowTest.testDisabledEquals((List)((List)aMap.get("children")), (List)((List)bMap.get("children")));
                continue;
            }
            Assert.assertEquals((Object)aStr, (Object)bStr);
        }
    }

    public static void testEquals(Map<String, String> a, Map<String, String> b) {
        if (a == b) {
            return;
        }
        if (a == null || b == null) {
            Assert.fail();
        }
        Assert.assertEquals((long)a.size(), (long)b.size());
        for (String key : a.keySet()) {
            Assert.assertEquals((Object)a.get(key), (Object)b.get(key));
        }
    }
}

