/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.utils.FileIOUtils;
import azkaban.utils.JSONUtils;
import azkaban.webapp.servlet.AbstractServiceServlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ExecutorManagerServlet
extends AbstractServiceServlet {
    private final ExecutorManagerAdapter executorManager;
    public static final String URL = "executorManager";
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ExecutorManagerServlet.class);

    public ExecutorManagerServlet(ExecutorManagerAdapter executorManager) {
        this.executorManager = executorManager;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, String> respMap = new HashMap<String, String>();
        try {
            if (!this.hasParam(req, "action")) {
                logger.error((Object)"Parameter action not set");
                respMap.put("error", "Parameter action not set");
            } else {
                String action = this.getParam(req, "action");
                if (action.equals("update")) {
                    this.handleAjaxUpdateRequest(req, respMap);
                } else {
                    int execid = Integer.parseInt(this.getParam(req, "execId"));
                    String user = this.getParam(req, "userId", null);
                    logger.info((Object)("User " + user + " has called action " + action + " on " + execid));
                    if (action.equals("getFlowLog")) {
                        this.handleFetchFlowLogEvent(execid, req, resp, respMap);
                    } else if (action.equals("getJobLog")) {
                        this.handleFetchJobLogEvent(execid, req, resp, respMap);
                    } else if (action.equals("submitFlow")) {
                        this.handleAjaxSubmitFlow(req, respMap, execid);
                    } else if (action.equals("cancelFlow")) {
                        logger.info((Object)"Cancel called.");
                        this.handleAjaxCancelFlow(respMap, execid, user);
                    } else if (action.equals("pauseFlow")) {
                        logger.info((Object)"Paused called.");
                        this.handleAjaxPauseFlow(respMap, execid, user);
                    } else if (action.equals("resumeFlow")) {
                        logger.info((Object)"Resume called.");
                        this.handleAjaxResumeFlow(respMap, execid, user);
                    } else if (action.equals("modifyExecution")) {
                        logger.info((Object)"Modify Execution Action");
                        this.handleModifyExecution(respMap, execid, user, req);
                    } else {
                        logger.error((Object)("action: '" + action + "' not supported."));
                        respMap.put("error", "action: '" + action + "' not supported.");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            respMap.put("error", e.getMessage());
        }
        this.writeJSON(resp, respMap);
        resp.flushBuffer();
    }

    private void handleModifyExecution(HashMap<String, Object> respMap, int execid, String user, HttpServletRequest req) {
        if (!this.hasParam(req, "modifyCommand")) {
            respMap.put("error", "Modification command not set.");
            return;
        }
        try {
            String modificationType = this.getParam(req, "modifyCommand");
            ExecutableFlow exflow = this.executorManager.getExecutableFlow(execid);
            if ("modifyRetryFailures".equals(modificationType)) {
                this.executorManager.retryFailures(exflow, user);
            }
        }
        catch (Exception e) {
            respMap.put("error", e);
        }
    }

    private void handleAjaxResumeFlow(HashMap<String, Object> respMap, int execid, String user) {
        try {
            ExecutableFlow exFlow = this.executorManager.getExecutableFlow(execid);
            this.executorManager.resumeFlow(exFlow, user);
        }
        catch (Exception e) {
            respMap.put("error", e);
        }
    }

    private void handleAjaxPauseFlow(HashMap<String, Object> respMap, int execid, String user) {
        try {
            ExecutableFlow exFlow = this.executorManager.getExecutableFlow(execid);
            this.executorManager.pauseFlow(exFlow, user);
        }
        catch (Exception e) {
            respMap.put("error", e);
        }
    }

    private void handleAjaxCancelFlow(HashMap<String, Object> respMap, int execid, String user) {
        try {
            ExecutableFlow exFlow = this.executorManager.getExecutableFlow(execid);
            this.executorManager.cancelFlow(exFlow, user);
        }
        catch (Exception e) {
            respMap.put("error", e);
        }
    }

    private void handleAjaxSubmitFlow(HttpServletRequest req, HashMap<String, Object> respMap, int execid) {
        try {
            String execFlowJson = this.getParam(req, "execFlowJson");
            ExecutableFlow exflow = ExecutableFlow.createExecutableFlowFromObject((Object)JSONUtils.parseJSONFromString((String)execFlowJson));
            String user = this.getParam(req, "userId");
            this.executorManager.submitExecutableFlow(exflow, user);
            respMap.put("execId", exflow.getExecutionId());
        }
        catch (Exception e) {
            e.printStackTrace();
            respMap.put("error", e);
        }
    }

    private void handleFetchJobLogEvent(int execid, HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> respMap) {
        try {
            ExecutableFlow exFlow = this.executorManager.getExecutableFlow(execid);
            String jobId = this.getParam(req, "jobName");
            int offset = this.getIntParam(req, "offset");
            int length = this.getIntParam(req, "length");
            int attempt = this.getIntParam(req, "attempt");
            FileIOUtils.LogData log = this.executorManager.getExecutionJobLog(exFlow, jobId, offset, length, attempt);
            respMap.put("logData", JSONUtils.toJSON((Object)log.toObject()));
        }
        catch (Exception e) {
            e.printStackTrace();
            respMap.put("error", e);
        }
    }

    private void handleFetchFlowLogEvent(int execid, HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> respMap) {
        try {
            ExecutableFlow exFlow = this.executorManager.getExecutableFlow(execid);
            int offset = this.getIntParam(req, "offset");
            int length = this.getIntParam(req, "length");
            FileIOUtils.LogData log = this.executorManager.getExecutableFlowLog(exFlow, offset, length);
            respMap.put("logData", JSONUtils.toJSON((Object)log.toObject()));
        }
        catch (Exception e) {
            e.printStackTrace();
            respMap.put("error", e);
        }
    }

    private void handleAjaxUpdateRequest(HttpServletRequest req, HashMap<String, Object> respMap) {
        try {
            ArrayList updateTimesList = (ArrayList)JSONUtils.parseJSONFromString((String)this.getParam(req, "updateTimeList"));
            ArrayList execIDList = (ArrayList)JSONUtils.parseJSONFromString((String)this.getParam(req, "execIdList"));
            ArrayList<Map> updateList = new ArrayList<Map>();
            int i = 0;
            while (i < execIDList.size()) {
                long updateTime = JSONUtils.getLongFromObject(updateTimesList.get(i));
                int execId = (Integer)execIDList.get(i);
                ExecutableFlow flow = this.executorManager.getExecutableFlow(execId);
                if (flow == null) {
                    HashMap<String, Object> errorResponse = new HashMap<String, Object>();
                    errorResponse.put("error", "Flow does not exist");
                    errorResponse.put("execId", execId);
                    updateList.add(errorResponse);
                } else if (flow.getUpdateTime() > updateTime) {
                    updateList.add(flow.toUpdateObject(updateTime));
                }
                ++i;
            }
            respMap.put("updates", updateList);
        }
        catch (Exception e) {
            e.printStackTrace();
            respMap.put("error", e);
        }
    }
}

