/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.cache;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author romulo
 */
public class SingleCache implements Cache {

    private final CachingPerformance cachingPerformance;
    private Object lastInput;
    private Object result;

    public SingleCache() {
        this.cachingPerformance = new CachingPerformance();
    }
    
    public SingleCache(String name) {
        this.cachingPerformance = new CachingPerformance(name);
    }

    public SingleCache(CachingPerformance cachingPerformance) {
        this.cachingPerformance = cachingPerformance;
    }

    public CachingPerformance getCachingPerformance() {
        return this.cachingPerformance;
    }

    @Override
    public Object put(Object key, Object value, long timeToLive) {
        Object put = put(key, value);
        Thread thread = new Thread(() -> {
            try {
                Thread.sleep(timeToLive);
            } catch (InterruptedException ex) {
                Logger.getLogger(SingleCache.class.getName()).log(Level.SEVERE, "interrupted time to live");
            }
            this.lastInput = null;
            this.result = null;
        });
        thread.start();
        return put;
    }

    @Override
    public Object put(Object key, Object value) {
        this.lastInput = key;
        this.result = value;
        this.cachingPerformance.registerSize(1);
        return this.result;
    }

    @Override
    public Object get(Object key) {
        if (key.equals(this.lastInput)) {
            this.cachingPerformance.registerHit();
            return this.result;
        }
        this.cachingPerformance.registerMiss();
        return null;
    }

    @Override
    public void invalidate(Object key) {
        this.lastInput = null;
        this.result = null;
        this.cachingPerformance.registerInvalidation();
    }

}
