/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.cache.tools;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Main {

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [Cache] %5$s %n");

        if (args.length < 2) {
            System.err.println("--events=<EventsPath> --reduce=<ReducePath> [--prefix=<prefix>]");
            System.err.println("--uncached=<UncachedPath> --reduce=<ReducePath> [--prefix=<prefix> --hash]");
            System.err.println("--events=<EventsPath> --reduce=<ReducePath> --size=true [--prefix=<prefix>]");
            System.exit(1);
        }

        Map<String, String> arguments = Stream.of(args).map(arg -> {
            arg = arg.replaceFirst("--", "");
            int indexOf = arg.indexOf("=");
            if (indexOf == -1) {
                return new String[]{arg, ""};
            }
            return new String[]{arg.substring(0, indexOf), arg.substring(indexOf + 1)};
        }).collect(Collectors.toMap(array -> {
            return array[0];
        }, array -> {
            return array[1];
        }));

        String eventsPath = arguments.get("events");
        String reducePath = arguments.get("reduce");
        String prefix = arguments.get("prefix");
        String uncachedPath = arguments.get("uncached");
        String size = arguments.get("size");
        if (reducePath == null && (eventsPath == null || uncachedPath == null)) {
            System.err.println("<ReducePath> and either <EventsPath> or <UncachedPath> are required");
            System.exit(1);
        }
        if (prefix == null) {
            prefix = "";
        }
        if (eventsPath != null && size != null) {
            Reducer.size(eventsPath, reducePath, prefix);
        } else if (eventsPath != null) {
            Reducer.reduce(eventsPath, reducePath, prefix);
        } else if (uncachedPath != null) {
            boolean hash = arguments.get("hash") != null;
            Distinct.reduce(uncachedPath, reducePath, prefix, hash);
        }
    }
}
