/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.cache;

/**
 *
 * @author romulo
 */
public class CacheEvent {

    private final long time;
    private final EventType type;
    private final int size;
    private final String name;
    private final String identifier;

    protected CacheEvent(EventType type, String name) {
        this(type, name, 0);
    }

    protected CacheEvent(EventType type, String name, String identifier) {
        this(type, name, identifier, 0);
    }

    protected CacheEvent(EventType type, String name, int size) {
        this(type, null, null, size);
    }

    protected CacheEvent(EventType type, String name, String identifier, int size) {
        this(System.currentTimeMillis(), type, name, identifier, size);
    }

    private CacheEvent(long time, EventType type, String name, String identifier, int size) {
        this.time = time;
        this.type = type;
        this.identifier = identifier;
        this.name = name;
        this.size = size;
    }

    public long getTime() {
        return this.time;
    }

    public EventType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append("\"time\":").append(this.time);
        stringBuilder.append(",");
        stringBuilder.append("\"type\":").append("\"").append(this.type.name()).append("\"");
        if (this.size > 0) {
            stringBuilder.append(",");
            stringBuilder.append("\"size\":").append(this.size);
        }
        if (this.name != null) {
            stringBuilder.append(",");
            stringBuilder.append("\"name\":").append("\"").append(this.name).append("\"");
        }
        if (this.identifier != null) {
            stringBuilder.append(",");
            stringBuilder.append("\"identifier\":").append("\"").append(this.identifier).append("\"");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}
