/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.cache.tools;

import br.ufrgs.inf.prosoft.cache.CacheEvent;
import br.ufrgs.inf.prosoft.cache.EventType;
import com.google.gson.Gson;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Reducer {

    private static final Logger LOGGER = Logger.getLogger(Reducer.class.getName());

    public static void reduce(String eventsPath, String reducePath, String prefix) {
        try (Stream<String> lines = Files.lines(Paths.get(eventsPath))) {
            Gson gson = new Gson();
            Map<String, Integer> objectHasHits = new HashMap<>();
            lines.forEach(line -> {
                CacheEvent event = gson.fromJson(line, CacheEvent.class);
                if (event.getType().equals(EventType.HIT) || event.getType().equals(EventType.ADDITION) || event.getType().equals(EventType.MISS)) {
                    String identifier = event.getName() + "," + event.getIdentifier() + "," + event.getType().name().toLowerCase();
                    try {
                        objectHasHits.put(identifier, objectHasHits.get(identifier) + 1);
                    } catch (Exception ex) {
                        objectHasHits.put(identifier, 1);
                    }
                }
            });

            try (FileWriter fileWriter = new FileWriter(reducePath, true)) {
                objectHasHits.entrySet().stream().forEach(entry -> {
                    try {
                        fileWriter.write(prefix + entry.getKey() + "," + entry.getValue() + "\n");
                    } catch (IOException ex) {
                        LOGGER.log(Level.SEVERE, "IOException {0}", ex);
                    }
                });
            }
        } catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "file not found {0}", eventsPath);
        }
    }
}
