/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author romulo
 */
public class CachingPerformance {

    private int misses;
    private int hits;
    private int bytesHits;
    private int invalidations;
    private int maximumSize;
    private String name;

    public CachingPerformance() {
        this.name = "AnonymousCache";
        Runtime.getRuntime().addShutdownHook(new Thread() {
            @Override
            public void run() {
                Logger.getLogger(CachingPerformance.class.getName()).log(Level.INFO, "printing caching metrics");
                System.out.print(CachingPerformance.this.name);
                System.out.print(": ");
                System.out.println(CachingPerformance.this.toLongString());
            }
        });
    }

    public CachingPerformance(String name) {
        super();
        this.name = name;
    }

    public void reduce(CachingPerformance cachingPerformance) {
        this.misses += cachingPerformance.misses;
        this.hits += cachingPerformance.hits;
        this.invalidations += cachingPerformance.invalidations;
        this.maximumSize = Math.max(this.maximumSize, cachingPerformance.maximumSize);
    }

    public void registerHit() {
        this.hits++;
    }

    public void registerBytesHit(int size) {
        this.bytesHits += size;
    }

    public void registerMiss() {
        this.misses++;
    }

    public void registerInvalidation() {
        this.invalidations++;
    }

    public void registerEntry() {
        this.maximumSize++;
    }

    public void registerSize(int size) {
        this.maximumSize = Math.max(this.maximumSize, size);
    }

    public long getRoundedHitRatio() {
        return Math.round(getHitRatio());
    }

    public double getHitRatio() {
        return this.hits * 100.0 / (this.hits + this.misses);
    }

    public double getByteHitRatio() {
        return 100.0 * (this.bytesHits / (this.bytesHits + (this.bytesHits / this.hits) * this.misses));
    }

    public String needInvalidation() {
        return this.invalidations > 0 ? "yes" : "no";
    }

    public static int calculateObjectSize(Object object) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream)) {
            objectOutputStream.writeObject(object);
            byte[] toByteArray = outputStream.toByteArray();
            return toByteArray.length;
        } catch (IOException ex) {
            System.err.println("[Cache] size exception: " + ex);
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("H").append(this.hits);
        stringBuilder.append(" M").append(this.misses);
        stringBuilder.append(" I").append(this.invalidations);
        stringBuilder.append(" S").append(this.maximumSize);
        return stringBuilder.toString();
    }

    public String toLongString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Hits: ").append(this.hits);
        stringBuilder.append("; Misses: ").append(this.misses);
        stringBuilder.append("; Hit Ratio: ").append(getHitRatio());
        stringBuilder.append("%; Invalidations: ").append(this.invalidations);
        stringBuilder.append("; Maximum Size: ").append(this.maximumSize);
        return stringBuilder.toString();
    }

}
