/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.cache;

/**
 *
 * @author romulo
 */
public class CacheEvent {

    private final long time;
    private final String type;
    private final int size;
    private final String identifier;

    private CacheEvent(String type) {
        this(type, 0);
    }

    private CacheEvent(String type, String identifier) {
        this(type, identifier, 0);
    }

    private CacheEvent(String type, int size) {
        this(type, null, size);
    }

    private CacheEvent(String type, String identifier, int size) {
        this(System.currentTimeMillis(), type, identifier, size);
    }

    private CacheEvent(long time, String type, String identifier, int size) {
        this.time = time;
        this.type = type;
        this.identifier = identifier;
        this.size = size;
    }

    public static CacheEvent miss() {
        return new CacheEvent("MISS");
    }

    public static CacheEvent addition() {
        return new CacheEvent("ADDITION");
    }

    public static CacheEvent addition(String identifier) {
        return new CacheEvent("ADDITION", identifier);
    }

    public static CacheEvent addition(int size) {
        return new CacheEvent("ADDITION", size);
    }

    public static CacheEvent addition(String identifier, int size) {
        return new CacheEvent("ADDITION", identifier, size);
    }

    public static CacheEvent hit() {
        return new CacheEvent("HIT");
    }

    public static CacheEvent hit(String identifier) {
        return new CacheEvent("HIT", identifier);
    }

    public static CacheEvent hit(int size) {
        return new CacheEvent("HIT", size);
    }

    public static CacheEvent hit(String identifier, int size) {
        return new CacheEvent("HIT", identifier, size);
    }

    public static CacheEvent invalidation() {
        return new CacheEvent("INVALIDATION");
    }

    public static CacheEvent invalidation(String identifier) {
        return new CacheEvent("INVALIDATION", identifier);
    }

    public static CacheEvent invalidation(int size) {
        return new CacheEvent("INVALIDATION", size);
    }

    public static CacheEvent invalidation(String identifier, int size) {
        return new CacheEvent("INVALIDATION", identifier, size);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append("\"time\":").append(this.time);
        stringBuilder.append(",");
        stringBuilder.append("\"type\":").append("\"").append(this.type).append("\"");
        if (this.size > 0) {
            stringBuilder.append(",");
            stringBuilder.append("\"size\":").append(this.size);
        }
        if (this.identifier != null) {
            stringBuilder.append(",");
            stringBuilder.append("\"identifier\":").append("\"").append(this.identifier).append("\"");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}
