package br.ufrgs.inf.prosoft.memoizeittf.adapter;

import java.util.ArrayList;
import java.util.List;

public class Thresholds {

  private static final List<Double> DISTANCES = new ArrayList<>();
  public static long population;
  private static Double averageDistance;
  private static Double stdDevDistance;

  public static void reset() {
    Thresholds.DISTANCES.clear();
    Thresholds.averageDistance = null;
    Thresholds.stdDevDistance = null;
  }

  public static void addDistance(Double distance) {
    DISTANCES.add(distance);
    Thresholds.averageDistance = null;
    Thresholds.stdDevDistance = null;
  }

  public static double getAverageDistance() {
    if (DISTANCES.isEmpty()) return 0D;
    if (averageDistance == null) averageDistance = DISTANCES.stream().reduce(Double::sum).orElse(0D) / DISTANCES.size();
    return averageDistance;
  }

  public static double getStdDevDistance() {
    if (population == 0) return 0;
    if (stdDevDistance != null) return stdDevDistance;

    double mean = getAverageDistance();
    double temp = DISTANCES.stream()
      .map(difference -> (difference - mean) * (difference - mean))
      .reduce(Double::sum)
      .orElse(0D);
    stdDevDistance = Math.sqrt(temp / population);
    return stdDevDistance;
  }

  public static double distanceThreshold(int kStdDev) {
    return getAverageDistance() - (kStdDev * getStdDevDistance());
  }

  public static double distanceThreshold() {
    return 0.5;
  }

}
