package br.ufrgs.inf.prosoft.memoizeittf;

import br.ufrgs.inf.prosoft.memoizeit.MemoizeIt;
import br.ufrgs.inf.prosoft.memoizeit.graph.Graph;
import br.ufrgs.inf.prosoft.memoizeittf.adapter.Thresholds;
import br.ufrgs.inf.prosoft.memoizeittf.facade.Method;
import br.ufrgs.inf.prosoft.memoizeittf.utils.Methods;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MemoizeItTF extends MemoizeIt {

  public static final int K_STANDARD_DEVIATION = 0;
  private static final Logger LOGGER = Logger.getLogger(MemoizeItTF.class.getName());
  private final Methods methods;

  public MemoizeItTF(List<Method> methods) {
    this(methods, new Graph<String>());
  }

  public MemoizeItTF(List<Method> methods, Graph<String> callgraph) {
    this.methods = new Methods(methods);
    setMethods(this.methods.getMemoizeitMethods());
    setCallGraph(callgraph);
    setMinimumHitRatio(0D);
  }

  public void recommend() {
    recommend(false);
  }

  public void recommend(boolean iteratively) {
    removeChangeableMethods(iteratively);

    this.methods.synchronize();
    List<br.ufrgs.inf.prosoft.tfcache.metadata.Method> tfCacheMethods = this.methods.getTfcacheMethods();

    LOGGER.info(MessageFormat.format("Removing not reusable from {0} methods", tfCacheMethods.size()));
    tfCacheMethods.removeIf(it -> it.isNotReusable());
    LOGGER.info(MessageFormat.format("Recommending TTL to {0} methods", tfCacheMethods.size()));
    tfCacheMethods.stream().parallel().forEach(it -> it.recommendTTL());
    LOGGER.info(MessageFormat.format("Removing not recommended from {0}", tfCacheMethods.size()));
    tfCacheMethods.removeIf(method -> method.getBestMetrics().getSavedTime() == 0);

    LOGGER.info(MessageFormat.format("Removing methods according to the Threshold from {0}", tfCacheMethods.size()));
    tfCacheMethods.removeIf(method -> method.getMinEuclideanDistance() > Thresholds.distanceThreshold());

    LOGGER.info(MessageFormat.format("Ranking {0} methods according saved time", tfCacheMethods.size()));
    tfCacheMethods.sort((method1, method2) -> Double.compare(method2.getEstimatedSavedTime(), method1.getEstimatedSavedTime()));

    LOGGER.info(MessageFormat.format("Printing recommendations for {0} methods", tfCacheMethods.size()));
    this.methods.synchronize();
    Map<String, br.ufrgs.inf.prosoft.memoizeit.Method> memoizeItMethods = this.methods.getMemoizeitMethods().stream()
      .collect(Collectors.toMap(key -> key.getName(), value -> value));

    tfCacheMethods.forEach(method -> {
      System.out.println(method.getName()
        + " Occurrences " + method.occurrences().count()
        + " Inputs " + method.groupsOfOccurrences().count()
        + " TTL " + method.getBestMetrics().getTtl()
        + " Saves " + method.getBestMetrics().getSavedTime()
        + " Hits " + method.getBestMetrics().getHits()
        + " Computation " + method.getBestMetrics().getComputationTime()
        + " TimeInCache " + method.getBestMetrics().getTimeInCache()
        + " Stales " + method.getBestMetrics().getStales());
      suggestImplementation(memoizeItMethods.get(method.getName()));
    });
  }

}
