package br.ufrgs.inf.prosoft.memoizeittf;

import br.ufrgs.inf.prosoft.memoizeit.MemoizeIt;
import br.ufrgs.inf.prosoft.memoizeit.graph.Graph;
import br.ufrgs.inf.prosoft.memoizeittf.adapter.Thresholds;
import br.ufrgs.inf.prosoft.memoizeittf.facade.Method;
import br.ufrgs.inf.prosoft.memoizeittf.utils.Methods;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemoizeItTF extends MemoizeIt {

    private static final Logger LOGGER = Logger.getLogger(MemoizeItTF.class.getName());

    private Methods methods;

    public MemoizeItTF(List<Method> methods) {
        this(methods, new Graph<String>());
    }

    public MemoizeItTF(List<Method> methods, Graph<String> callgraph) {
        this.methods = new Methods(methods);
        setMethods(this.methods.getMemoizeitMethods());
        setCallGraph(callgraph);
        setMinimumHitRatio(0D);
    }

    public void recommend() {
        recommend(false);
    }

    public void recommend(boolean iteratively) {
        removeChangefulMethods(iteratively);

        this.methods.synchronize();
        List<br.ufrgs.inf.prosoft.tfcache.metadata.Method> tfcacheMethods = this.methods.getTfcacheMethods();

        LOGGER.log(Level.INFO, "Removing not reusable from {0} methods", tfcacheMethods.size());
        tfcacheMethods.removeIf(br.ufrgs.inf.prosoft.tfcache.metadata.Method::isNotReusable);
        LOGGER.log(Level.INFO, "Recommending TTL to {0} methods", tfcacheMethods.size());
        tfcacheMethods.stream().parallel().forEach(br.ufrgs.inf.prosoft.tfcache.metadata.Method::recommendTTL);
        LOGGER.log(Level.INFO, "Removing not recommended from {0}", tfcacheMethods.size());
        tfcacheMethods.removeIf(method -> method.getBestMetrics().getSavedTime() == 0);

        LOGGER.log(Level.INFO, "Removing methods according to the STpTiC Threshold from {0}", tfcacheMethods.size());
        tfcacheMethods.removeIf(method -> method.getBestMetrics().getSavedTimePerTimeInCache().compareTo(Thresholds.savedTimePerTimeInCacheThreshold()) < 0);

        LOGGER.log(Level.INFO, "Ranking {0} methods according STpTiC", tfcacheMethods.size());
        tfcacheMethods.sort((method1, method2) -> method2.getBestMetrics().getSavedTimePerTimeInCache().compareTo(method1.getBestMetrics().getSavedTimePerTimeInCache()));
        LOGGER.log(Level.INFO, "Printing recommendations for {0} methods", tfcacheMethods.size());
        tfcacheMethods.forEach(method -> {
            System.out.println(method.getName()
                    + " Occurrences " + method.getOccurrencesSize()
                    + " Inputs " + method.groupsOfOccurrences().count()
                    + " TTL " + method.getBestMetrics().getTtl()
                    + " STpTiC " + method.getBestMetrics().getSavedTimePerTimeInCache()
                    + " Saves " + method.getBestMetrics().getSavedTime()
                    + " Hits " + method.getBestMetrics().getHits()
                    + " Stales " + method.getBestMetrics().getStales());
        });
    }

}
