/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.memoizeittf.adapter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author romulo
 */
public class Thresholds {

    private static final List<BigDecimal> SAVED_TIME_PER_TIME_IN_CACHE = new ArrayList<>();
    private static final BigDecimal SAVED_TIME_PER_TIME_IN_CACHE_THRESHOLD = new BigDecimal(0.1);

    private static BigDecimal averageSavedTimePerTimeInCache;
    private static BigDecimal stdDevSavedTimePerTimeInCache;

    public static void reset() {
        Thresholds.SAVED_TIME_PER_TIME_IN_CACHE.clear();
        Thresholds.averageSavedTimePerTimeInCache = null;
        Thresholds.stdDevSavedTimePerTimeInCache = null;
    }

    public static BigDecimal getAverageSavedTimePerTimeInCache() {
        if (averageSavedTimePerTimeInCache != null) {
            return averageSavedTimePerTimeInCache;
        }
        if (SAVED_TIME_PER_TIME_IN_CACHE.isEmpty()) {
            return new BigDecimal(BigInteger.ZERO);
        }
        averageSavedTimePerTimeInCache = SAVED_TIME_PER_TIME_IN_CACHE.stream().reduce(BigDecimal::add).orElse(new BigDecimal(BigInteger.ZERO))
                .divide(new BigDecimal(SAVED_TIME_PER_TIME_IN_CACHE.size()), MathContext.DECIMAL128);
        return averageSavedTimePerTimeInCache;
    }

    public static BigDecimal getStdDevSavedTimePerTimeInCache() {
        if (stdDevSavedTimePerTimeInCache != null) {
            return stdDevSavedTimePerTimeInCache;
        }
        if (SAVED_TIME_PER_TIME_IN_CACHE.isEmpty()) {
            return new BigDecimal(BigInteger.ZERO);
        }
        BigDecimal mean = getAverageSavedTimePerTimeInCache();
        BigDecimal temp = SAVED_TIME_PER_TIME_IN_CACHE.stream()
                .map(frequency -> frequency.subtract(mean).multiply(frequency.subtract(mean)))
                .reduce(BigDecimal::add)
                .orElse(new BigDecimal(BigInteger.ZERO));
        stdDevSavedTimePerTimeInCache = temp.divide(new BigDecimal(SAVED_TIME_PER_TIME_IN_CACHE.size()), MathContext.DECIMAL128).sqrt(MathContext.DECIMAL128);
        return stdDevSavedTimePerTimeInCache;
    }

    public static BigDecimal savedTimePerTimeInCacheThreshold(int kStdDev) {
        return getAverageSavedTimePerTimeInCache().add(getStdDevSavedTimePerTimeInCache().multiply(new BigDecimal(kStdDev)));
    }

    public static BigDecimal savedTimePerTimeInCacheThreshold() {
        return SAVED_TIME_PER_TIME_IN_CACHE_THRESHOLD;
    }

    public static void add(BigDecimal savedTimePerTimeInCache) {
        SAVED_TIME_PER_TIME_IN_CACHE.add(savedTimePerTimeInCache);
        Thresholds.averageSavedTimePerTimeInCache = null;
        Thresholds.stdDevSavedTimePerTimeInCache = null;
    }

}
