/*
 * Copyright 2002-2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.samples.petclinic.repository;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.samples.petclinic.model.Vet;
import org.springframework.samples.petclinic.util.EntityUtils;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;

import static org.junit.Assert.assertEquals;

/**
 * <p> Base class for {@link OwnerRepository} integration tests. </p>
 * <p/>
 * see javadoc inside {@link AbstractVetRepositoryTests} for more details
 *
 * @author Ken Krebs
 * @author Rod Johnson
 * @author Juergen Hoeller
 * @author Sam Brannen
 * @author Michael Isvy
 */
public abstract class AbstractVetRepositoryTests {

    @Autowired
    protected VetRepository vetRepository;


    @Test
    @Transactional
    public void findVets() {
        Collection<Vet> vets = this.vetRepository.findAll();

        Vet v1 = EntityUtils.getById(vets, Vet.class, 2);
        assertEquals("Leary", v1.getLastName());
        assertEquals(1, v1.getNrOfSpecialties());
        assertEquals("radiology", (v1.getSpecialties().get(0)).getName());
        Vet v2 = EntityUtils.getById(vets, Vet.class, 3);
        assertEquals("Douglas", v2.getLastName());
        assertEquals(2, v2.getNrOfSpecialties());
        assertEquals("dentistry", (v2.getSpecialties().get(0)).getName());
        assertEquals("surgery", (v2.getSpecialties().get(1)).getName());
    }

}
