/*
 * Copyright © 2016-2017 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*@ngInject*/
export default function AliasesEntitySelectPanelController(mdPanelRef, $scope, types, aliasController, onEntityAliasesUpdate) {

    var vm = this;
    vm._mdPanelRef = mdPanelRef;
    vm.aliasController = aliasController;
    vm.onEntityAliasesUpdate = onEntityAliasesUpdate;
    vm.entityAliases = {};
    vm.entityAliasesInfo = {};

    vm.currentAliasEntityChanged = currentAliasEntityChanged;

    var allEntityAliases = vm.aliasController.getEntityAliases();
    for (var aliasId in allEntityAliases) {
        var aliasInfo = vm.aliasController.getInstantAliasInfo(aliasId);
        if (aliasInfo && !aliasInfo.resolveMultiple && aliasInfo.currentEntity) {
            vm.entityAliasesInfo[aliasId] = angular.copy(aliasInfo);
        }
    }

    function currentAliasEntityChanged(aliasId, currentEntity) {
        vm.aliasController.updateCurrentAliasEntity(aliasId, currentEntity);
        if (onEntityAliasesUpdate) {
            onEntityAliasesUpdate();
        }
    }

}
