/**
 * Copyright © 2016-2017 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.thingsboard.server.dao.sql.timeseries;

import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.google.common.util.concurrent.ListenableFuture;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.kv.TsKvQuery;
import org.thingsboard.server.dao.timeseries.TimeseriesDao;

import java.util.List;

@Component
@Slf4j
@ConditionalOnProperty(prefix = "sql", value = "enabled", havingValue = "true")
public class JpaTimeseriesDao implements TimeseriesDao {

    @Override
    public long toPartitionTs(long ts) {
        return 0;
    }

    @Override
    public ListenableFuture<List<TsKvEntry>> findAllAsync(EntityId entityId, List<TsKvQuery> queries) {
        return null;
    }

    @Override
    public ResultSetFuture findLatest(EntityId entityId, String key) {
        return null;
    }

    @Override
    public ResultSetFuture findAllLatest(EntityId entityId) {
        return null;
    }

    @Override
    public ResultSetFuture save(EntityId entityId, long partition, TsKvEntry tsKvEntry) {
        return null;
    }

    @Override
    public ResultSetFuture savePartition(EntityId entityId, long partition, String key) {
        return null;
    }

    @Override
    public ResultSetFuture saveLatest(EntityId entityId, TsKvEntry tsKvEntry) {
        return null;
    }

    @Override
    public TsKvEntry convertResultToTsKvEntry(Row row) {
        return null;
    }

    @Override
    public List<TsKvEntry> convertResultToTsKvEntryList(List<Row> rows) {
        return null;
    }
}
