/**
 * Copyright © 2016-2017 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.thingsboard.server.dao.user;

import java.util.List;
import java.util.UUID;

import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.page.TextPageLink;
import org.thingsboard.server.dao.Dao;
import org.thingsboard.server.dao.model.UserEntity;

public interface UserDao extends Dao<UserEntity> {

    /**
     * Save or update user object
     *
     * @param user the user object
     * @return saved user entity
     */
    UserEntity save(User user);

    /**
     * Find user by email.
     *
     * @param email the email
     * @return the user entity
     */
    UserEntity findByEmail(String email);
    
    /**
     * Find tenant admin users by tenantId and page link.
     *
     * @param tenantId the tenantId
     * @param pageLink the page link
     * @return the list of user entities
     */
    List<UserEntity> findTenantAdmins(UUID tenantId, TextPageLink pageLink);
    
    /**
     * Find customer users by tenantId, customerId and page link.
     *
     * @param tenantId the tenantId
     * @param customerId the customerId
     * @param pageLink the page link
     * @return the list of user entities
     */
    List<UserEntity> findCustomerUsers(UUID tenantId, UUID customerId, TextPageLink pageLink);
    
}
