/*
 * Copyright © 2016 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* eslint-disable import/no-unresolved, import/default */

import profileTemplate from './profile.tpl.html';

/* eslint-enable import/no-unresolved, import/default */

/*@ngInject*/
export default function ProfileRoutes($stateProvider) {

    $stateProvider
        .state('home.profile', {
            url: '/profile',
            module: 'private',
            auth: ['SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER'],
            views: {
                "content@home": {
                    templateUrl: profileTemplate,
                    controllerAs: 'vm',
                    controller: 'ProfileController'
                }
            },
            data: {
                pageTitle: 'profile.profile'
            },
            ncyBreadcrumb: {
                label: '{"icon": "account_circle", "label": "profile.profile"}'
            }
        });

}
