/*
 * Copyright © 2016-2018 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
export default function addLocaleItalian(locales) {
    var it_IT = {
        "access": {
            "unauthorized": "Non autorizzato",
            "unauthorized-access": "Accesso non autorizzato",
            "unauthorized-access-text": "Devi effettuare il login per accedere a questa risorsa!",
            "access-forbidden": "Accesso Vietato",
            "access-forbidden-text": "Non hai i diritti di accesso a questa posizione!<br/>Prova ad effettuare il login con un diverso account.",
            "refresh-token-expired": "Sessione scaduta",
            "refresh-token-failed": "Impossibile aggiornare la sessione"
        },
        "action": {
                    "activate": "Attiva",
                    "suspend": "Sospendi",
                    "save": "Salva",
                    "saveAs": "Salva come",
                    "cancel": "Cancella",
                    "ok": "OK",
                    "delete": "Elimina",
                    "add": "Aggiungi",
                    "yes": "Sì",
                    "no": "No",
                    "update": "Aggiorna",
                    "remove": "Rimuovi",
                    "search": "Cerca",
                    "clear-search": "Cancella ricerca",
                    "assign": "Assegna",
                    "unassign": "Annulla assegnazione",
                    "share": "Condividi",
                    "make-private": "Rendi privato",
                    "apply": "Applica",
                    "apply-changes": "Applica modifiche",
                    "edit-mode": "Modalità modifica",
                    "enter-edit-mode": "Attiva la modalità di modifica",
                    "decline-changes": "Annulla le modifiche",
                    "close": "Chiudi",
                    "back": "Indietro",
                    "run": "Esegui",
                    "sign-in": "Registrati!",
                    "edit": "Modifica",
                    "view": "Visualizza",
                    "create": "Crea",
                    "drag": "Trascina",
                    "refresh": "Aggiorna",
                    "undo": "Annulla",
                    "copy": "Copia",
                    "paste": "Incolla",
                    "copy-reference": "Copia riferimento",
                    "paste-reference": "Incolla riferimento",
                    "import": "Importa",
                    "export": "Esporta",
                    "share-via": "Condividi con {{provider}}"
                },
                "aggregation": {
                    "aggregation": "Aggregazione",
                    "function": "Funzione di aggregazione dei dati",
                    "limit": "Valori max",
                    "group-interval": "Intervallo di raggruppamento",
                    "min": "Min",
                    "max": "Max",
                    "avg": "Media",
                    "sum": "Somma",
                    "count": "Conteggio",
                    "none": "Nessuna"
                },
                "admin": {
                    "general": "Generale",
                    "general-settings": "Impostazioni Generali",
                    "outgoing-mail": "Posta in uscita",
                    "outgoing-mail-settings": "Impostazioni Posta in uscita",
                    "system-settings": "Impostazioni di sistema",
                    "test-mail-sent": "Mail di test inviata con successo!",
                    "base-url": "URL di base",
                    "base-url-required": "URL di base obbligatoria.",
                    "mail-from": "Mittente",
                    "mail-from-required": "Mittente obbligatorio.",
                    "smtp-protocol": "Protocollo SMTP",
                    "smtp-host": "Host SMTP",
                    "smtp-host-required": "Host SMTP obbligatorio.",
                    "smtp-port": "Porta SMTP",
                    "smtp-port-required": "Porta SMTP obbligatoria.",
                    "smtp-port-invalid": "Numero di porta SMTP non valido.",
                    "timeout-msec": "Timeout (msec)",
                    "timeout-required": "Timeout obbligatorio.",
                    "timeout-invalid": "Timeout non valido.",
                    "enable-tls": "Abilita TLS",
                    "send-test-mail": "Invia mail di test"
                },
                "alarm": {
                    "alarm": "Allarme",
                    "alarms": "Allarmi",
                    "select-alarm": "Seleziona un allarme",
                    "no-alarms-matching": "Nessun allarme corrispondente a '{{entity}}' è stato trovato.",
                    "alarm-required": "Allarme richiesto",
                    "alarm-status": "Stato Allarme",
                    "search-status": {
                        "ANY": "Qualsiasi",
                        "ACTIVE": "Attivo",
                        "CLEARED": "Cancellato",
                        "ACK": "Riconosciuto",
                        "UNACK": "Non riconosciuto"
                    },
                    "display-status": { //TODO
                        "ACTIVE_UNACK": "Active Unacknowledged", 
                        "ACTIVE_ACK": "Active Acknowledged",
                        "CLEARED_UNACK": "Cleared Unacknowledged",
                        "CLEARED_ACK": "Cleared Acknowledged"
                    },
                    "no-alarms-prompt": "Nessun allarme trovato",
                    "created-time": "Orario di creazione",
                    "type": "Tipo",
                    "severity": "Gravità",
                    "originator": "Origine", 
                    "originator-type": "Tipo origine", 
                    "details": "Dettagli",
                    "status": "Stato",
                    "alarm-details": "Dettagli allarme",
                    "start-time": "Orario inizio",
                    "end-time": "Orario fine",
                    "ack-time": "Orario conferma",
                    "clear-time": "Orario cancellazione",
                    "severity-critical": "Critico",
                    "severity-major": "Maggiore",
                    "severity-minor": "Minore",
                    "severity-warning": "Avviso",
                    "severity-indeterminate": "Indeterminato",
                    "acknowledge": "Conferma",
                    "clear": "Cancella",
                    "search": "Ricerca allarmi",
                    "selected-alarms": "{ count, select, 1 {1 allarme selezionato} other {# allarmi selezionati} }",
                    "no-data": "Nessun dato da visualizzare",
                    "polling-interval": "Intervallo di polling (sec) Allarmi",
                    "polling-interval-required": "Intervallo di polling Allarmi richiesto.",
                    "min-polling-interval-message": "L'intervallo di polling deve essere di almeno 1 sec.",
                    "aknowledge-alarms-title": "Conferma { count, select, 1 {1 allarme} other {# allarmi} }",
                    "aknowledge-alarms-text": "Sei sicuro di voler confermare { count, select, 1 {1 allarme} other {# allarmi} }?", 
                    "clear-alarms-title": "Elimina { count, select, 1 {1 allarme} other {# allarmi} }",
                    "clear-alarms-text": "Sei sicuro di voler eliminare { count, select, 1 {1 allarme} other {# allarmi} }?" 
                },
                "alias": {
                    "add": "Aggiungi alias",
                    "edit": "Modifica alias",
                    "name": "Nome Alias",
                    "name-required": "Nome Alias obbligatorio",
                    "duplicate-alias": "Un Alias con lo stesso nome è già presente.",
                    "filter-type-single-entity": "Singola entità",
                    "filter-type-entity-list": "Lista Entità",
                    "filter-type-entity-name": "Nome Entità",
                    "filter-type-state-entity": "Entity from dashboard state", //TODO
                    "filter-type-state-entity-description": "Entità prelevata dai parametri di stato della dashboard",
                    "filter-type-asset-type": "Tipo di Asset",
                    "filter-type-asset-type-description": "Asset di tipo '{{assetType}}'",
                    "filter-type-asset-type-and-name-description": "Asset di tipo '{{assetType}}' e con un nome che inizia per '{{prefix}}'",
                    "filter-type-device-type": "Tipo di dispositivo",
                    "filter-type-device-type-description": "Dispositivi di tipo '{{deviceType}}'",
                    "filter-type-device-type-and-name-description": "Dispositivi di tipo '{{deviceType}}' e con un nome che inizia per '{{prefix}}'",
                    "filter-type-relations-query": "Relations query",
                    "filter-type-relations-query-description": "{{entities}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
                    "filter-type-asset-search-query": "Asset search query",
                    "filter-type-asset-search-query-description": "Assets with types {{assetTypes}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
                    "filter-type-device-search-query": "Device search query",
                    "filter-type-device-search-query-description": "Devices with types {{deviceTypes}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
                    "entity-filter": "Filtro entità",
                    "resolve-multiple": "Resolve as multiple entities",
                    "filter-type": "Tipo di filtro",
                    "filter-type-required": "Tipo di filtro richiesto.",
                    "entity-filter-no-entity-matched": "Nessuna entità corrispondente al filtro specificato è stata trovata.",
                    "no-entity-filter-specified": "Nessun filtro di entità specificato",
                    "root-state-entity": "Use dashboard state entity as root",
                    "root-entity": "Entità radice",
                    "state-entity-parameter-name": "State entity parameter name",
                    "default-state-entity": "Default state entity",
                    "default-entity-parameter-name": "By default",
                    "max-relation-level": "Max relation level",
                    "unlimited-level": "Unlimited level",
                    "state-entity": "Dashboard state entity",
                    "all-entities": "Tutte le entità",
                    "any-relation": "qualsiasi"
                },
                "asset": {
                    "asset": "Asset",
                    "assets": "Asset",
                    "management": "Gestione Asset",
                    "view-assets": "Visualizza Asset",
                    "add": "Aggiungi Asset",
                    "assign-to-customer": "Assegna a cliente",
                    "assign-asset-to-customer": "Assegna Asset al Cliente",
                    "assign-asset-to-customer-text": "Seleziona gli asset da assegnare al cliente",
                    "no-assets-text": "Nessun asset trovato",
                    "assign-to-customer-text": "Seleziona il cliente a cui assegnare l'asset / gli asset",
                    "public": "Pubblico",
                    "assignedToCustomer": "Assegnato al cliente",
                    "make-public": "Rendi pubblico l'asset",
                    "make-private": "Rendi privato l'asset",
                    "unassign-from-customer": "Assegnazione annullata dal cliente",
                    "delete": "Cancella asset",
                    "asset-public": "L'Asset è pubblico",
                    "asset-type": "Tipo di Asset",
                    "asset-type-required": "Tipo di Asset richiesto.",
                    "select-asset-type": "Seleziona tipo di asset",
                    "enter-asset-type": "Inserisci tipo di asset",
                    "any-asset": "Qualsiasi asset",
                    "no-asset-types-matching": "Nessun asset corrispondente al tipo '{{entitySubtype}}' è stato trovato.",
                    "asset-type-list-empty": "Nessun tipo di asset selezionato.",
                    "asset-types": "Tipi di Asset",
                    "name": "Nome",
                    "name-required": "Nome obbligatorio.",
                    "description": "Descrizione",
                    "type": "Tipo",
                    "type-required": "Tipo obbligatorio.",
                    "details": "Dettagli",
                    "events": "Eventi",
                    "add-asset-text": "Aggiungi un nuovo asset",
                    "asset-details": "Dettagli Asset",
                    "assign-assets": "Assegna asset",
                    "assign-assets-text": "Assegna { count, select, 1 {1 asset} other {# assets} } al cliente",
                    "delete-assets": "Cancella asset",
                    "unassign-assets": "Annulla assegnazione asset",
                    "unassign-assets-action-title": "Unassign { count, select, 1 {1 asset} other {# assets} } from customer",
                    "assign-new-asset": "Assegna un nuovo asset",
                    "delete-asset-title": "Sei sicuro di voler cancellare l'asset '{{assetName}}'?",
                    "delete-asset-text": "Attenzione, dopo la conferma l'asset e tutti i relativi dati non saranno più recuperabili.",
                    "delete-assets-title": "Sei sicuro di voler eliminare { count, select, 1 {1 asset} other {# asset} }?",
                    "delete-assets-action-title": "Elimina { count, select, 1 {1 asset} other {# asset} }",
                    "delete-assets-text": "Attenzione, dopo la modifica tutti gli asset selezionati saranno rimossi e tutti i relativi dati non saranno più recuperabili.",
                    "make-public-asset-title": "Sei sicuro di voler rendere pubblico l'asset '{{assetName}}'?",
                    "make-public-asset-text": "Dopo la conferma l'asset e tutti i suoi dati saranno resi pubblici e accessibili dagli altri.",
                    "make-private-asset-title": "Sei sicuro di voler rendere privato l'asset '{{assetName}}'?",
                    "make-private-asset-text": "Dopo la conferma l'asset e tutti i suoi dati saranno resi privati e non accessibili dagli altri.",
                    "unassign-asset-title": "Sei sicuro di voler annullare l'assegnazione dell'asset '{{assetName}}'?",
                    "unassign-asset-text": "Dopo la conferma l'assegnazione dell'asset sarà annullata e l'asset non sarà più accessibile dal cliente.",
                    "unassign-asset": "Annulla assegnazione asset",
                    "unassign-assets-title": "Sei sicuro di voler annullare l'assegnazione di { count, select, 1 {1 asset} other {# asset} }?",
                    "unassign-assets-text": "Dopo la conferma sarà annullata l'assegnazione di tutti gli asset selezionati e questi non saranno più accessibili dal cliente.",
                    "copyId": "Copia Id asset",
                    "idCopiedMessage": "Id Asset copiato negli Appunti",
                    "select-asset": "Seleziona asset",
                    "no-assets-matching": "Nessun asset corrispondente a '{{entity}}' é stato trovato.",
                    "asset-required": "Asset obbligatorio",
                    "name-starts-with": "Asset con nome che inizia per"
                },
                "attribute": {
                    "attributes": "Attributi",
                    "latest-telemetry": "Ultima telemetria",
                    "attributes-scope": "Entity attributes scope",
                    "scope-latest-telemetry": "Ultima telemetria",
                    "scope-client": "Attributi client",
                    "scope-server": "Attributi server",
                    "scope-shared": "Attributi condivisi",
                    "add": "Aggiungi attributo",
                    "key": "Chiave",
                    "last-update-time": "Ultimo aggiornamento",
                    "key-required": "Attributo chiave richiesto.",
                    "value": "Valore",
                    "value-required": "Attributo valore richiesto.",
                    "delete-attributes-title": "Sei sicuro di voler eliminare { count, select, 1 {1 attributo} other {# attributi} }?",
                    "delete-attributes-text": "Attenzione, dopo la conferma tutti gli attributi selezionati saranno rimossi.",
                    "delete-attributes": "Elimina attributi",
                    "enter-attribute-value": "Inserisci il valore dell'attributo",
                    "show-on-widget": "Mostra sul widget",
                    "widget-mode": "Modalità Widget",
                    "next-widget": "Widget successivo",
                    "prev-widget": "Widget precedente",
                    "add-to-dashboard": "Aggiungi alla dashboard",
                    "add-widget-to-dashboard": "Aggiungi widget alla dashboard",
                    "selected-attributes": "{ count, select, 1 {1 attributo selezionato} other {# attributi selezioati} }",
                    "selected-telemetry": "{ count, select, 1 {1 unità di telemetria selezionata} other {# unità di telemetria selezionate} }"
                },
                "audit-log": {
                    "audit": "Audit",
                    "audit-logs": "Audit Logs",
                    "timestamp": "Timestamp",
                    "entity-type": "Tipo Entità",
                    "entity-name": "Nome Entità",
                    "user": "Utente",
                    "type": "Tipo",
                    "status": "Stato",
                    "details": "Dettagli",
                    "type-added": "Aggiunto",
                    "type-deleted": "Eliminato",
                    "type-updated": "Aggiornato",
                    "type-attributes-updated": "Attributi aggiornati",
                    "type-attributes-deleted": "Attributi eliminati",
                    "type-rpc-call": "Chiamata RPC",
                    "type-credentials-updated": "Credenziali aggiornate",
                    "type-assigned-to-customer": "Assegnato al Cliente",
                    "type-unassigned-from-customer": "Assegnazione annullata dal Cliente",
                    "type-activated": "Attivato",
                    "type-suspended": "Sospeso",
                    "type-credentials-read": "Credenziali lette",
                    "type-attributes-read": "Attributi letti",
                    "status-success": "Success",
                    "status-failure": "Failure",
                    "audit-log-details": "Dettaglio log audit",
                    "no-audit-logs-prompt": "Log non trovati",
                    "action-data": "Action data",
                    "failure-details": "Failure details",
                    "search": "Riceraca log audit",
                    "clear-search": "Cancella ricerca"
                },
                "confirm-on-exit": {
                    "message": "Alcune modifiche non sono state salvate. Sei sicuro di voler abbandonare questa pagina?",
                    "html-message": "Alcune modifiche non sono state salvate.<br/>Sei sicuro di voler abbandonare questa pagina?",
                    "title": "Modifiche non salvate"
                },
                "contact": {
                    "country": "Nazione",
                    "city": "Città",
                    "state": "Stato / Provincia",
                    "postal-code": "CAP",
                    "postal-code-invalid": "Formato CAP non valido.",
                    "address": "Indirizzo",
                    "address2": "Indirizzo 2",
                    "phone": "Telefono",
                    "email": "Email",
                    "no-address": "Nessun indirizzo"
                },
                "common": {
                    "username": "Nome utente",
                    "password": "Password",
                    "enter-username": "Inserisci nome utente",
                    "enter-password": "Inserisci password",
                    "enter-search": "Enter search"
                },
                "content-type": {
                    "json": "Json",
                    "text": "Testo",
                    "binary": "Binario (Base64)"
                },
                "customer": {
                    "customer": "Cliente",
                    "customers": "Clienti",
                    "management": "Gestione cliente",
                    "dashboard": "Dashboard cliente",
                    "dashboards": "Dashboard cliente",
                    "devices": "Dispositivi cliente",
                    "assets": "Asset cliente",
                    "public-dashboards": "Dashboard pubbliche",
                    "public-devices": "Dispositivi pubblici",
                    "public-assets": "Asset pubblici",
                    "add": "Aggiungi cliente",
                    "delete": "Elimina cliente",
                    "manage-customer-users": "Gestisci utenti cliente",
                    "manage-customer-devices": "Gestisci dispositivi cliente",
                    "manage-customer-dashboards": "Gestisci dashboard cliente",
                    "manage-public-devices": "Gestisci dispositivi pubblici",
                    "manage-public-dashboards": "Gestisci dashboard pubbliche",
                    "manage-customer-assets": "Gestisci asset cliente",
                    "manage-public-assets": "Gestisci asset pubblici",
                    "add-customer-text": "Aggiungi nuovo cliente",
                    "no-customers-text": "Nessun cliente trovato",
                    "customer-details": "Dettagli cliente",
                    "delete-customer-title": "Sei sicuro di voler eliminare il cliente '{{customerTitle}}'?",
                    "delete-customer-text": "Attenzione, dopo la conferma il cliente e tutti i suoi dati non saranno più recuperabili.",
                    "delete-customers-title": "Sei sicuro di voler cancellare { count, select, 1 {1 cliente} other {# clienti} }?",
                    "delete-customers-action-title": "Elimina { count, select, 1 {1 cliente} other {# clienti} }",
                    "delete-customers-text": "Attenzione, dopo la conferma tutti i clienti selezionati saranno rimossi e i loro dati non saranno più recuperabili.",
                    "manage-users": "Gestisci utenti",
                    "manage-assets": "Gestisci asset",
                    "manage-devices": "Gestisci dispositivi",
                    "manage-dashboards": "Gestisci dashboard",
                    "title": "Titolo",
                    "title-required": "Titolo obbligatorio.",
                    "description": "Descrizione",
                    "details": "Dettagli",
                    "events": "Eventi",
                    "copyId": "Copia Id cliente",
                    "idCopiedMessage": "Id cliente copiato negli appunti",
                    "select-customer": "Seleziona cliente",
                    "no-customers-matching": "Nessun cliente corrispondente a '{{entity}}' è stato trovato.",
                    "customer-required": "Cliente obbligatorio",
                    "select-default-customer": "Seleziona cliente di default",
                    "default-customer": "Cliente di default",
                    "default-customer-required": "Default customer is required in order to debug dashboard on Tenant level"
                },
                "datetime": {
                    "date-from": "Data da",
                    "time-from": "Orario da",
                    "date-to": "Data a",
                    "time-to": "Orario a"
                },
                "dashboard": {
                    "dashboard": "Dashboard",
                    "dashboards": "Dashboard",
                    "management": "Gestione Dashboard",
                    "view-dashboards": "Mostra Dashboard",
                    "add": "Aggiungi Dashboard",
                    "assign-dashboard-to-customer": "Assegna Dashboard al cliente",
                    "assign-dashboard-to-customer-text": "Seleziona le dashboard da assegnare al client",
                    "assign-to-customer-text": "Seleziona il cliente a cui assegnare la/le dashboard",
                    "assign-to-customer": "Assegna al cliente",
                    "unassign-from-customer": "Unassign from customer",
                    "make-public": "Rendi pubblica la dashboard",
                    "make-private": "Rendi privata la dashboard",
                    "manage-assigned-customers": "Gestisci i clienti assegnati",
                    "assigned-customers": "Clienti assegnati",
                    "assign-to-customers": "Assegna Dashboard ai Clienti",
                    "assign-to-customers-text": "Seleziona i clienti da assegnare alla/alle dashboard",
                    "unassign-from-customers": "Unassign Dashboard(s) From Customers",
                    "unassign-from-customers-text": "Please select the customers to unassign from the dashboard(s)",
                    "no-dashboards-text": "Nessuna dashboard trovata",
                    "no-widgets": "Nessun widget configurato",
                    "add-widget": "Aggiungi nuovo widget",
                    "title": "Titolo",
                    "select-widget-title": "Seleziona widget",
                    "select-widget-subtitle": "Elenco tipi di widget disponibili",
                    "delete": "Elimina dashboard",
                    "title-required": "Titolo obbligatorio.",
                    "description": "Descrizione",
                    "details": "Dettagli",
                    "dashboard-details": "Dettagli Dashboard",
                    "add-dashboard-text": "Aggiungi nuova dashboard",
                    "assign-dashboards": "Assegna dashboard",
                    "assign-new-dashboard": "Assegna nuova dashboard",
                    "assign-dashboards-text": "Assegna { count, select, 1 {1 dashboard} other {# dashboard} } ai clienti",
                    "unassign-dashboards-action-text": "Unassign { count, select, 1 {1 dashboard} other {# dashboards} } from customers",
                    "delete-dashboards": "Elimina dashboard",
                    "unassign-dashboards": "Annulla assegnazione dashboard",
                    "unassign-dashboards-action-title": "Unassign { count, select, 1 {1 dashboard} other {# dashboards} } from customer",
                    "delete-dashboard-title": "Sei sicuro di voler cancellare la dashboard '{{dashboardTitle}}'?",
                    "delete-dashboard-text": "Attenzione, dopo la conferma la dashboard e tutti i suoi dati non saranno più recuperabili.",
                    "delete-dashboards-title": "Sei sicuro di voler eliminare { count, select, 1 {1 dashboard} other {# dashboard} }?",
                    "delete-dashboards-action-title": "Cancella { count, select, 1 {1 dashboard} other {# dashboard} }",
                    "delete-dashboards-text": "Attenzione, dopo la conferma tutte le dashboard selezionate saranno eliminate e tutti i loro dati non saranno più recuperabili.",
                    "unassign-dashboard-title": "Sei sicuro di voler annullare l'assegnazione della dashboard '{{dashboardTitle}}'?",
                    "unassign-dashboard-text": "Dopo la conferma sarà annullata l'assegnazione della dashboard e questa non sarà più accessibile dal cliente.",
                    "unassign-dashboard": "Annulla assegnazione dashboard",
                    "unassign-dashboards-title": "Sei sicuro di voler annullare l'assegnazione di  { count, select, 1 {1 dashboard} other {# dashboard} }?",
                    "unassign-dashboards-text": "Dopo la conferma sarà annullata l'assegnazione di tutte le dashboards selezionate e queste non saranno più accessibili dal cliente.",
                    "public-dashboard-title": "La Dashboard è ora pubblica",
                    "public-dashboard-text": "La dashboard <b>{{dashboardTitle}}</b> è ora pubblica e accessibile al <a href='{{publicLink}}' target='_blank'>link</a>:",
                    "public-dashboard-notice": "<b>Nota:</b> Ricorda di rendere pubblici i relativi dispositivi per accedere ai loro dati.",
                    "make-private-dashboard-title": "Sei sicuro di voler rendere privata la dashboard '{{dashboardTitle}}'?",
                    "make-private-dashboard-text": "Dopo la conferma la dashboard sarà resa privata e non più accessibile dagli altri.",
                    "make-private-dashboard": "Rendi privata la dashboard",
                    "socialshare-text": "'{{dashboardTitle}}' powered by ThingsBoard",
                    "socialshare-title": "'{{dashboardTitle}}' powered by ThingsBoard",
                    "select-dashboard": "Seleziona dashboard",
                    "no-dashboards-matching": "Nessuna dashboard corrispondente a '{{entity}}' è stata trovata.",
                    "dashboard-required": "Dashboard obbligatoria.",
                    "select-existing": "Seleziona una dashboard esistente",
                    "create-new": "Crea nuova dashboard",
                    "new-dashboard-title": "Titolo nuova dashboard",
                    "open-dashboard": "Apri dashboard",
                    "set-background": "Imposta sfondo",
                    "background-color": "Colore sfondo",
                    "background-image": "Immagine sfondo",
                    "background-size-mode": "Background size mode",
                    "no-image": "Nessuna immagine selezionata",
                    "drop-image": "Trascina un'immagine o fai clic per selezionare un file da caricare.",
                    "settings": "Impostazioni",
                    "columns-count": "Numero colonne",
                    "columns-count-required": "Numero colonne obbligatorio.",
                    "min-columns-count-message": "Only 10 minimum column count is allowed.",
                    "max-columns-count-message": "Only 1000 maximum column count is allowed.",
                    "widgets-margins": "Margine tra i widget",
                    "horizontal-margin": "Margine orizzontale",
                    "horizontal-margin-required": "Margine orizzontale obbligatorio.",
                    "min-horizontal-margin-message": "Only 0 is allowed as minimum horizontal margin value.",
                    "max-horizontal-margin-message": "Only 50 is allowed as maximum horizontal margin value.",
                    "vertical-margin": "Margine verticale",
                    "vertical-margin-required": "Margine verticale obbligatorio.",
                    "min-vertical-margin-message": "Only 0 is allowed as minimum vertical margin value.",
                    "max-vertical-margin-message": "Only 50 is allowed as maximum vertical margin value.",
                    "autofill-height": "Auto fill layout height",
                    "mobile-layout": "Impostazioni layout mobile",
                    "mobile-row-height": "Mobile row height, px",
                    "mobile-row-height-required": "Mobile row height value is required.",
                    "min-mobile-row-height-message": "Only 5 pixels is allowed as minimum mobile row height value.",
                    "max-mobile-row-height-message": "Only 200 pixels is allowed as maximum mobile row height value.",
                    "display-title": "Mostra titolo dashboard",
                    "toolbar-always-open": "Keep toolbar opened",
                    "title-color": "Colore titolo",
                    "display-dashboards-selection": "Mostra selezione dashboard",
                    "display-entities-selection": "Display entities selection",
                    "display-dashboard-timewindow": "Display timewindow",
                    "display-dashboard-export": "Display export",
                    "import": "Importa dashboard",
                    "export": "Esporta dashboard",
                    "export-failed-error": "Impossibile esportare la dashboard: {{error}}",
                    "create-new-dashboard": "Crea nuova dashboard",
                    "dashboard-file": "File dashboard",
                    "invalid-dashboard-file-error": "Impossibile importare la dashboard: struttura dati della dashboard non valida.",
                    "dashboard-import-missing-aliases-title": "Configura alias utilizzati dalla dashboard importata",
                    "create-new-widget": "Crea nuovo widget",
                    "import-widget": "Importa widget",
                    "widget-file": "Widget file",
                    "invalid-widget-file-error": "Impossibile importare il widget: struttura dati del widget non valida.",
                    "widget-import-missing-aliases-title": "Configura gli alias utilizzati dai widget importati",
                    "open-toolbar": "Apri barra degli strumenti",
                    "close-toolbar": "Chiudi barra degli strumenti",
                    "configuration-error": "Errore di configurazione",
                    "alias-resolution-error-title": "Errore di configurazione degli alias della dashboard",
                    "invalid-aliases-config": "Impossibile trovare un dispositivo corrispondente ad un qualche filtro degli alias.<br/>" +
                        "Contatta l'amministratore per risolvere il problema.",
                    "select-devices": "Seleziona dispositivi",
                    "assignedToCustomer": "Assegnato al cliente",
                    "assignedToCustomers": "Assegnato ai clienti",
                    "public": "Pubblico",
                    "public-link": "Link pubblico",
                    "copy-public-link": "Copia link pubblico",
                    "public-link-copied-message": "Link pubblico della dashboard copiato negli appunti",
                    "manage-states": "Manage dashboard states",
                    "states": "Dashboard states",
                    "search-states": "Search dashboard states",
                    "selected-states": "{ count, select, 1 {1 dashboard state} other {# dashboard states} } selected",
                    "edit-state": "Edit dashboard state",
                    "delete-state": "Delete dashboard state",
                    "add-state": "Add dashboard state",
                    "state": "Dashboard state",
                    "state-name": "Nome",
                    "state-name-required": "Dashboard state name is required.",
                    "state-id": "State Id",
                    "state-id-required": "Dashboard state id is required.",
                    "state-id-exists": "Dashboard state with the same id is already exists.",
                    "is-root-state": "Root state",
                    "delete-state-title": "Delete dashboard state",
                    "delete-state-text": "Are you sure you want delete dashboard state with name '{{stateName}}'?",
                    "show-details": "Mostra dettagli",
                    "hide-details": "Nascondi dettagli",
                    "select-state": "Select target state",
                    "state-controller": "Stato controller"
                },
                "datakey": {
                    "settings": "Impostazioni",
                    "advanced": "Avanzate",
                    "label": "Etichetta",
                    "color": "Colore",
                    "units": "Simbolo speciale da mostrare accanto al valore",
                    "decimals": "Numero cifre decimali",
                    "data-generation-func": "Funzione generazione dati",
                    "use-data-post-processing-func": "Use data post-processing function",
                    "configuration": "Data key configuration",
                    "timeseries": "Serie temporali",
                    "attributes": "Attributi",
                    "alarm": "Campi allarme",
                    "timeseries-required": "Entity timeseries are required.",
                    "timeseries-or-attributes-required": "Entity timeseries/attributes are required.",
                    "maximum-timeseries-or-attributes": "Maximum { count, select, 1 {1 timeseries/attribute is allowed.} other {# timeseries/attributes are allowed} }",
                    "alarm-fields-required": "Campi allarme obbligatori.",
                    "function-types": "Tipi funzione",
                    "function-types-required": "Tipi funzione obbligatorio.",
                    "maximum-function-types": "Massimo { count, select, 1 {1 tipo di funzione consentito.} other {# tipi di funzione consentiti} }"
                },
                "datasource": {
                    "type": "Tipo sorgente dati",
                    "name": "Nome",
                    "add-datasource-prompt": "Aggiungi una sorgente dati"
                },
                "details": {
                    "edit-mode": "Modalità modifica",
                    "toggle-edit-mode": "Toggle edit mode"
                },
                "device": {
                    "device": "Dispositivo",
                    "device-required": "Dispositivo richiesto.",
                    "devices": "Dispositivi",
                    "management": "Gestione dispositivo",
                    "view-devices": "Visualizza Dispositivi",
                    "device-alias": "Alias dispositivo",
                    "aliases": "Alias dispositivo",
                    "no-alias-matching": "'{{alias}}' non trovato.",
                    "no-aliases-found": "Nessun alias trovato.",
                    "no-key-matching": "'{{key}}' non trovato.",
                    "no-keys-found": "Nessuna chiave trovata.",
                    "create-new-alias": "Create a new one!",
                    "create-new-key": "Create a new one!",
                    "duplicate-alias-error": "Duplicate alias found '{{alias}}'.<br>Device aliases must be unique whithin the dashboard.",
                    "configure-alias": "Configura alias '{{alias}}'",
                    "no-devices-matching": "Nessun dispositivo corrispondente a '{{entity}}' é stato trovato.",
                    "alias": "Alias",
                    "alias-required": "Alias dispositivo richesto.",
                    "remove-alias": "Rimuovi alias dispositivo",
                    "add-alias": "Aggiungi alias dispositivo",
                    "name-starts-with": "Device name starts with",
                    "device-list": "Lista dispositivi",
                    "use-device-name-filter": "Usa filtro",
                    "device-list-empty": "Nessun dispositivo selezionato.",
                    "device-name-filter-required": "Device name filter is required.",
                    "device-name-filter-no-device-matched": "No devices starting with '{{device}}' were found.",
                    "add": "Aggiungi Dispositivo",
                    "assign-to-customer": "Assigna al cliente",
                    "assign-device-to-customer": "Assegna dispositivo/dispositivi al Cliente",
                    "assign-device-to-customer-text": "Seleziona i dispositivi da assegnare al cliente",
                    "make-public": "Rendi pubblico il dispositivo",
                    "make-private": "rendi privato il dispositivo",
                    "no-devices-text": "Nessun dispositivo trovato",
                    "assign-to-customer-text": "Seleziona il cliente a cui assegnare il dispositivo/i dispositivi",
                    "device-details": "Dettagli dispositivo",
                    "add-device-text": "Aggiungi nuovo dispositivo",
                    "credentials": "Credenziali",
                    "manage-credentials": "Gestisci credenziali",
                    "delete": "Elimina dispositivo",
                    "assign-devices": "Assegna dispositivi",
                    "assign-devices-text": "Assegna { count, select, 1 {1 dispositivo} other {# dispositivi} } al cliente",
                    "delete-devices": "Elimina dispositivi",
                    "unassign-from-customer": "Unassign from customer",
                    "unassign-devices": "Annulla assegnazione dispositivi",
                    "unassign-devices-action-title": "Unassign { count, select, 1 {1 device} other {# devices} } from customer",
                    "assign-new-device": "Assegna nuovo dispositivo",
                    "make-public-device-title": "Sei sicuro di voler rendere pubblico il dispositivo '{{deviceName}}'?",
                    "make-public-device-text": "Dopo la conferma il dispositivo e tutti i suoi dati saranno resi pubblici e accessibili dagli altri.",
                    "make-private-device-title": "Sei sicuro di voler rendere privato il dispositivo '{{deviceName}}'?",
                    "make-private-device-text": "After the confirmation the device and all its data will be made private and won't be accessible by others.",
                    "view-credentials": "Visualizza credenziali",
                    "delete-device-title": "Sei sicuro di voler eliminare il dispositivo '{{deviceName}}'?",
                    "delete-device-text": "Attenzione, dopo la conferma il dispositivo e tutti i suoi dati non saranno più recuperabili.",
                    "delete-devices-title": "Sei sicuro di voler eliminare { count, select, 1 {1 dispositivo} other {# dispositivi} }?",
                    "delete-devices-action-title": "Elimina { count, select, 1 {1 dispositivo} other {# dispositivi} }",
                    "delete-devices-text": "Attenzione, dopo la conferma tutti i dispositivi selezionati saranno elimininati e i relativi dati non saranno più recuperabili.",
                    "unassign-device-title": "Sei sicuro di voler annullare l'assegnazione del dispositivo '{{deviceName}}'?",
                    "unassign-device-text": "Dopo la conferma sarà annullata l'assegnazione del dispositivo e questo non sarà più accessibile dal cliente.",
                    "unassign-device": "Annulla assegnazione dispositivo",
                    "unassign-devices-title": "Sei sicuro di voler annullare la'ssegnazione di { count, select, 1 {1 dispositivo} other {# dispositivi} }?",
                    "unassign-devices-text": "Dopo la conferma sarà annullata l'assegnazione di tutti i dispositivi selezionati e questi non saranno più accessibili dal cliente.",
                    "device-credentials": "Credenziali Dispositivo",
                    "credentials-type": "Tipo credenziali",
                    "access-token": "Token di accesso",
                    "access-token-required": "Token di accesso obbligatorio.",
                    "access-token-invalid": "Access token length must be from 1 to 20 characters.",
                    "rsa-key": "Chiave pubblica RSA",
                    "rsa-key-required": "Chiave pubblica RSA obbligatoria.",
                    "secret": "Secret",
                    "secret-required": "Secret is required.",
                    "device-type": "Tipo dispositivo",
                    "device-type-required": "Tipo dispositivo obbligatorio.",
                    "select-device-type": "Seleziona tipo dispositivo",
                    "enter-device-type": "Inserisci typo dispositivo",
                    "any-device": "Qualsiasi dispositivo",
                    "no-device-types-matching": "Nessun dispositivo corrispondente a '{{entitySubtype}}' è stato trovato.",
                    "device-type-list-empty": "Nessun tipo di dispositivo selezionato.",
                    "device-types": "Tipi dispositivo",
                    "name": "Nome",
                    "name-required": "Nome obbligatorio.",
                    "description": "Descrizione",
                    "events": "Eventi",
                    "details": "Dettagli",
                    "copyId": "Copia Id dispositivo",
                    "copyAccessToken": "Copia token di accesso",
                    "idCopiedMessage": "Id dispositivo copiato negli Appunti",
                    "accessTokenCopiedMessage": "Token di accesso del dispositivo copiato negli Appunti",
                    "assignedToCustomer": "Assegnato al cliente",
                    "unable-delete-device-alias-title": "Impossibile rimuovere l'alias del dispositivo",
                    "unable-delete-device-alias-text": "L'alias del dispositivo '{{deviceAlias}}' non può essere eliminato perchè utilizzato dai seguenti widget:<br/>{{widgetsList}}",
                    "is-gateway": "Is gateway",
                    "public": "Pubblico",
                    "device-public": "Il dispositivo è pubblico",
                    "select-device": "Seleziona dispositivo"
                },
                "dialog": {
                    "close": "Close dialog"
                },
                "error": {
                    "unable-to-connect": "Impossibile connettersi al server! Controlla la connessione ad Internet.",
                    "unhandled-error-code": "Unhandled error code: {{errorCode}}",
                    "unknown-error": "Errore sconosciuto"
                },
                "entity": {
                    "entity": "Entità",
                    "entities": "Entità",
                    "aliases": "Alias entità",
                    "entity-alias": "Alias entità",
                    "unable-delete-entity-alias-title": "Impossibile eliminare alias entità",
                    "unable-delete-entity-alias-text": "L'alias dell'entità '{{entityAlias}}' non può essere eliminato perchè utilizzato dai seguenti widget:<br/>{{widgetsList}}",
                    "duplicate-alias-error": "Trovato un duplicato dell'alias '{{alias}}'.<br>Gli alias dell'entità devono essere univoci all'interno della dashboard.",
                    "missing-entity-filter-error": "Filter is missing for alias '{{alias}}'.",
                    "configure-alias": "Configura '{{alias}}' alias",
                    "alias": "Alias",
                    "alias-required": "Alias entità obbligatorio.",
                    "remove-alias": "Rimuovi alias entità",
                    "add-alias": "Aggiungi alias entità",
                    "entity-list": "Lista entità",
                    "entity-type": "Tipo entità",
                    "entity-types": "Tipi entità",
                    "entity-type-list": "Lista tipo entità",
                    "any-entity": "Qualsiasi entità",
                    "enter-entity-type": "Inserisci tipo entità",
                    "no-entities-matching": "Nessuna entità corrispondente a '{{entity}}' è stata trovata.",
                    "no-entity-types-matching": "Nessun tipo di entità corrispondente a '{{entityType}}' è stato trovato.",
                    "name-starts-with": "Nome inizia per",
                    "use-entity-name-filter": "Usa filtro",
                    "entity-list-empty": "Nessuna entità selezionata.",
                    "entity-type-list-empty": "Nessun tipo di entità selezionato.",
                    "entity-name-filter-required": "Entity name filter is required.",
                    "entity-name-filter-no-entity-matched": "No entities starting with '{{entity}}' were found.",
                    "all-subtypes": "Tutte",
                    "select-entities": "Seleziona entità",
                    "no-aliases-found": "Nessun alias trovato.",
                    "no-alias-matching": "'{{alias}}' non trovato.",
                    "create-new-alias": "Create a new one!",
                    "key": "Chiave",
                    "key-name": "Nome chiave",
                    "no-keys-found": "Nessuna chiave trovata.",
                    "no-key-matching": "'{{key}}' non trovata.",
                    "create-new-key": "Create a new one!",
                    "type": "Tipo",
                    "type-required": "Tipo entità obbligatorio.",
                    "type-device": "Dispositivo",
                    "type-devices": "Dispositivi",
                    "list-of-devices": "{ count, select, 1 {Un dispositivo} other {Lista di # dispositivi} }",
                    "device-name-starts-with": "Dispositivi i cui nomi iniziano per '{{prefix}}'",
                    "type-asset": "Asset",
                    "type-assets": "Asset",
                    "list-of-assets": "{ count, select, 1 {Un asset} other {Lista di # asset} }",
                    "asset-name-starts-with": "Asset i cui nomi iniziano per '{{prefix}}'",
                    "type-rule": "Regola",
                    "type-rules": "Regole",
                    "list-of-rules": "{ count, select, 1 {Una regola} other {Lista di # regole} }",
                    "rule-name-starts-with": "Regole i cui nomi iniziano per '{{prefix}}'",
                    "type-plugin": "Plugin",
                    "type-plugins": "Plugin",
                    "list-of-plugins": "{ count, select, 1 {Un plugin} other {Lista di # plugin} }",
                    "plugin-name-starts-with": "Plugin i cui nomi iniziano per '{{prefix}}'",
                    "type-tenant": "Tenant",
                    "type-tenants": "Tenants",
                    "list-of-tenants": "{ count, select, 1 {One tenant} other {List of # tenants} }",
                    "tenant-name-starts-with": "Tenants whose names start with '{{prefix}}'",
                    "type-customer": "Cliente",
                    "type-customers": "Clienti",
                    "list-of-customers": "{ count, select, 1 {Un cliente} other {Lista di # clienti} }",
                    "customer-name-starts-with": "Clienti i cui nomi iniziano per '{{prefix}}'",
                    "type-user": "Utente",
                    "type-users": "Utenti",
                    "list-of-users": "{ count, select, 1 {Un utente} other {Lista of # utenti} }",
                    "user-name-starts-with": "Utenti i cui nomi iniziano per '{{prefix}}'",
                    "type-dashboard": "Dashboard",
                    "type-dashboards": "Dashboard",
                    "list-of-dashboards": "{ count, select, 1 {Una dashboard} other {Lista di # dashboard} }",
                    "dashboard-name-starts-with": "Dashboard i cui nomi iniziano per '{{prefix}}'",
                    "type-alarm": "Allarme",
                    "type-alarms": "Allarmi",
                    "list-of-alarms": "{ count, select, 1 {Un allarme} other {Lista di # allarmi} }",
                    "alarm-name-starts-with": "Allarmi i cui nomi iniziano per '{{prefix}}'",
                    "type-rulechain": "Rule chain",
                    "type-rulechains": "Rule chains",
                    "list-of-rulechains": "{ count, select, 1 {One rule chain} other {List of # rule chains} }",
                    "rulechain-name-starts-with": "Rule chains whose names start with '{{prefix}}'",
                    "type-current-customer": "Current Customer",
                    "search": "Ricerca entità",
                    "selected-entities": "{ count, select, 1 {1 entità selezionata} other {# entità selezionate} }",
                    "entity-name": "Nome entità",
                    "details": "Dettagli entità",
                    "no-entities-prompt": "Nessuna entità trovata",
                    "no-data": "Nessun dato da mostrare"
                },
                "event": {
                    "event-type": "Tipo evento",
                    "type-error": "Errore",
                    "type-lc-event": "Ciclo di vita evento",
                    "type-stats": "Statistiche",
                    "type-debug-rule-node": "Debug",
                    "type-debug-rule-chain": "Debug",
                    "no-events-prompt": "Nessun evento trovato",
                    "error": "Errore",
                    "alarm": "Allarme",
                    "event-time": "Event time",
                    "server": "Server",
                    "body": "Body",
                    "method": "Metodo",
                    "type": "Tipo",
                    "entity": "Entità",
                    "message-id": "Id Messaggio",
                    "message-type": "Tipo Messaggio",
                    "data-type": "Data Type",
                    "relation-type": "Tipo di relazione",
                    "metadata": "Metadati",
                    "data": "Dati",
                    "event": "Evento",
                    "status": "Stato",
                    "success": "Success",
                    "failed": "Failed",
                    "messages-processed": "Messaggi elaborati",
                    "errors-occurred": "Si sono verificati degli errori"
                },
                "extension": {
                    "extensions": "Estensioni",
                    "selected-extensions": "{ count, select, 1 {1 estensione selezionata} other {# estensioni selezionate} }",
                    "type": "Tipo",
                    "key": "Chiave",
                    "value": "Valore",
                    "id": "Id",
                    "extension-id": "Id Estensione",
                    "extension-type": "Tipo Estensione",
                    "transformer-json": "JSON *",
                    "unique-id-required": "Current extension id already exists.",
                    "delete": "Elimina estensione",
                    "add": "Aggiungi estensione",
                    "edit": "Modifica estensione",
                    "delete-extension-title": "Sei sicuro di voler eliminare l'estensione '{{extensionId}}'?",
                    "delete-extension-text": "Attenzione, dopo la conferma l'estensione e tutti i suoi data non saranno più recuperabili.",
                    "delete-extensions-title": "Sei sicuro di voler eliminare { count, select, 1 {1 estensione} other {# estensioni} }?",
                    "delete-extensions-text": "Attenzione, dopo la conferma tutte le estensioni selezionate saranno eliminate.",
                    "converters": "Converters",
                    "converter-id": "Converter id",
                    "configuration": "Configurazione",
                    "converter-configurations": "Converter configurations",
                    "token": "Token di sicurezza",
                    "add-converter": "Add converter",
                    "add-config": "Add converter configuration",
                    "device-name-expression": "Device name expression",
                    "device-type-expression": "Device type expression",
                    "custom": "Custom",
                    "to-double": "To Double",
                    "transformer": "Transformer",
                    "json-required": "Transformer json is required.",
                    "json-parse": "Unable to parse transformer json.",
                    "attributes": "Attributi",
                    "add-attribute": "Aggiungi attributo",
                    "add-map": "Add mapping element",
                    "timeseries": "Serie temporali",
                    "add-timeseries": "Add timeseries",
                    "field-required": "Field is required",
                    "brokers": "Broker",
                    "add-broker": "Aggiungi broker",
                    "host": "Host",
                    "port": "Porta",
                    "port-range": "Port should be in a range from 1 to 65535.",
                    "ssl": "Ssl",
                    "credentials": "Credenziali",
                    "username": "Nome utente",
                    "password": "Password",
                    "retry-interval": "Retry interval in milliseconds",
                    "anonymous": "Anonimo",
                    "basic": "Basic",
                    "pem": "PEM",
                    "ca-cert": "CA certificate file *",
                    "private-key": "File chiave privata *",
                    "cert": "File certificato *",
                    "no-file": "Nessun file selezionato.",
                    "drop-file": "Drop a file or click to select a file to upload.",
                    "mapping": "Mapping",
                    "topic-filter": "Topic filter",
                    "converter-type": "Converter type",
                    "converter-json": "Json",
                    "json-name-expression": "Device name json expression",
                    "topic-name-expression": "Device name topic expression",
                    "json-type-expression": "Device type json expression",
                    "topic-type-expression": "Device type topic expression",
                    "attribute-key-expression": "Attribute key expression",
                    "attr-json-key-expression": "Attribute key json expression",
                    "attr-topic-key-expression": "Attribute key topic expression",
                    "request-id-expression": "Request id expression",
                    "request-id-json-expression": "Request id json expression",
                    "request-id-topic-expression": "Request id topic expression",
                    "response-topic-expression": "Response topic expression",
                    "value-expression": "Value expression",
                    "topic": "Topic",
                    "timeout": "Timeout in millisecondi",
                    "converter-json-required": "Convertitore json obbligatorio.",
                    "converter-json-parse": "Unable to parse converter json.",
                    "filter-expression": "Filter expression",
                    "connect-requests": "Connect requests",
                    "add-connect-request": "Add connect request",
                    "disconnect-requests": "Disconnect requests",
                    "add-disconnect-request": "Add disconnect request",
                    "attribute-requests": "Attribute requests",
                    "add-attribute-request": "Add attribute request",
                    "attribute-updates": "Attribute updates",
                    "add-attribute-update": "Add attribute update",
                    "server-side-rpc": "Server side RPC",
                    "add-server-side-rpc-request": "Add server-side RPC request",
                    "device-name-filter": "Device name filter",
                    "attribute-filter": "Attribute filter",
                    "method-filter": "Method filter",
                    "request-topic-expression": "Request topic expression",
                    "response-timeout": "Response timeout in milliseconds",
                    "topic-expression": "Topic expression",
                    "client-scope": "Client scope",
                    "add-device": "Aggiungi dispositivo",
                    "opc-server": "Server",
                    "opc-add-server": "Aggiungi server",
                    "opc-add-server-prompt": "Aggiungi server",
                    "opc-application-name": "Nome applicazione",
                    "opc-application-uri": "Uri applicazione",
                    "opc-scan-period-in-seconds": "Intervallo di scansione in secondi",
                    "opc-security": "Sicurezza",
                    "opc-identity": "Identità",
                    "opc-keystore": "Keystore",
                    "opc-type": "Tipo",
                    "opc-keystore-type": "Tipo",
                    "opc-keystore-location": "Location *",
                    "opc-keystore-password": "Password",
                    "opc-keystore-alias": "Alias",
                    "opc-keystore-key-password": "Key password",
                    "opc-device-node-pattern": "Device node pattern",
                    "opc-device-name-pattern": "Device name pattern",
                    "modbus-server": "Servers/slaves",
                    "modbus-add-server": "Aggiungi server/slave",
                    "modbus-add-server-prompt": "Aggiungi server/slave",
                    "modbus-transport": "Transport",
                    "modbus-port-name": "Nome porta seriale",
                    "modbus-encoding": "Codifica",
                    "modbus-parity": "Parità",
                    "modbus-baudrate": "Baud rate",
                    "modbus-databits": "Data bits",
                    "modbus-stopbits": "Stop bits",
                    "modbus-databits-range": "Data bits should be in a range from 7 to 8.",
                    "modbus-stopbits-range": "Stop bits should be in a range from 1 to 2.",
                    "modbus-unit-id": "Unit ID",
                    "modbus-unit-id-range": "Unit ID should be in a range from 1 to 247.",
                    "modbus-device-name": "Nome dispositivo",
                    "modbus-poll-period": "Intervallo di polling (ms)",
                    "modbus-attributes-poll-period": "Attributes poll period (ms)",
                    "modbus-timeseries-poll-period": "Timeseries poll period (ms)",
                    "modbus-poll-period-range": "Poll period should be positive value.",
                    "modbus-tag": "Tag",
                    "modbus-function": "Funzione",
                    "modbus-register-address": "Indirizzo registro",
                    "modbus-register-address-range": "Register address should be in a range from 0 to 65535.",
                    "modbus-register-bit-index": "Bit index",
                    "modbus-register-bit-index-range": "Bit index should be in a range from 0 to 15.",
                    "modbus-register-count": "Register count",
                    "modbus-register-count-range": "Register count should be a positive value.",
                    "modbus-byte-order": "Byte order",

                    "sync": {
                        "status": "Status",
                        "sync": "Sync",
                        "not-sync": "Not sync",
                        "last-sync-time": "Last sync time",
                        "not-available": "Not available"
                    },

                    "export-extensions-configuration": "Export extensions configuration",
                    "import-extensions-configuration": "Import extensions configuration",
                    "import-extensions": "Importa estensione",
                    "import-extension": "Importa estensione",
                    "export-extension": "Esporta estensione",
                    "file": "File estensione",
                    "invalid-file-error": "File estensione non valido"
                },
                "fullscreen": {
                    "expand": "Expand to fullscreen",
                    "exit": "Exit fullscreen",
                    "toggle": "Toggle fullscreen mode",
                    "fullscreen": "Fullscreen"
                },
                "function": {
                    "function": "Function"
                },
                "grid": {
                    "delete-item-title": "Are you sure you want to delete this item?",
                    "delete-item-text": "Be careful, after the confirmation this item and all related data will become unrecoverable.",
                    "delete-items-title": "Are you sure you want to delete { count, select, 1 {1 item} other {# items} }?",
                    "delete-items-action-title": "Delete { count, select, 1 {1 item} other {# items} }",
                    "delete-items-text": "Be careful, after the confirmation all selected items will be removed and all related data will become unrecoverable.",
                    "add-item-text": "Add new item",
                    "no-items-text": "No items found",
                    "item-details": "Item details",
                    "delete-item": "Delete Item",
                    "delete-items": "Delete Items",
                    "scroll-to-top": "Scroll to top"
                },
                "help": {
                    "goto-help-page": "Go to help page"
                },
                "home": {
                    "home": "Home",
                    "profile": "Profilo",
                    "logout": "Logout",
                    "menu": "Menu",
                    "avatar": "Avatar",
                    "open-user-menu": "Apri menu utente"
                },
                "import": {
                    "no-file": "Nessun file selezionato",
                    "drop-file": "Trascina un file JSON o fai clic per selezionare un file da caricare."
                },
                "item": {
                    "selected": "Selezionata"
                },
                "js-func": {
                    "no-return-error": "La funzione deve restituire un valore!",
                    "return-type-mismatch": "La funzione deve restituire un valore di tipo '{{type}}'!",
                    "tidy": "Tidy"
                },
                "key-val": {
                    "key": "Chiave",
                    "value": "Valore",
                    "remove-entry": "Remove entry",
                    "add-entry": "Add entry",
                    "no-data": "No entries"
                },
                "layout": {
                    "layout": "Layout",
                    "manage": "Gestisci layout",
                    "settings": "Impostazioni layout",
                    "color": "Colore",
                    "main": "Main",
                    "right": "Right",
                    "select": "Select target layout"
                },
                "legend": {
                    "position": "Posizione Legenda",
                    "show-max": "Mostra valore max",
                    "show-min": "Mostra valore min",
                    "show-avg": "Mostra valore medio",
                    "show-total": "Mostra valore totale",
                    "settings": "Impostazioni legenda",
                    "min": "min",
                    "max": "max",
                    "avg": "avg",
                    "total": "totale"
                },
                "login": {
                    "login": "Login",
                    "request-password-reset": "Request Password Reset",
                    "reset-password": "Azzera Password",
                    "create-password": "Crea Password",
                    "passwords-mismatch-error": "Le password inserite devono corrispondere!",
                    "password-again": "Ripeti Password",
                    "sign-in": "Please sign in",
                    "username": "Nome utente (email)",
                    "remember-me": "Ricordami",
                    "forgot-password": "Password dimenticata?",
                    "password-reset": "Password reset",
                    "new-password": "Nuova password",
                    "new-password-again": "Ripeti nuova password",
                    "password-link-sent-message": "Password reset link was successfully sent!",
                    "email": "Email"
                },
                "position": {
                    "top": "Alto",
                    "bottom": "Basso",
                    "left": "Sinistra",
                    "right": "Destra"
                },
                "profile": {
                    "profile": "Profilo",
                    "change-password": "Modifica Password",
                    "current-password": "Password attuale"
                },
                "relation": {
                    "relations": "Relations",
                    "direction": "Direction",
                    "search-direction": {
                        "FROM": "Da",
                        "TO": "A"
                    },
                    "direction-type": {
                        "FROM": "da",
                        "TO": "a"
                    },
                    "from-relations": "Outbound relations",
                    "to-relations": "Inbound relations",
                    "selected-relations": "{ count, select, 1 {1 relation} other {# relations} } selected",
                    "type": "Tipo",
                    "to-entity-type": "A tipo entità",
                    "to-entity-name": "A nome entità",
                    "from-entity-type": "From entity type",
                    "from-entity-name": "From entity name",
                    "to-entity": "To entity",
                    "from-entity": "From entity",
                    "delete": "Delete relation",
                    "relation-type": "Relation type",
                    "relation-type-required": "Relation type is required.",
                    "any-relation-type": "Any type",
                    "add": "Add relation",
                    "edit": "Edit relation",
                    "delete-to-relation-title": "Are you sure you want to delete relation to the entity '{{entityName}}'?",
                    "delete-to-relation-text": "Be careful, after the confirmation the entity '{{entityName}}' will be unrelated from the current entity.",
                    "delete-to-relations-title": "Are you sure you want to delete { count, select, 1 {1 relation} other {# relations} }?",
                    "delete-to-relations-text": "Be careful, after the confirmation all selected relations will be removed and corresponding entities will be unrelated from the current entity.",
                    "delete-from-relation-title": "Are you sure you want to delete relation from the entity '{{entityName}}'?",
                    "delete-from-relation-text": "Be careful, after the confirmation current entity will be unrelated from the entity '{{entityName}}'.",
                    "delete-from-relations-title": "Are you sure you want to delete { count, select, 1 {1 relation} other {# relations} }?",
                    "delete-from-relations-text": "Be careful, after the confirmation all selected relations will be removed and current entity will be unrelated from the corresponding entities.",
                    "remove-relation-filter": "Remove relation filter",
                    "add-relation-filter": "Add relation filter",
                    "any-relation": "Any relation",
                    "relation-filters": "Relation filters",
                    "additional-info": "Additional info (JSON)",
                    "invalid-additional-info": "Unable to parse additional info json."
                },
                "rulechain": {
                    "rulechain": "Rule chain",
                    "rulechains": "Rule chains",
                    "root": "Root",
                    "delete": "Delete rule chain",
                    "name": "Nome",
                    "name-required": "Nome obbligatorio.",
                    "description": "Descrizione",
                    "add": "Add Rule Chain",
                    "set-root": "Make rule chain root",
                    "set-root-rulechain-title": "Are you sure you want to make the rule chain '{{ruleChainName}}' root?",
                    "set-root-rulechain-text": "After the confirmation the rule chain will become root and will handle all incoming transport messages.",
                    "delete-rulechain-title": "Are you sure you want to delete the rule chain '{{ruleChainName}}'?",
                    "delete-rulechain-text": "Be careful, after the confirmation the rule chain and all related data will become unrecoverable.",
                    "delete-rulechains-title": "Are you sure you want to delete { count, select, 1 {1 rule chain} other {# rule chains} }?",
                    "delete-rulechains-action-title": "Delete { count, select, 1 {1 rule chain} other {# rule chains} }",
                    "delete-rulechains-text": "Be careful, after the confirmation all selected rule chains will be removed and all related data will become unrecoverable.",
                    "add-rulechain-text": "Add new rule chain",
                    "no-rulechains-text": "No rule chains found",
                    "rulechain-details": "Rule chain details",
                    "details": "Dettagli",
                    "events": "Eventi",
                    "system": "Sistema",
                    "import": "Import rule chain",
                    "export": "Export rule chain",
                    "export-failed-error": "Unable to export rule chain: {{error}}",
                    "create-new-rulechain": "Create new rule chain",
                    "rulechain-file": "Rule chain file",
                    "invalid-rulechain-file-error": "Unable to import rule chain: Invalid rule chain data structure.",
                    "copyId": "Copy rule chain Id",
                    "idCopiedMessage": "Rule chain Id has been copied to clipboard",
                    "select-rulechain": "Select rule chain",
                    "no-rulechains-matching": "No rule chains matching '{{entity}}' were found.",
                    "rulechain-required": "Rule chain is required",
                    "management": "Rules management",
                    "debug-mode": "Modalità debug"
                },
                "rulenode": {
                    "details": "Dettagli",
                    "events": "Eventi",
                    "search": "Ricerca nodi",
                    "open-node-library": "Open node library",
                    "add": "Add rule node",
                    "name": "Nome",
                    "name-required": "Nome obbligatorio.",
                    "type": "Tipo",
                    "description": "Descrizione",
                    "delete": "Delete rule node",
                    "select-all-objects": "Seleziona tutti i nodi e le connessioni",
                    "deselect-all-objects": "Deselect all nodes and connections",
                    "delete-selected-objects": "Cancella nodi e connessioni selezionate",
                    "delete-selected": "Delete selected",
                    "select-all": "Seleziona tutto",
                    "copy-selected": "Copy selected",
                    "deselect-all": "Deselect all",
                    "rulenode-details": "Rule node details",
                    "debug-mode": "Modalità debug",
                    "configuration": "Configurazione",
                    "link": "Link",
                    "link-details": "Rule node link details",
                    "add-link": "Aggiungi link",
                    "link-label": "Etichetta link",
                    "link-label-required": "Etichetta link obbligatoria.",
                    "custom-link-label": "Custom link label",
                    "custom-link-label-required": "Custom link label is required.",
                    "type-filter": "Filtro",
                    "type-filter-details": "Filter incoming messages with configured conditions",
                    "type-enrichment": "Enrichment",
                    "type-enrichment-details": "Add additional information into Message Metadata",
                    "type-transformation": "Transformation",
                    "type-transformation-details": "Change Message payload and Metadata",
                    "type-action": "Azioni",
                    "type-action-details": "Perform special action",
                    "type-external": "External",
                    "type-external-details": "Interacts with external system",
                    "type-rule-chain": "Rule Chain",
                    "type-rule-chain-details": "Forwards incoming messages to specified Rule Chain",
                    "type-input": "Input",
                    "type-input-details": "Logical input of Rule Chain, forwards incoming messages to next related Rule Node",
                    "directive-is-not-loaded": "Defined configuration directive '{{directiveName}}' is not available.",
                    "ui-resources-load-error": "Failed to load configuration ui resources.",
                    "invalid-target-rulechain": "Unable to resolve target rule chain!",
                    "test-script-function": "Test script function",
                    "message": "Messaggio",
                    "message-type": "Tipo messaggio",
                    "message-type-required": "Tipo messaggio obbligatorio",
                    "metadata": "Metadata",
                    "metadata-required": "Metadata entries can't be empty.",
                    "output": "Output",
                    "test": "Test",
                    "help": "Aiuto"
                },
                "tenant": {
                    "tenant": "Tenant",
                    "tenants": "Tenant",
                    "management": "Gestione Tenant",
                    "add": "Aggiungi Tenant",
                    "admins": "Amministratori",
                    "manage-tenant-admins": "Gestisci amministratori tenant",
                    "delete": "Cancella tenant",
                    "add-tenant-text": "Aggiungi nuovo tenant",
                    "no-tenants-text": "Nessun tenant trovato",
                    "tenant-details": "Dettagli tenenat",
                    "delete-tenant-title": "Sei sicuro di voler eliminare il tenant '{{tenantTitle}}'?",
                    "delete-tenant-text": "Attenzione, dopo la conferma il tenant e tutti i suoi dati non saranno più recuperabili.",
                    "delete-tenants-title": "Sei sicuro di voler eliminare { count, select, 1 {1 tenant} other {# tenant} }?",
                    "delete-tenants-action-title": "Elimina { count, select, 1 {1 tenant} other {# tenant} }",
                    "delete-tenants-text": "Attenzione, dopo la conferma tutti i tenant selezionati saranno eliminati e tutti i loro dati non saranno più recuperabili.",
                    "title": "Titolo",
                    "title-required": "Titolo obbligatorio.",
                    "description": "Descrizione",
                    "details": "Dettagli",
                    "events": "Eventi",
                    "copyId": "Copia Id tenant",
                    "idCopiedMessage": "Id tenant copiato negli appunti",
                    "select-tenant": "Seleziona tenant",
                    "no-tenants-matching": "Nessun tenant corrispondente a '{{entity}}' è stato trovato.",
                    "tenant-required": "Tenant obbligatorio"
                },
                "timeinterval": {
                    "seconds-interval": "{ seconds, select, 1 {1 secondo} other {# secondi} }",
                    "minutes-interval": "{ minutes, select, 1 {1 minuto} other {# minuti} }",
                    "hours-interval": "{ hours, select, 1 {1 ora} other {# ore} }",
                    "days-interval": "{ days, select, 1 {1 giorno} other {# giorni} }",
                    "days": "Giorni",
                    "hours": "Ore",
                    "minutes": "Minuti",
                    "seconds": "Secondi",
                    "advanced": "Avanzate"
                },
                "timewindow": {
                    "days": "{ days, select, 1 { giorno } other {# giorni } }",
                    "hours": "{ hours, select, 0 { hour } 1 {1 ora } other {# ore } }",
                    "minutes": "{ minutes, select, 0 { minute } 1 {1 minuto } other {# minuti } }",
                    "seconds": "{ seconds, select, 0 { second } 1 {1 secondo } other {# secondi } }",
                    "realtime": "Realtime",
                    "history": "Cronologia",
                    "last-prefix": "last",
                    "period": "from {{ startTime }} to {{ endTime }}",
                    "edit": "Edit timewindow",
                    "date-range": "Date range",
                    "last": "Last",
                    "time-period": "Time period"
                },
                "user": {
                    "user": "Utente",
                    "users": "Utenti",
                    "customer-users": "Customer Users",
                    "tenant-admins": "Amministratori Tenant",
                    "sys-admin": "Amministratore di sistema",
                    "tenant-admin": "Amministratore tenant",
                    "customer": "Cliente",
                    "anonymous": "Anonimo",
                    "add": "Aggiungi Utente",
                    "delete": "Elimina utente",
                    "add-user-text": "Aggiungi nuovo utente",
                    "no-users-text": "Nessun utente trovato",
                    "user-details": "Dettagli utente",
                    "delete-user-title": "Sei sicuro di voler eliminare l'utente '{{userEmail}}'?",
                    "delete-user-text": "Be careful, after the confirmation the user and all related data will become unrecoverable.",
                    "delete-users-title": "Sei sicuro di voler cancellare { count, select, 1 {1 utente} other {# utenti} }?",
                    "delete-users-action-title": "Elimina { count, select, 1 {1 utente} other {# utenti} }",
                    "delete-users-text": "Attenzione, dopo la conferma tutti gli utenti selezionati saranno eliminati e tutti i relativi dati non saranno più recuperabili.",
                    "activation-email-sent-message": "Email di attivazione inviata con successo!",
                    "resend-activation": "Resend activation",
                    "email": "Email",
                    "email-required": "Email obbligatoria.",
                    "invalid-email-format": "Formato email non valido.",
                    "first-name": "Nome",
                    "last-name": "Cognome",
                    "description": "Descrizione",
                    "default-dashboard": "Dashboard di default",
                    "always-fullscreen": "Always fullscreen",
                    "select-user": "Seleziona utente",
                    "no-users-matching": "Nessun utente corrispondente a '{{entity}}' è stato trovato.",
                    "user-required": "Utente obbligatorio",
                    "activation-method": "Metodo di attivazione",
                    "display-activation-link": "Mostra link di attivazione",
                    "send-activation-mail": "Invia email di attivazione",
                    "activation-link": "Link attivazione utente",
                    "activation-link-text": "Per attivare l'utente utilizza il seguente <a href='{{activationLink}}' target='_blank'>link di attivazione</a> :",
                    "copy-activation-link": "Copia link di attivazione",
                    "activation-link-copied-message": "Link di attivazione utente copiato negli appunti",
                    "details": "Dettagli"
                },
                "value": {
                    "type": "Tipo valore",
                    "string": "String",
                    "string-value": "Valore string",
                    "integer": "Integer",
                    "integer-value": "Valore integer",
                    "invalid-integer-value": "Valore integer non valido",
                    "double": "Double",
                    "double-value": "Valore double",
                    "boolean": "Boolean",
                    "boolean-value": "Valore boolean",
                    "false": "Falso",
                    "true": "Vero",
                    "long": "Long"
                },
                "widget": {
                    "widget-library": "Libreria Widget",
                    "widget-bundle": "Widgets Bundle",
                    "select-widgets-bundle": "Select widgets bundle",
                    "management": "Gestione widget",
                    "editor": "Editor Widget",
                    "widget-type-not-found": "Problem loading widget configuration.<br>Probably associated\n    widget type was removed.",
                    "widget-type-load-error": "Widget wasn't loaded due to the following errors:",
                    "remove": "Elimina widget",
                    "edit": "Modifica widget",
                    "remove-widget-title": "sei sicuro di voler eliminare il widget '{{widgetTitle}}'?",
                    "remove-widget-text": "Dopo la conferma il widget e tutti i suoi dati non saranno più recuperabili.",
                    "timeseries": "Time series",
                    "search-data": "Cerca dati",
                    "no-data-found": "Nessun dato trovato",
                    "latest-values": "Ultimi valori",
                    "rpc": "Control widget",
                    "alarm": "Alarm widget",
                    "static": "Static widget",
                    "select-widget-type": "Seleziona tipo widget",
                    "missing-widget-title-error": "Il tiolo del widget deve essere specificato!",
                    "widget-saved": "Widget salvato",
                    "unable-to-save-widget-error": "Impossibile salvare il widget! Sono presenti degli errori!",
                    "save": "Salva widget",
                    "saveAs": "Salva widget come",
                    "save-widget-type-as": "Salva tipo widget come",
                    "save-widget-type-as-text": "Please enter new widget title and/or select target widgets bundle",
                    "toggle-fullscreen": "Toggle fullscreen",
                    "run": "Esegui widget",
                    "title": "Titolo widget",
                    "title-required": "Titolo widget obbligatorio.",
                    "type": "Tipo widget",
                    "resources": "Risorse",
                    "resource-url": "JavaScript/CSS URL",
                    "remove-resource": "Rimuovi risorsa",
                    "add-resource": "Aggiungi risorsa",
                    "html": "HTML",
                    "tidy": "Tidy",
                    "css": "CSS",
                    "settings-schema": "Impostazioni schema",
                    "datakey-settings-schema": "Data key settings schema",
                    "javascript": "Javascript",
                    "remove-widget-type-title": "Are you sure you want to remove the widget type '{{widgetName}}'?",
                    "remove-widget-type-text": "After the confirmation the widget type and all related data will become unrecoverable.",
                    "remove-widget-type": "Rimuovi tipo widget",
                    "add-widget-type": "Aggiungi nuovo tipo widget",
                    "widget-type-load-failed-error": "Failed to load widget type!",
                    "widget-template-load-failed-error": "Failed to load widget template!",
                    "add": "Aggiungi Widget",
                    "undo": "Annulla modifiche widget",
                    "export": "Esporta widget"
                },
                "widget-action": {
                    "header-button": "Widget header button",
                    "open-dashboard-state": "Navigate to new dashboard state",
                    "update-dashboard-state": "Update current dashboard state",
                    "open-dashboard": "Navigate to other dashboard",
                    "custom": "Custom action",
                    "target-dashboard-state": "Target dashboard state",
                    "target-dashboard-state-required": "Target dashboard state is required",
                    "set-entity-from-widget": "Set entity from widget",
                    "target-dashboard": "Target dashboard",
                    "open-right-layout": "Open right dashboard layout (mobile view)"
                },
                "widgets-bundle": {
                    "current": "Current bundle",
                    "widgets-bundles": "Widgets Bundles",
                    "add": "Add Widgets Bundle",
                    "delete": "Delete widgets bundle",
                    "title": "Titolo",
                    "title-required": "Titolo obbligatorio.",
                    "add-widgets-bundle-text": "Add new widgets bundle",
                    "no-widgets-bundles-text": "No widgets bundles found",
                    "empty": "Widgets bundle is empty",
                    "details": "Details",
                    "widgets-bundle-details": "Widgets bundle details",
                    "delete-widgets-bundle-title": "Are you sure you want to delete the widgets bundle '{{widgetsBundleTitle}}'?",
                    "delete-widgets-bundle-text": "Be careful, after the confirmation the widgets bundle and all related data will become unrecoverable.",
                    "delete-widgets-bundles-title": "Are you sure you want to delete { count, select, 1 {1 widgets bundle} other {# widgets bundles} }?",
                    "delete-widgets-bundles-action-title": "Delete { count, select, 1 {1 widgets bundle} other {# widgets bundles} }",
                    "delete-widgets-bundles-text": "Be careful, after the confirmation all selected widgets bundles will be removed and all related data will become unrecoverable.",
                    "no-widgets-bundles-matching": "No widgets bundles matching '{{widgetsBundle}}' were found.",
                    "widgets-bundle-required": "Widgets bundle is required.",
                    "system": "Sistema",
                    "import": "Import widgets bundle",
                    "export": "Export widgets bundle",
                    "export-failed-error": "Unable to export widgets bundle: {{error}}",
                    "create-new-widgets-bundle": "Create new widgets bundle",
                    "widgets-bundle-file": "Widgets bundle file",
                    "invalid-widgets-bundle-file-error": "Unable to import widgets bundle: Invalid widgets bundle data structure."
                },
                "widget-config": {
                    "data": "Dati",
                    "settings": "Impostazioni",
                    "advanced": "Avanzate",
                    "title": "Titolo",
                    "general-settings": "Impostazioni generali",
                    "display-title": "Mostra titolo",
                    "drop-shadow": "Drop shadow",
                    "enable-fullscreen": "Abilita fullscreen",
                    "background-color": "Colore sfondo",
                    "text-color": "Colore testo",
                    "padding": "Padding",
                    "margin": "Margin",
                    "widget-style": "Stile Widget",
                    "title-style": "Stile titolo",
                    "mobile-mode-settings": "Impostazioni modalità mobile",
                    "order": "Ordinamento",
                    "height": "Altezza",
                    "units": "Simbolo speciale da mostrare vicino al valore",
                    "decimals": "Numero di cifre decimali",
                    "timewindow": "Timewindow",
                    "use-dashboard-timewindow": "Use dashboard timewindow",
                    "display-legend": "Mostra legenda",
                    "datasources": "Sorgenti dei dati",
                    "maximum-datasources": "Massimo { count, select, 1 {1 sorgente dati consentita.} other {# sorgenti dati consentite} }",
                    "datasource-type": "Tipo",
                    "datasource-parameters": "Parametri",
                    "remove-datasource": "Rimuovi sorgente dati",
                    "add-datasource": "Aggiungi sorgente dati",
                    "target-device": "Dispositivo Target",
                    "alarm-source": "Sorgente Allarme",
                    "actions": "Azioni",
                    "action": "Azione",
                    "add-action": "Aggiungi azione",
                    "search-actions": "Ricerca azioni",
                    "action-source": "Sorgente azione",
                    "action-source-required": "Sorgente azione obbligatoria.",
                    "action-name": "Nome",
                    "action-name-required": "Nome azione obbligatorio.",
                    "action-name-not-unique": "Un'altra azione con lo stesso nome è già presente.<br/>Il nome di una azione dovrebbe essere univoco all'interno della stessa sorgente.",
                    "action-icon": "Icona",
                    "action-type": "Tipo",
                    "action-type-required": "Tipo azione obbligatorio.",
                    "edit-action": "Modifica azione",
                    "delete-action": "Cancella azione",
                    "delete-action-title": "Cancella azione del widget",
                    "delete-action-text": "Sei sicuro di voler cancellare l'azione del widget '{{actionName}}'?"
                },
                "widget-type": {
                    "import": "Importa un tipo di widget",
                    "export": "Esporta un tipo di widget",
                    "export-failed-error": "Impossibile esportare il tipo di widget: {{error}}",
                    "create-new-widget-type": "Crea un nuovo tipo di widget",
                    "widget-type-file": "Widget type file", 
                    "invalid-widget-type-file-error": "Impossibile importare un tipo di widget: struttura dati del widget non valida."
                },
                "icon": {
                    "icon": "Icona",
                    "select-icon": "Seleziona icona",
                    "material-icons": "Icone Material",
                    "show-all": "Mostra tutte le icone"
                },
                "custom": {
                    "widget-action": { 
                        "action-cell-button": "Action cell button",
                        "row-click": "On row click",
                        "marker-click": "On marker click",
                        "tooltip-tag-action": "Tooltip tag action"
                    }
                },
                "language": {
                    "language": "Lingua",
                    "zh_CN": "Cinese",
                    "ko_KR": "Coreano",
                    "en_US": "Inglese",
                    "it_IT": "Italiano",
                    "ru_RU": "Russo",
                    "es_ES": "Spagnolo"
                }
    };
    angular.extend(locales, { 'it_IT': it_IT });
}

