/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.SerialBehaviour;
import jade.util.leap.ArrayList;
import jade.util.leap.Collection;
import jade.util.leap.List;

public class SequentialBehaviour
extends SerialBehaviour {
    private List subBehaviours = new ArrayList();
    int current = 0;

    public SequentialBehaviour() {
    }

    public SequentialBehaviour(Agent a) {
        super(a);
    }

    protected void scheduleFirst() {
        this.current = 0;
    }

    protected void scheduleNext(boolean currentDone, int currentResult) {
        if (currentDone) {
            ++this.current;
        }
    }

    protected boolean checkTermination(boolean currentDone, int currentResult) {
        return currentDone && this.current >= this.subBehaviours.size() - 1;
    }

    protected Behaviour getCurrent() {
        Behaviour b = null;
        if (this.subBehaviours.size() > this.current) {
            b = (Behaviour)this.subBehaviours.get(this.current);
        }
        return b;
    }

    public Collection getChildren() {
        return this.subBehaviours;
    }

    public void addSubBehaviour(Behaviour b) {
        this.subBehaviours.add(b);
        b.setParent(this);
        b.setAgent(this.myAgent);
    }

    public void removeSubBehaviour(Behaviour b) {
        boolean rc = this.subBehaviours.remove(b);
        if (rc) {
            b.setParent(null);
        }
    }

    public void reset() {
        super.reset();
        this.current = 0;
    }

    public void skipNext() {
        this.current = this.subBehaviours.size();
    }

    private Behaviour[] getSubBehaviours() {
        Object[] objs = this.subBehaviours.toArray();
        Behaviour[] result = new Behaviour[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            result[i] = (Behaviour)objs[i];
        }
        return result;
    }

    private void setSubBehaviours(Behaviour[] behaviours) {
        this.subBehaviours.clear();
        for (int i = 0; i < behaviours.length; ++i) {
            this.subBehaviours.add(behaviours[i]);
        }
    }

    private int getCurrentIndex() {
        return this.current;
    }

    private void setCurrentIndex(int idx) {
        this.current = idx;
    }
}

