/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.Predicate;
import jade.content.onto.BasicOntology;
import jade.content.onto.BeanIntrospector;
import jade.content.onto.BeanOntologyException;
import jade.content.onto.ClassDiscover;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.SlotAccessData;
import jade.content.onto.SlotKey;
import jade.content.onto.annotations.AggregateResult;
import jade.content.onto.annotations.AggregateSlot;
import jade.content.onto.annotations.Element;
import jade.content.onto.annotations.Result;
import jade.content.onto.annotations.Slot;
import jade.content.onto.annotations.SuppressSlot;
import jade.content.schema.AgentActionSchema;
import jade.content.schema.ConceptSchema;
import jade.content.schema.ObjectSchema;
import jade.content.schema.ObjectSchemaImpl;
import jade.content.schema.PredicateSchema;
import jade.content.schema.TermSchema;
import jade.content.schema.facets.DefaultValueFacet;
import jade.content.schema.facets.DocumentationFacet;
import jade.content.schema.facets.JavaTypeFacet;
import jade.content.schema.facets.PermittedValuesFacet;
import jade.content.schema.facets.RegexFacet;
import jade.util.Logger;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BeanOntologyBuilder {
    private static final Logger logger = Logger.getMyLogger(BeanOntologyBuilder.class.getName());
    public static final String ENUM_SLOT_NAME = "name";
    private static final String GETTER_PREFIX = "get";
    private static final String BOOLEAN_GETTER_PREFIX = "is";
    private static final String SETTER_PREFIX = "set";
    private static final Object GET_CLASS_METHOD = "getClass";
    private Ontology ontology;
    private BeanIntrospector introspector;

    BeanOntologyBuilder(Ontology ontology) {
        this.ontology = ontology;
        Introspector ontoIntrospector = ontology.getIntrospector();
        this.introspector = (BeanIntrospector)ontoIntrospector;
    }

    private static boolean isGetter(Method method) {
        String methodName = method.getName();
        if (methodName.length() < 3) {
            return false;
        }
        if (!methodName.startsWith(GETTER_PREFIX) && !methodName.startsWith(BOOLEAN_GETTER_PREFIX)) {
            return false;
        }
        char c = methodName.startsWith(BOOLEAN_GETTER_PREFIX) ? methodName.charAt(2) : methodName.charAt(3);
        if (!Character.isUpperCase(c) && '_' != c) {
            return false;
        }
        if (Void.TYPE.equals(method.getReturnType())) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        return !methodName.equals(GET_CLASS_METHOD);
    }

    private static boolean isSetter(Method method) {
        String methodName = method.getName();
        if (methodName.length() < 4) {
            return false;
        }
        if (!methodName.startsWith(SETTER_PREFIX)) {
            return false;
        }
        if (!Character.isUpperCase(methodName.charAt(3)) && '_' != methodName.charAt(3)) {
            return false;
        }
        if (!Void.TYPE.equals(method.getReturnType())) {
            return false;
        }
        return method.getParameterTypes().length == 1;
    }

    private static String buildPropertyNameFromGetter(Method getter) {
        String getterName = getter.getName();
        StringBuilder sb = new StringBuilder();
        int pos = 3;
        if (getterName.startsWith(BOOLEAN_GETTER_PREFIX)) {
            pos = 2;
        }
        sb.append(Character.toLowerCase(getterName.charAt(pos)));
        sb.append(getterName.substring(pos + 1));
        return sb.toString();
    }

    private static String buildSetterNameFromBeanPropertyName(String beanPropertyName) {
        StringBuilder sb = new StringBuilder(SETTER_PREFIX);
        sb.append(Character.toUpperCase(beanPropertyName.charAt(0)));
        sb.append(beanPropertyName.substring(1));
        return sb.toString();
    }

    private static boolean accessorsAreConsistent(Method getter, Method setter) {
        return getter.getReturnType().equals(setter.getParameterTypes()[0]);
    }

    private static String getSchemaNameFromClass(Class clazz) {
        String result = clazz.getSimpleName();
        Element annotationElement = clazz.getAnnotation(Element.class);
        if (annotationElement != null && !"__USE_CLASS_SIMPLE_NAME__".equals(annotationElement.name())) {
            result = annotationElement.name();
        }
        return result;
    }

    private static Map<SlotKey, SlotAccessData> buildAccessorsMap(String schemaName, Class clazz, Method[] methodsArray) throws BeanOntologyException {
        int position;
        AbstractMap result = new TreeMap<SlotKey, SlotAccessData>();
        ArrayList<Method> getters = new ArrayList<Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method method : methodsArray) {
            if (method.getAnnotation(SuppressSlot.class) != null) continue;
            if (BeanOntologyBuilder.isGetter(method)) {
                getters.add(method);
                continue;
            }
            if (!BeanOntologyBuilder.isSetter(method)) continue;
            setters.put(method.getName(), method);
        }
        Iterator gettersIter = getters.iterator();
        boolean orderByPosition = false;
        while (gettersIter.hasNext()) {
            Method getter = (Method)gettersIter.next();
            Class<?> slotClazz = getter.getReturnType();
            boolean mandatory = false;
            boolean manageAsSerializable = false;
            int cardMin = 0;
            int cardMax = -1;
            String defaultValue = null;
            String regex = null;
            String[] permittedValues = null;
            String documentation = null;
            Class aggregateType = null;
            position = -1;
            Slot slotAnnotation = getter.getAnnotation(Slot.class);
            AggregateSlot aggregateSlotAnnotation = getter.getAnnotation(AggregateSlot.class);
            String propertyName = BeanOntologyBuilder.buildPropertyNameFromGetter(getter);
            String setterName = BeanOntologyBuilder.buildSetterNameFromBeanPropertyName(propertyName);
            Method setter = (Method)setters.get(setterName);
            if (setter == null || !BeanOntologyBuilder.accessorsAreConsistent(getter, setter)) continue;
            String slotName = propertyName;
            if (slotAnnotation != null) {
                if (!"__USE_METHOD_NAME__".equals(slotAnnotation.name())) {
                    slotName = slotAnnotation.name();
                }
                if (slotAnnotation.position() != -1) {
                    position = slotAnnotation.position();
                    orderByPosition = true;
                }
                if (!"__NULL__".equals(slotAnnotation.defaultValue())) {
                    defaultValue = slotAnnotation.defaultValue();
                }
                if (!"__NULL__".equals(slotAnnotation.regex())) {
                    regex = slotAnnotation.regex();
                }
                if (slotAnnotation.permittedValues().length > 0) {
                    permittedValues = slotAnnotation.permittedValues();
                }
                if (!"__NULL__".equals(slotAnnotation.documentation())) {
                    documentation = slotAnnotation.documentation();
                }
                manageAsSerializable = slotAnnotation.manageAsSerializable();
                mandatory = slotAnnotation.mandatory();
            }
            if (SlotAccessData.isAggregate(slotClazz)) {
                ParameterizedType slotParameterizedType;
                Type[] actuals;
                Type slotType;
                if (slotClazz.isArray()) {
                    aggregateType = slotClazz.getComponentType();
                }
                if ((slotType = getter.getGenericReturnType()) instanceof ParameterizedType && (actuals = (slotParameterizedType = (ParameterizedType)slotType).getActualTypeArguments()).length > 0) {
                    aggregateType = (Class)actuals[0];
                }
                if (aggregateSlotAnnotation != null) {
                    cardMin = aggregateSlotAnnotation.cardMin();
                    if (slotAnnotation == null && cardMin > 0) {
                        mandatory = true;
                    }
                    cardMax = aggregateSlotAnnotation.cardMax();
                    if (!Object.class.equals((Object)aggregateSlotAnnotation.type())) {
                        aggregateType = aggregateSlotAnnotation.type();
                    }
                }
            }
            SlotAccessData sad = new SlotAccessData(slotClazz, getter, setter, mandatory, aggregateType, cardMin, cardMax, defaultValue, regex, permittedValues, documentation, manageAsSerializable);
            result.put(new SlotKey(schemaName, slotName, position), sad);
        }
        if (orderByPosition) {
            SlotKey[] positionedSK = new SlotKey[result.size()];
            ArrayList<SlotKey> nonPositionedSAD = new ArrayList<SlotKey>();
            for (SlotKey key : result.keySet()) {
                position = key.position;
                if (position != -1) {
                    if (position < 0 || position >= result.size()) {
                        throw new BeanOntologyException("not valid position #" + position + " in slot " + key.slotName);
                    }
                    if (positionedSK[position] != null) {
                        throw new BeanOntologyException("duplicated position #" + position + " in slot " + key.slotName);
                    }
                    positionedSK[position] = key;
                    continue;
                }
                nonPositionedSAD.add(key);
            }
            int nonPositionedSADIndex = 0;
            LinkedHashMap orderedMap = new LinkedHashMap();
            for (int i = 0; i < result.size(); ++i) {
                SlotKey key;
                if (positionedSK[i] != null) {
                    key = positionedSK[i];
                } else {
                    key = (SlotKey)nonPositionedSAD.get(nonPositionedSADIndex);
                    ++nonPositionedSADIndex;
                }
                orderedMap.put(key, result.get(key));
            }
            result = orderedMap;
        }
        return result;
    }

    private static String getAggregateSchemaName(Class clazz) {
        String result = null;
        if (SlotAccessData.isSequence(clazz)) {
            result = "sequence";
        } else if (SlotAccessData.isSet(clazz)) {
            result = SETTER_PREFIX;
        }
        return result;
    }

    private ObjectSchema getSchema(Class clazz) throws OntologyException {
        ObjectSchema os = Calendar.class.isAssignableFrom(clazz) ? this.ontology.getSchema(Date.class) : (clazz == Object.class ? TermSchema.getBaseSchema() : this.ontology.getSchema(clazz));
        return os;
    }

    private ObjectSchema doAddSchema(Class clazz, boolean buildHierarchy, boolean manageAsSerializable) throws BeanOntologyException {
        if (manageAsSerializable) {
            ObjectSchema serializableSchema = null;
            try {
                serializableSchema = this.ontology.getSchema("serializable");
            }
            catch (OntologyException oe) {
                throw new BeanOntologyException("Error getting SerializableOntology schema", oe);
            }
            if (serializableSchema != null) {
                return serializableSchema;
            }
        }
        return this.doAddSchema(clazz, buildHierarchy);
    }

    private ObjectSchema doAddSchema(Class clazz, boolean buildHierarchy) throws BeanOntologyException {
        try {
            if (buildHierarchy) {
                return this.doAddHierarchicalSchema(clazz);
            }
            return this.doAddFlatSchema(clazz);
        }
        catch (BeanOntologyException boe) {
            throw boe;
        }
        catch (Exception oe) {
            throw new BeanOntologyException("Error addind schema for class " + clazz, oe);
        }
    }

    private ObjectSchema doAddHierarchicalSchema(Class clazz) throws OntologyException {
        ObjectSchema schema = this.getSchema(clazz);
        if (schema != null) {
            return schema;
        }
        schema = this.createEmptySchema(clazz);
        this.ontology.add(schema, clazz);
        if (clazz.isEnum()) {
            this.manageEnum(clazz, schema);
        } else {
            this.manageSuperClass(clazz, schema);
            this.manageInterfaces(clazz, schema);
            this.manageSlots(clazz, schema, true);
            if (schema instanceof AgentActionSchema) {
                this.manageActionResult(clazz, schema, true);
            }
        }
        return schema;
    }

    private ObjectSchema doAddFlatSchema(Class clazz) throws OntologyException {
        ObjectSchema schema = this.getSchema(clazz);
        if (schema != null) {
            return schema;
        }
        schema = this.createEmptySchema(clazz);
        this.ontology.add(schema, clazz);
        if (clazz.isEnum()) {
            this.manageEnum(clazz, schema);
        } else {
            this.manageSlots(clazz, schema, false);
            if (schema instanceof AgentActionSchema) {
                this.manageActionResult(clazz, schema, false);
            }
        }
        return schema;
    }

    private void manageSuperClass(Class clazz, ObjectSchema schema) throws OntologyException {
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null && !Object.class.equals(superClazz) && !this.isPrivate(superClazz)) {
            ObjectSchema superSchema = this.doAddHierarchicalSchema(superClazz);
            if (schema instanceof ConceptSchema) {
                ((ConceptSchema)schema).addSuperSchema((ConceptSchema)superSchema);
            } else {
                ((PredicateSchema)schema).addSuperSchema((PredicateSchema)superSchema);
            }
        }
    }

    private void manageInterfaces(Class clazz, ObjectSchema schema) throws OntologyException {
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces != null) {
            for (Class<?> interfaceClass : interfaces) {
                ObjectSchema superSchema;
                if (this.isPrivate(interfaceClass)) continue;
                if (schema instanceof ConceptSchema && Concept.class.isAssignableFrom(interfaceClass) && interfaceClass != Concept.class && interfaceClass != AgentAction.class) {
                    superSchema = this.doAddHierarchicalSchema(interfaceClass);
                    ((ConceptSchema)schema).addSuperSchema((ConceptSchema)superSchema);
                    continue;
                }
                if (!(schema instanceof PredicateSchema) || !Predicate.class.isAssignableFrom(interfaceClass) || interfaceClass == Predicate.class) continue;
                superSchema = this.doAddHierarchicalSchema(interfaceClass);
                ((PredicateSchema)schema).addSuperSchema((PredicateSchema)superSchema);
            }
        }
    }

    private void manageEnum(Class clazz, ObjectSchema schema) throws OntologyException {
        ConceptSchema cs = (ConceptSchema)schema;
        cs.add(ENUM_SLOT_NAME, (TermSchema)this.ontology.getSchema(String.class));
        Enum[] enumValues = (Enum[])clazz.getEnumConstants();
        Object[] enumStrValues = new String[enumValues.length];
        for (int i = 0; i < enumValues.length; ++i) {
            enumStrValues[i] = enumValues[i].toString();
        }
        cs.addFacet(ENUM_SLOT_NAME, new PermittedValuesFacet(enumStrValues));
    }

    private void manageActionResult(Class clazz, ObjectSchema schema, boolean buildHierarchy) throws OntologyException {
        Annotation annotation = clazz.getAnnotation(Result.class);
        if (annotation != null) {
            Result r = annotation;
            TermSchema ts = (TermSchema)this.doAddSchema(r.type(), buildHierarchy);
            ((AgentActionSchema)schema).setResult(ts);
        } else {
            annotation = clazz.getAnnotation(AggregateResult.class);
            if (annotation != null) {
                AggregateResult ar = (AggregateResult)annotation;
                TermSchema ts = (TermSchema)this.doAddSchema(ar.type(), buildHierarchy);
                ((AgentActionSchema)schema).setResult(ts, ar.cardMin(), ar.cardMax());
            }
        }
    }

    private void manageSlots(Class clazz, ObjectSchema schema, boolean buildHierarchy) throws OntologyException {
        Method[] methods = clazz.getMethods();
        ArrayList<Method> concreteMethodsList = new ArrayList<Method>();
        for (Method m : methods) {
            int modifiers = m.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers)) continue;
            concreteMethodsList.add(m);
        }
        Map<SlotKey, SlotAccessData> slotAccessorsMap = BeanOntologyBuilder.buildAccessorsMap(schema.getTypeName(), clazz, concreteMethodsList.toArray(new Method[0]));
        this.introspector.addAccessors(slotAccessorsMap);
        for (Map.Entry<SlotKey, SlotAccessData> entry : slotAccessorsMap.entrySet()) {
            String slotName = entry.getKey().slotName;
            if (schema.containsSlot(slotName)) continue;
            if (schema instanceof ConceptSchema) {
                this.addSlot((ConceptSchema)schema, slotName, entry.getValue(), buildHierarchy);
                continue;
            }
            this.addSlot((PredicateSchema)schema, slotName, entry.getValue(), buildHierarchy);
        }
    }

    private void addSlot(ConceptSchema schema, String slotName, SlotAccessData sad, boolean buildHierarchy) throws OntologyException {
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "concept " + schema.getTypeName() + ": adding slot " + slotName);
        }
        if (!sad.aggregate) {
            TermSchema ts = (TermSchema)this.doAddSchema(sad.type, buildHierarchy, sad.manageAsSerializable);
            schema.add(slotName, ts, sad.mandatory ? 0 : 1);
            if (sad.defaultValue != null) {
                schema.addFacet(slotName, new DefaultValueFacet(sad.defaultValue));
            }
            if (sad.regex != null) {
                schema.addFacet(slotName, new RegexFacet(sad.regex));
            }
            if (sad.documentation != null) {
                schema.addFacet(slotName, new DocumentationFacet(sad.documentation));
            }
            if (sad.permittedValues != null) {
                Object[] typizedPermittedValues = new Object[sad.permittedValues.length];
                if (sad.type != null) {
                    for (int i = 0; i < sad.permittedValues.length; ++i) {
                        typizedPermittedValues[i] = BasicOntology.adjustPrimitiveValue(sad.permittedValues[i], sad.type);
                    }
                }
                schema.addFacet(slotName, new PermittedValuesFacet(typizedPermittedValues));
            }
            if ("true".equalsIgnoreCase(System.getProperty("SL-preserve-java-types")) && (sad.type == Long.class || sad.type == Long.TYPE || sad.type == Double.class || sad.type == Double.TYPE)) {
                schema.addFacet(slotName, new JavaTypeFacet(sad.type.getName()));
            }
        } else {
            TermSchema ats = null;
            if (sad.aggregateClass != null) {
                ats = (TermSchema)this.doAddSchema(sad.aggregateClass, buildHierarchy, sad.manageAsSerializable);
            }
            schema.add(slotName, ats, sad.cardMin, sad.cardMax, BeanOntologyBuilder.getAggregateSchemaName(sad.type), sad.mandatory ? 0 : 1);
        }
    }

    private void addSlot(PredicateSchema schema, String slotName, SlotAccessData sad, boolean buildHierarchy) throws OntologyException {
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "concept " + schema.getTypeName() + ": adding slot " + slotName);
        }
        if (!sad.aggregate) {
            ObjectSchema os = this.doAddSchema(sad.type, buildHierarchy, sad.manageAsSerializable);
            schema.add(slotName, os, sad.mandatory ? 0 : 1);
            if (sad.defaultValue != null) {
                schema.addFacet(slotName, new DefaultValueFacet(sad.defaultValue));
            }
            if (sad.regex != null) {
                schema.addFacet(slotName, new RegexFacet(sad.regex));
            }
            if (sad.documentation != null) {
                schema.addFacet(slotName, new DocumentationFacet(sad.documentation));
            }
            if (sad.permittedValues != null) {
                Object[] typizedPermittedValues = new Object[sad.permittedValues.length];
                if (sad.type != null) {
                    for (int i = 0; i < sad.permittedValues.length; ++i) {
                        typizedPermittedValues[i] = BasicOntology.adjustPrimitiveValue(sad.permittedValues[i], sad.type);
                    }
                }
                schema.addFacet(slotName, new PermittedValuesFacet(typizedPermittedValues));
            }
        } else {
            TermSchema ats = null;
            if (sad.aggregateClass != null) {
                ats = (TermSchema)this.doAddSchema(sad.aggregateClass, buildHierarchy, sad.manageAsSerializable);
            }
            schema.add(slotName, ats, sad.cardMin, sad.cardMax, BeanOntologyBuilder.getAggregateSchemaName(sad.type), sad.mandatory ? 0 : 1);
        }
    }

    private boolean isPrivate(Class clazz) {
        int scms = clazz.getModifiers();
        return Modifier.isPrivate(scms);
    }

    private ObjectSchema createEmptySchema(Class clazz) {
        String schemaName = BeanOntologyBuilder.getSchemaNameFromClass(clazz);
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "building concept " + schemaName);
        }
        ObjectSchemaImpl schema = AgentAction.class.isAssignableFrom(clazz) ? new AgentActionSchema(schemaName) : (Predicate.class.isAssignableFrom(clazz) ? new PredicateSchema(schemaName) : new ConceptSchema(schemaName));
        return schema;
    }

    void addSchema(Class clazz, boolean buildHierarchy) throws BeanOntologyException {
        this.doAddSchema(clazz, buildHierarchy);
    }

    void addSchemas(String pkgname, boolean buildHierarchy) throws BeanOntologyException {
        try {
            List<Class> classesForPackage = ClassDiscover.getClassesForPackage(pkgname);
            if (classesForPackage.size() < 1) {
                throw new BeanOntologyException("no suitable classes found");
            }
            for (Class clazz : classesForPackage) {
                if (!Concept.class.isAssignableFrom(clazz) && !Predicate.class.isAssignableFrom(clazz)) continue;
                this.doAddSchema(clazz, buildHierarchy);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new BeanOntologyException("Class not found", cnfe);
        }
    }
}

