/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AID;
import jade.core.AgentDescriptor;
import jade.util.leap.HashMap;
import jade.util.leap.Map;

class GADT {
    private Map agents = new HashMap();

    GADT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentDescriptor put(AID aid, AgentDescriptor a) {
        Row r;
        Map map = this.agents;
        synchronized (map) {
            r = (Row)this.agents.get(aid);
        }
        if (r == null) {
            this.agents.put(aid, new Row(a));
            return null;
        }
        r.lock();
        this.agents.put(aid, new Row(a));
        AgentDescriptor old = r.get();
        r.unlock();
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentDescriptor remove(AID key) {
        Row r;
        Map map = this.agents;
        synchronized (map) {
            r = (Row)this.agents.get(key);
        }
        if (r == null) {
            return null;
        }
        r.lock();
        this.agents.remove(key);
        AgentDescriptor a = r.get();
        r.clear();
        r.unlock();
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentDescriptor acquire(AID key) {
        Row r;
        Map map = this.agents;
        synchronized (map) {
            r = (Row)this.agents.get(key);
        }
        if (r == null) {
            return null;
        }
        r.lock();
        return r.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(AID key) {
        Row r;
        Map map = this.agents;
        synchronized (map) {
            r = (Row)this.agents.get(key);
        }
        if (r != null) {
            r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AID[] keys() {
        Map map = this.agents;
        synchronized (map) {
            Object[] objs = this.agents.keySet().toArray();
            AID[] result = new AID[objs.length];
            System.arraycopy(objs, 0, result, 0, result.length);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentDescriptor[] values() {
        Map map = this.agents;
        synchronized (map) {
            Object[] objs = this.agents.values().toArray();
            AgentDescriptor[] result = new AgentDescriptor[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                Row r = (Row)objs[i];
                result[i] = r.get();
            }
            return result;
        }
    }

    private static class Row {
        private AgentDescriptor value;
        private Thread owner;
        private long depth;

        public Row(AgentDescriptor a) {
            this.value = a;
            this.depth = 0L;
        }

        public synchronized AgentDescriptor get() {
            return this.value;
        }

        public synchronized void clear() {
            this.value = null;
        }

        public synchronized void lock() {
            try {
                Thread me = Thread.currentThread();
                while (this.owner != null && this.owner != me) {
                    this.wait();
                }
                this.owner = me;
                ++this.depth;
            }
            catch (InterruptedException ie) {
                return;
            }
        }

        public synchronized void unlock() {
            if (this.owner != Thread.currentThread()) {
                return;
            }
            --this.depth;
            if (this.depth == 0L || this.value == null) {
                this.owner = null;
                this.notifyAll();
            }
        }
    }
}

