/*
 * Decompiled with CFR 0.152.
 */
package jade.core.mobility;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentDescriptor;
import jade.core.BaseService;
import jade.core.CaseInsensitiveString;
import jade.core.Command;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.LifeCycle;
import jade.core.Location;
import jade.core.MainContainer;
import jade.core.NameClashException;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.ServiceHelper;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.management.AgentManagementService;
import jade.core.management.CodeLocator;
import jade.core.mobility.AgentMobilityHelper;
import jade.core.mobility.AgentMobilitySlice;
import jade.core.mobility.MobileAgentClassLoader;
import jade.core.mobility.Movable;
import jade.core.replication.MainReplicationHandle;
import jade.lang.acl.ACLMessage;
import jade.security.Credentials;
import jade.security.CredentialsHelper;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AgentMobilityService
extends BaseService {
    public static final String NAME = "jade.core.mobility.AgentMobility";
    public static final int AP_TRANSIT = 7;
    public static final int AP_COPY = 8;
    public static final int AP_GONE = 9;
    private static final String[] OWNED_COMMANDS = new String[]{"Request-Move", "Request-Clone", "Inform-Moved", "Inform-Cloned"};
    private static final int SIZE_JAR_BUFFER = 4096;
    static final boolean MIGRATION = false;
    static final boolean CLONING = true;
    static final boolean CREATE_AND_START = true;
    static final boolean CREATE_ONLY = false;
    static final boolean TRANSFER_ABORT = false;
    static final boolean TRANSFER_COMMIT = true;
    private final CommandSourceSink senderSink = new CommandSourceSink();
    private final CommandTargetSink receiverSink = new CommandTargetSink();
    private final Filter _outFilter = new CommandOutgoingFilter();
    private MainReplicationHandle replicationHandle;
    private static final HashMap primitiveJavaClasses = new HashMap(8, 1.0f);
    private final Map loaders = new jade.util.leap.HashMap();
    private final Map sites = new jade.util.leap.HashMap();
    private AgentContainer myContainer;
    private final ServiceComponent localSlice = new ServiceComponent();

    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = ac;
    }

    public void boot(Profile myProfile) throws ServiceException {
        this.replicationHandle = new MainReplicationHandle(this, this.myContainer.getServiceFinder());
    }

    public String getName() {
        return NAME;
    }

    public Class getHorizontalInterface() {
        return AgentMobilitySlice.class;
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public ServiceHelper getHelper(Agent a) {
        return new AgentMobilityHelperImpl();
    }

    public Filter getCommandFilter(boolean direction) {
        if (direction) {
            return this._outFilter;
        }
        return null;
    }

    public Sink getCommandSink(boolean side) {
        if (!side) {
            return this.senderSink;
        }
        return this.receiverSink;
    }

    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    public String getClassSite(Agent a) {
        return (String)this.sites.get(a);
    }

    public void movedAgent(AID agentID, ContainerID src, ContainerID dest) throws NotFoundException {
        this.myContainer.getMain().movedAgent(agentID, src, dest);
    }

    public void bornAgent(AID agentID, ContainerID cid, JADEPrincipal principal, String ownership, boolean forceReplacement) throws NameClashException, NotFoundException {
        MainContainer impl = this.myContainer.getMain();
        try {
            impl.bornAgent(agentID, cid, principal, ownership, forceReplacement);
        }
        catch (NameClashException nce) {
            try {
                ContainerID oldCid = impl.getContainerID(agentID);
                Node n = impl.getContainerNode(oldCid).getNode();
                n.ping(false);
                throw nce;
            }
            catch (NameClashException nce2) {
                throw nce2;
            }
            catch (Exception e) {
                impl.bornAgent(agentID, cid, null, ownership, true);
            }
        }
    }

    protected Service.Slice getFreshSlice(String name) throws ServiceException {
        return super.getFreshSlice(name);
    }

    private void initCredentials(Command cmd, AID id) {
        Agent agent = this.myContainer.acquireLocalAgent(id);
        if (agent != null) {
            try {
                CredentialsHelper ch = (CredentialsHelper)((Object)agent.getHelper("jade.core.security.Security"));
                cmd.setPrincipal(ch.getPrincipal());
                cmd.setCredentials(ch.getCredentials());
            }
            catch (ServiceException se) {
                // empty catch block
            }
        }
        this.myContainer.releaseLocalAgent(id);
    }

    static {
        primitiveJavaClasses.put("boolean", Boolean.TYPE);
        primitiveJavaClasses.put("byte", Byte.TYPE);
        primitiveJavaClasses.put("char", Character.TYPE);
        primitiveJavaClasses.put("short", Short.TYPE);
        primitiveJavaClasses.put("int", Integer.TYPE);
        primitiveJavaClasses.put("long", Long.TYPE);
        primitiveJavaClasses.put("float", Float.TYPE);
        primitiveJavaClasses.put("double", Double.TYPE);
        primitiveJavaClasses.put("void", Void.TYPE);
    }

    private static class CopyLifeCycle
    extends LifeCycle {
        private Location myDestination;
        private String myNewName;
        private Movable myMovable;
        private transient AgentMobilityService myService;
        private Logger myLogger;
        private boolean firstTime = true;
        private boolean messageAware = false;

        private CopyLifeCycle(Location l, String newName, Movable m, AgentMobilityService s) {
            super(8);
            this.myDestination = l;
            this.myNewName = newName;
            this.myMovable = m;
            this.myService = s;
            this.myLogger = Logger.getMyLogger(this.myService.getName());
        }

        public void init() {
            this.myAgent.restoreBufferedState();
            if (this.myMovable != null) {
                this.myMovable.afterClone();
            }
        }

        public void execute() throws JADESecurityException, InterruptedException, InterruptedIOException {
            try {
                if (this.firstTime) {
                    this.firstTime = false;
                    if (this.myMovable != null) {
                        this.messageAware = true;
                        this.myMovable.beforeClone();
                        this.messageAware = false;
                    }
                    this.informCloned(this.myAgent.getAID(), this.myDestination, this.myNewName);
                }
            }
            catch (Exception e) {
                if (this.myAgent.getState() == this.myState) {
                    this.myDestination = null;
                    this.myNewName = null;
                    this.myAgent.restoreBufferedState();
                    if (e instanceof JADESecurityException) {
                        throw (JADESecurityException)e;
                    }
                    e.printStackTrace();
                    return;
                }
                throw new Agent.Interrupted();
            }
            this.myAgent.restoreBufferedState();
        }

        public boolean transitionTo(LifeCycle newLF) {
            int s = newLF.getState();
            return s == 2 || s == 6;
        }

        public boolean isMessageAware() {
            return this.messageAware;
        }

        public void end() {
            if (this.myLogger.isLoggable(Logger.SEVERE)) {
                this.myLogger.log(Logger.SEVERE, "***  Agent " + this.myAgent.getName() + " cloned in a forbidden situation ***");
            }
            this.myAgent.clean(true);
        }

        public void informCloned(AID agentID, Location where, String newName) throws ServiceException, JADESecurityException, IMTPException, NotFoundException, NameClashException {
            GenericCommand cmd = new GenericCommand("Inform-Cloned", AgentMobilityService.NAME, null);
            cmd.addParam(agentID);
            cmd.addParam(where);
            cmd.addParam(newName);
            this.myService.initCredentials(cmd, agentID);
            Object lastException = this.myService.submit(cmd);
            if (lastException != null) {
                if (lastException instanceof JADESecurityException) {
                    throw (JADESecurityException)lastException;
                }
                if (lastException instanceof NotFoundException) {
                    throw (NotFoundException)lastException;
                }
                if (lastException instanceof IMTPException) {
                    throw (IMTPException)lastException;
                }
                if (lastException instanceof NameClashException) {
                    throw (NameClashException)lastException;
                }
            }
        }
    }

    private static class TransitLifeCycle
    extends LifeCycle {
        private Location myDestination;
        private Movable myMovable;
        private transient AgentMobilityService myService;
        private Logger myLogger;
        private boolean firstTime = true;
        private boolean messageAware = false;

        private TransitLifeCycle(Location l, Movable m, AgentMobilityService s) {
            super(7);
            this.myDestination = l;
            this.myMovable = m;
            this.myService = s;
            this.myLogger = Logger.getMyLogger(this.myService.getName());
        }

        public void init() {
            this.myAgent.restoreBufferedState();
            if (this.myMovable != null) {
                this.myMovable.afterMove();
            }
        }

        public void execute() throws JADESecurityException, InterruptedException, InterruptedIOException {
            try {
                if (this.firstTime) {
                    this.firstTime = false;
                    if (this.myMovable != null) {
                        this.messageAware = true;
                        this.myMovable.beforeMove();
                        this.messageAware = false;
                    }
                    this.informMoved(this.myAgent.getAID(), this.myDestination);
                }
            }
            catch (Exception e) {
                if (this.myAgent.getState() == this.myState) {
                    this.myAgent.restoreBufferedState();
                    this.myDestination = null;
                    if (e instanceof JADESecurityException) {
                        throw (JADESecurityException)e;
                    }
                    e.printStackTrace();
                }
                throw new Agent.Interrupted();
            }
        }

        public void end() {
            if (this.myLogger.isLoggable(Logger.SEVERE)) {
                this.myLogger.log(Logger.SEVERE, "***  Agent " + this.myAgent.getName() + " moved in a forbidden situation ***");
            }
            this.myAgent.clean(true);
        }

        public boolean transitionTo(LifeCycle newLF) {
            int s = newLF.getState();
            return s == 9 || s == 2 || s == 6;
        }

        public boolean isMessageAware() {
            return this.messageAware;
        }

        public void informMoved(AID agentID, Location where) throws ServiceException, JADESecurityException, NotFoundException, IMTPException {
            GenericCommand cmd = new GenericCommand("Inform-Moved", AgentMobilityService.NAME, null);
            cmd.addParam(agentID);
            cmd.addParam(where);
            this.myService.initCredentials(cmd, agentID);
            Object lastException = this.myService.submit(cmd);
            if (lastException != null) {
                if (lastException instanceof JADESecurityException) {
                    throw (JADESecurityException)lastException;
                }
                if (lastException instanceof NotFoundException) {
                    throw (NotFoundException)lastException;
                }
                if (lastException instanceof IMTPException) {
                    throw (IMTPException)lastException;
                }
            }
        }
    }

    private class AgentMobilityHelperImpl
    implements AgentMobilityHelper {
        private Agent myAgent;
        private Movable myMovable;

        private AgentMobilityHelperImpl() {
        }

        public void init(Agent a) {
            this.myAgent = a;
        }

        public void registerMovable(Movable m) {
            this.myMovable = m;
        }

        public void move(Location destination) {
            this.myAgent.changeStateTo(new TransitLifeCycle(destination, this.myMovable, AgentMobilityService.this));
        }

        public void clone(Location destination, String newName) {
            this.myAgent.changeStateTo(new CopyLifeCycle(destination, newName, this.myMovable, AgentMobilityService.this));
        }

        public ClassLoader getContainerClassLoader(String codeSourceContainer, ClassLoader parent) throws ServiceException {
            try {
                return new MobileAgentClassLoader(null, codeSourceContainer, AgentMobilityService.this.myFinder, parent);
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Communication error retrieving code source container slice.", imtpe);
            }
        }
    }

    private class Deserializer
    extends ObjectInputStream {
        private String agentName;
        private String classSiteName;
        private ServiceFinder finder;

        public Deserializer(InputStream inner, String an, String sliceName, ServiceFinder sf) throws IOException {
            super(inner);
            this.agentName = an;
            this.classSiteName = sliceName;
            this.finder = sf;
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            Class c;
            block6: {
                String key = this.createClassLoaderKey(this.agentName, this.classSiteName);
                MobileAgentClassLoader cl = (MobileAgentClassLoader)AgentMobilityService.this.loaders.get(key);
                if (cl == null) {
                    try {
                        cl = new MobileAgentClassLoader(this.agentName, this.classSiteName, this.finder, AgentMobilityService.this.getClass().getClassLoader());
                        AgentMobilityService.this.loaders.put(key, cl);
                    }
                    catch (IMTPException imtpe) {
                        imtpe.printStackTrace();
                        throw new ClassNotFoundException("Error creating MobileAgent ClassLoader. " + imtpe.getMessage());
                    }
                    catch (ServiceException se) {
                        se.printStackTrace();
                        throw new ClassNotFoundException("Error creating MobileAgent ClassLoader. " + se.getMessage());
                    }
                }
                try {
                    c = Class.forName(v.getName(), true, cl);
                }
                catch (ClassNotFoundException ex) {
                    c = (Class)primitiveJavaClasses.get(v.getName());
                    if (c != null) break block6;
                    throw ex;
                }
            }
            return c;
        }

        private String createClassLoaderKey(String agentName, String classSiteName) {
            return agentName + '#' + classSiteName;
        }
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        public Service getService() {
            return AgentMobilityService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return AgentMobilityService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Problem in contacting the IMTP Manager", imtpe);
            }
        }

        public VerticalCommand serve(HorizontalCommand cmd) {
            Command result;
            block21: {
                result = null;
                try {
                    String cmdName = cmd.getName();
                    Object[] params = cmd.getParams();
                    if (cmdName.equals("1")) {
                        AID agentID = (AID)params[0];
                        byte[] serializedInstance = (byte[])params[1];
                        String classSiteName = (String)params[2];
                        boolean isCloned = (Boolean)params[3];
                        boolean startIt = (Boolean)params[4];
                        Agent instance = this.deserializeAgent(agentID, serializedInstance, classSiteName, isCloned, startIt);
                        GenericCommand gCmd = new GenericCommand("Inform-Moved", AgentMobilityService.NAME, null);
                        gCmd.addParam(agentID);
                        gCmd.addParam(instance);
                        gCmd.addParam(classSiteName);
                        gCmd.addParam(new Boolean(isCloned));
                        gCmd.addParam(new Boolean(startIt));
                        result = gCmd;
                    } else if (cmdName.equals("2")) {
                        String className = (String)params[0];
                        String agentName = (String)params[1];
                        cmd.setReturnValue(this.fetchClassFile(className, agentName));
                    } else if (cmdName.equals("3")) {
                        GenericCommand gCmd = new GenericCommand("Request-Move", AgentMobilityService.NAME, null);
                        AID agentID = (AID)params[0];
                        Location where = (Location)params[1];
                        gCmd.addParam(agentID);
                        gCmd.addParam(where);
                        result = gCmd;
                    } else if (cmdName.equals("4")) {
                        GenericCommand gCmd = new GenericCommand("Request-Clone", AgentMobilityService.NAME, null);
                        AID agentID = (AID)params[0];
                        Location where = (Location)params[1];
                        String newName = (String)params[2];
                        gCmd.addParam(agentID);
                        gCmd.addParam(where);
                        gCmd.addParam(newName);
                        result = gCmd;
                    } else if (cmdName.equals("5")) {
                        cmd.setReturnValue(new Boolean(this.prepare()));
                    } else if (cmdName.equals("6")) {
                        AID agentID = (AID)params[0];
                        Location src = (Location)params[1];
                        Location dest = (Location)params[2];
                        cmd.setReturnValue(new Boolean(this.transferIdentity(agentID, src, dest)));
                    } else if (cmdName.equals("7")) {
                        AID agentID = (AID)params[0];
                        boolean transferResult = (Boolean)params[1];
                        List messages = (List)params[2];
                        this.handleTransferResult(agentID, transferResult, messages);
                    } else if (cmdName.equals("8")) {
                        GenericCommand gCmd = new GenericCommand("Inform-Cloned", AgentMobilityService.NAME, null);
                        AID agentID = (AID)params[0];
                        ContainerID cid = (ContainerID)params[1];
                        Credentials creds = (Credentials)params[2];
                        gCmd.addParam(agentID);
                        gCmd.addParam(cid);
                        gCmd.addParam(creds);
                        result = gCmd;
                    } else if (cmdName.equals("9")) {
                        AID oldAgentID = (AID)params[0];
                        AID newAgentID = (AID)params[1];
                        this.handleCloneCodeLocatorEntry(oldAgentID, newAgentID);
                    } else if (cmdName.equals("10")) {
                        AID agentID = (AID)params[0];
                        this.handleRemoveCodeLocatorEntry(agentID);
                    }
                }
                catch (Throwable t) {
                    cmd.setReturnValue(t);
                    if (result == null) break block21;
                    result.setReturnValue(t);
                }
            }
            return result;
        }

        private Agent deserializeAgent(AID agentID, byte[] serializedInstance, String classSiteName, boolean isCloned, boolean startIt) throws IMTPException, ServiceException, NotFoundException, NameClashException, JADESecurityException {
            try {
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.CONFIG)) {
                    AgentMobilityService.this.myLogger.log(Logger.CONFIG, "Incoming agent " + agentID.getName());
                }
                Deserializer in = new Deserializer(new ByteArrayInputStream(serializedInstance), agentID.getName(), classSiteName, AgentMobilityService.this.myContainer.getServiceFinder());
                Agent instance = (Agent)in.readObject();
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                    AgentMobilityService.this.myLogger.log(Logger.FINE, "Agent " + agentID + " reconstructed");
                }
                return instance;
            }
            catch (IOException ioe) {
                throw new IMTPException("An I/O error occurred during de-serialization", ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IMTPException("A class was not found during de-serialization", cnfe);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IMTPException("Unexpected error in agent deserialization.", t);
            }
        }

        private byte[] fetchClassFile(String className, String agentName) throws IMTPException, ClassNotFoundException {
            if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                AgentMobilityService.this.myLogger.log(Logger.FINE, "Fetching class " + className);
            }
            String fileName = className.replace('.', '/') + ".class";
            InputStream classStream = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (classStream == null) {
                classStream = ClassLoader.getSystemResourceAsStream(fileName);
            }
            if (classStream == null) {
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                    AgentMobilityService.this.myLogger.log(Logger.FINER, "Class not found as a system resource. Try manually");
                }
                classStream = this.manualGetResourceAsStream(fileName);
            }
            if (classStream == null && agentName != null) {
                try {
                    AgentManagementService amSrv = (AgentManagementService)AgentMobilityService.this.myFinder.findService("jade.core.management.AgentManagement");
                    ClassLoader cLoader = amSrv.getCodeLocator().getAgentClassLoader(new AID(agentName, true));
                    classStream = cLoader.getResourceAsStream(fileName);
                }
                catch (NullPointerException npe) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (classStream == null) {
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.WARNING)) {
                    AgentMobilityService.this.myLogger.log(Logger.WARNING, "Class " + className + " not found");
                }
                throw new ClassNotFoundException(className);
            }
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[4096];
                int read = 0;
                DataInputStream dis = new DataInputStream(classStream);
                while ((read = dis.read(bytes)) >= 0) {
                    baos.write(bytes, 0, read);
                }
                dis.close();
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                    AgentMobilityService.this.myLogger.log(Logger.FINER, "Class " + className + " fetched");
                }
                return baos.toByteArray();
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException("IOException reading class bytes. " + ioe.getMessage());
            }
        }

        private InputStream manualGetResourceAsStream(String fileName) {
            InputStream classStream = null;
            String currentCp = System.getProperty("java.class.path");
            StringTokenizer st = new StringTokenizer(currentCp, File.pathSeparator);
            while (st.hasMoreTokens()) {
                try {
                    File f;
                    String path = st.nextToken();
                    if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                        AgentMobilityService.this.myLogger.log(Logger.FINER, "Searching in path " + path);
                    }
                    if (path.endsWith(".jar")) {
                        ClassInfo info;
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                            AgentMobilityService.this.myLogger.log(Logger.FINER, "It's a jar file");
                        }
                        if ((info = this.getClassStreamFromJar(fileName, path)) == null) continue;
                        classStream = info.getClassStream();
                        break;
                    }
                    if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                        AgentMobilityService.this.myLogger.log(Logger.FINER, "Trying file " + path + "/" + fileName);
                    }
                    if (!(f = new File(path + "/" + fileName)).exists()) continue;
                    if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                        AgentMobilityService.this.myLogger.log(Logger.FINER, "File exists");
                    }
                    classStream = new FileInputStream(f);
                    break;
                }
                catch (Exception e) {
                    if (!AgentMobilityService.this.myLogger.isLoggable(Logger.WARNING)) continue;
                    AgentMobilityService.this.myLogger.log(Logger.WARNING, e.toString());
                }
            }
            return classStream;
        }

        private ClassInfo getClassStreamFromJar(String classFileName, String jarName) throws IOException {
            ZipFile zf;
            ZipEntry e;
            File f = new File(jarName);
            if (f.exists() && AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                AgentMobilityService.this.myLogger.log(Logger.FINER, "Jar file exists");
            }
            if ((e = (zf = new ZipFile(f)).getEntry(classFileName)) != null) {
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                    AgentMobilityService.this.myLogger.log(Logger.FINER, "Entry " + classFileName + " found");
                }
                return new ClassInfo(zf.getInputStream(e), (int)e.getSize());
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleTransferResult(AID agentID, boolean result, List messages) throws IMTPException, NotFoundException {
            if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                AgentMobilityService.this.myLogger.log(Logger.FINER, "Activating incoming agent " + agentID);
            }
            try {
                Agent agent = AgentMobilityService.this.myContainer.acquireLocalAgent(agentID);
                if (agent == null || agent.getState() != 7) {
                    throw new NotFoundException("handleTransferResult() unable to find a suitable agent.");
                }
                if (!result) {
                    AgentMobilityService.this.myContainer.removeLocalAgent(agentID);
                } else {
                    for (int i = messages.size(); i > 0; --i) {
                        agent.putBack((ACLMessage)messages.get(i - 1));
                    }
                    AgentMobilityService.this.myContainer.powerUpLocalAgent(agentID);
                    if (AgentMobilityService.this.myLogger.isLoggable(Logger.CONFIG)) {
                        AgentMobilityService.this.myLogger.log(Logger.CONFIG, "Incoming agent " + agentID.getName() + " activated");
                    }
                }
            }
            finally {
                AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
            }
        }

        private boolean prepare() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean transferIdentity(AID agentID, Location src, Location dest) throws IMTPException, NotFoundException {
            MainContainer impl;
            if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                AgentMobilityService.this.myLogger.log(Logger.FINE, "Transferring identity of agent " + agentID + " from " + src.getName() + " to " + dest.getName());
            }
            if ((impl = AgentMobilityService.this.myContainer.getMain()) != null) {
                AgentDescriptor ad = impl.acquireAgentDescriptor(agentID);
                if (ad != null) {
                    try {
                        AgentMobilitySlice srcSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(src.getName());
                        AgentMobilitySlice destSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(dest.getName());
                        boolean srcReady = false;
                        boolean destReady = false;
                        try {
                            srcReady = srcSlice.prepare();
                        }
                        catch (IMTPException imtpe) {
                            srcSlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(src.getName());
                            srcReady = srcSlice.prepare();
                        }
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                            AgentMobilityService.this.myLogger.log(Logger.FINE, "Source " + src.getName() + " " + srcReady);
                        }
                        try {
                            destReady = destSlice.prepare();
                        }
                        catch (IMTPException imtpe) {
                            destSlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(dest.getName());
                            destReady = destSlice.prepare();
                        }
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                            AgentMobilityService.this.myLogger.log(Logger.FINE, "Destination " + dest.getName() + " " + destReady);
                        }
                        if (srcReady && destReady) {
                            AgentMobilityService.this.movedAgent(agentID, (ContainerID)src, (ContainerID)dest);
                            AgentMobilityService.this.replicationHandle.invokeReplicatedMethod("movedAgent", new Object[]{agentID, (ContainerID)src, (ContainerID)dest});
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    catch (Exception e) {
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.WARNING)) {
                            AgentMobilityService.this.myLogger.log(Logger.WARNING, "Link failure!");
                        }
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        impl.releaseAgentDescriptor(agentID);
                    }
                }
                throw new NotFoundException("Agent agentID not found");
            }
            if (AgentMobilityService.this.myLogger.isLoggable(Logger.WARNING)) {
                AgentMobilityService.this.myLogger.log(Logger.WARNING, "Not a main!");
            }
            return false;
        }

        private void handleCloneCodeLocatorEntry(AID oldAgentID, AID newAgentID) throws ServiceException, IMTPException, NotFoundException {
            AgentManagementService amSrv = (AgentManagementService)AgentMobilityService.this.myFinder.findService("jade.core.management.AgentManagement");
            CodeLocator codeLocator = amSrv.getCodeLocator();
            if (codeLocator.isRegistered(oldAgentID)) {
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                    AgentMobilityService.this.myLogger.log(Logger.FINE, " adding clone " + newAgentID.getName() + " to code locator.");
                }
                codeLocator.cloneAgent(oldAgentID, newAgentID);
            }
        }

        private void handleRemoveCodeLocatorEntry(AID agentID) throws IMTPException, ServiceException {
            if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                AgentMobilityService.this.myLogger.log(Logger.FINE, "Target sink consuming command REMOVE_CODE_LOCATOR_ENTRY");
            }
            AgentManagementService amSrv = (AgentManagementService)AgentMobilityService.this.myFinder.findService("jade.core.management.AgentManagement");
            CodeLocator codeLocator = amSrv.getCodeLocator();
            codeLocator.removeAgent(agentID);
        }

        private class ClassInfo {
            private InputStream classStream;
            private int length = -1;

            public ClassInfo(InputStream is, int l) {
                this.classStream = is;
                this.length = l;
            }

            public InputStream getClassStream() {
                return this.classStream;
            }

            public int getLength() {
                return this.length;
            }
        }
    }

    private class CommandOutgoingFilter
    extends Filter {
        private CommandOutgoingFilter() {
        }

        protected boolean accept(VerticalCommand cmd) {
            block7: {
                String name = cmd.getName();
                if (name.equals("Inform-Killed")) {
                    try {
                        this.handleInformKilled(cmd);
                    }
                    catch (NotFoundException nfe) {
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.WARNING)) {
                            AgentMobilityService.this.myLogger.log(Logger.WARNING, "CommandOutgoingFilter: Error deleting remote CodeLocator entry: " + nfe);
                        }
                    }
                    catch (ServiceException se) {
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.WARNING)) {
                            AgentMobilityService.this.myLogger.log(Logger.WARNING, "CommandOutgoingFilter: Error deleting remote CodeLocator entry: " + se);
                        }
                    }
                    catch (IMTPException imtpe) {
                        if (!AgentMobilityService.this.myLogger.isLoggable(Logger.WARNING)) break block7;
                        AgentMobilityService.this.myLogger.log(Logger.WARNING, "CommandOutgoingFilter: Error deleting remote CodeLocator entry: " + imtpe);
                    }
                }
            }
            return true;
        }

        private void handleInformKilled(VerticalCommand cmd) throws IMTPException, NotFoundException, ServiceException {
            AgentMobilitySlice codeSlice;
            Object[] params = cmd.getParams();
            AID target = (AID)params[0];
            if (AgentMobilityService.this.myLogger.isLoggable(Logger.CONFIG)) {
                AgentMobilityService.this.myLogger.log(Logger.CONFIG, "Outgoing Filer accepting command INFORM_KILLED. Name is " + target.getName());
            }
            String containerName = AgentMobilityService.this.myContainer.getID().getName();
            Agent agent = AgentMobilityService.this.myContainer.acquireLocalAgent(target);
            String codeContainerName = AgentMobilityService.this.getClassSite(agent);
            AgentMobilityService.this.myContainer.releaseLocalAgent(target);
            if (codeContainerName != null && !containerName.equals(codeContainerName) && (codeSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(codeContainerName)) != null) {
                try {
                    try {
                        codeSlice.removeCodeLocatorEntry(target);
                    }
                    catch (IMTPException imtpe) {
                        codeSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(codeContainerName);
                        codeSlice.removeCodeLocatorEntry(target);
                    }
                }
                catch (Exception e) {
                    AgentMobilityService.this.myLogger.log(Logger.WARNING, "Error notifying home container " + codeContainerName + " of terminating agent " + target.getName(), e);
                }
            }
        }
    }

    private class CommandTargetSink
    implements Sink {
        private CommandTargetSink() {
        }

        public void consume(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Request-Move")) {
                    this.handleRequestMove(cmd);
                } else if (name.equals("Request-Clone")) {
                    this.handleRequestClone(cmd);
                } else if (name.equals("Inform-Moved")) {
                    this.handleInformMoved(cmd);
                } else if (name.equals("Inform-Cloned")) {
                    this.handleInformCloned(cmd);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
        }

        private void handleRequestMove(VerticalCommand cmd) throws IMTPException, NotFoundException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            Location where = (Location)params[1];
            this.moveAgent(agentID, where);
        }

        private void handleRequestClone(VerticalCommand cmd) throws IMTPException, NotFoundException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            Location where = (Location)params[1];
            String newName = (String)params[2];
            this.copyAgent(agentID, where, newName);
        }

        private void handleInformMoved(VerticalCommand cmd) throws IMTPException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            Agent instance = (Agent)params[1];
            String classSiteName = (String)params[2];
            boolean isCloned = (Boolean)params[3];
            boolean startIt = (Boolean)params[4];
            try {
                Credentials agentCerts = null;
                if (isCloned) {
                    AgentMobilitySlice mainSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice("$$$Main-Slice$$$");
                    try {
                        mainSlice.clonedAgent(agentID, AgentMobilityService.this.myContainer.getID(), agentCerts);
                    }
                    catch (IMTPException imtpe) {
                        mainSlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice("$$$Main-Slice$$$");
                        mainSlice.clonedAgent(agentID, AgentMobilityService.this.myContainer.getID(), agentCerts);
                    }
                }
                AgentMobilityService.this.sites.put(instance, classSiteName);
                Agent old = AgentMobilityService.this.myContainer.addLocalAgent(agentID, instance);
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                    AgentMobilityService.this.myLogger.log(Logger.FINE, "Agent " + agentID.getName() + " inserted into LADT");
                }
                if (startIt) {
                    AgentMobilityService.this.myContainer.powerUpLocalAgent(agentID);
                }
            }
            catch (IMTPException imtpe) {
                throw imtpe;
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IMTPException("Unexpected error managing incoming agent.", t);
            }
        }

        private void handleInformCloned(VerticalCommand cmd) throws JADESecurityException, NotFoundException, NameClashException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            ContainerID cid = (ContainerID)params[1];
            Credentials creds = (Credentials)params[2];
            this.clonedAgent(agentID, cid, creds);
        }

        private void moveAgent(AID agentID, Location where) throws IMTPException, NotFoundException {
            Agent a = AgentMobilityService.this.myContainer.acquireLocalAgent(agentID);
            if (a == null) {
                throw new NotFoundException("Move-Agent failed to find " + agentID);
            }
            a.doMove(where);
            AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
        }

        private void copyAgent(AID agentID, Location where, String newName) throws IMTPException, NotFoundException {
            Agent a = AgentMobilityService.this.myContainer.acquireLocalAgent(agentID);
            if (a == null) {
                throw new NotFoundException("Clone-Agent failed to find " + agentID);
            }
            a.doClone(where, newName);
            AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
        }

        private void clonedAgent(AID agentID, ContainerID cid, Credentials credentials) throws JADESecurityException, NotFoundException, NameClashException {
            MainContainer impl = AgentMobilityService.this.myContainer.getMain();
            if (impl != null) {
                JADEPrincipal ownerPr;
                String ownership = "NONE";
                if (credentials != null && (ownerPr = credentials.getOwner()) != null) {
                    ownership = ownerPr.getName();
                }
                AgentMobilityService.this.bornAgent(agentID, cid, null, ownership, false);
                AgentMobilityService.this.replicationHandle.invokeReplicatedMethod("bornAgent", new Object[]{agentID, cid, null, ownership, new Boolean(true)});
            }
        }
    }

    private class CommandSourceSink
    implements Sink {
        private CommandSourceSink() {
        }

        public void consume(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Request-Move")) {
                    this.handleRequestMove(cmd);
                } else if (name.equals("Request-Clone")) {
                    this.handleRequestClone(cmd);
                } else if (name.equals("Inform-Moved")) {
                    this.handleInformMoved(cmd);
                } else if (name.equals("Inform-Cloned")) {
                    this.handleInformCloned(cmd);
                }
            }
            catch (IMTPException imtpe) {
                cmd.setReturnValue(imtpe);
            }
            catch (NotFoundException nfe) {
                cmd.setReturnValue(nfe);
            }
            catch (NameClashException nce) {
                cmd.setReturnValue(nce);
            }
            catch (JADESecurityException ae) {
                cmd.setReturnValue(ae);
            }
            catch (ServiceException se) {
                cmd.setReturnValue(new IMTPException("Service error", se));
            }
        }

        private void handleRequestMove(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            Location where = (Location)params[1];
            MainContainer impl = AgentMobilityService.this.myContainer.getMain();
            if (impl != null) {
                ContainerID cid = impl.getContainerID(agentID);
                AgentMobilitySlice targetSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(cid.getName());
                try {
                    targetSlice.moveAgent(agentID, where);
                }
                catch (IMTPException imtpe) {
                    targetSlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(cid.getName());
                    targetSlice.moveAgent(agentID, where);
                }
            }
        }

        private void handleRequestClone(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            Location where = (Location)params[1];
            String newName = (String)params[2];
            MainContainer impl = AgentMobilityService.this.myContainer.getMain();
            if (impl != null) {
                ContainerID cid = impl.getContainerID(agentID);
                AgentMobilitySlice targetSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(cid.getName());
                try {
                    targetSlice.copyAgent(agentID, where, newName);
                }
                catch (IMTPException imtpe) {
                    targetSlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(cid.getName());
                    targetSlice.copyAgent(agentID, where, newName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleInformMoved(VerticalCommand cmd) throws IMTPException, ServiceException, JADESecurityException, NotFoundException {
            block47: {
                Agent a;
                Object[] params = cmd.getParams();
                AID agentID = (AID)params[0];
                Location where = (Location)params[1];
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.CONFIG)) {
                    AgentMobilityService.this.myLogger.log(Logger.CONFIG, "Moving agent " + agentID.getName() + " on container " + where.getName());
                }
                if ((a = AgentMobilityService.this.myContainer.acquireLocalAgent(agentID)) == null) {
                    AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Internal error: handleMove() called with a wrong name (" + agentID.getName() + ") !!!");
                    return;
                }
                int transferState = 0;
                ArrayList messages = new ArrayList();
                AgentMobilitySlice dest = null;
                try {
                    String classSiteName;
                    if (CaseInsensitiveString.equalsIgnoreCase(where.getName(), AgentMobilityService.this.myContainer.here().getName())) {
                        return;
                    }
                    dest = (AgentMobilitySlice)AgentMobilityService.this.getSlice(where.getName());
                    if (dest == null) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Destination " + where.getName() + " does not exist or does not support mobility");
                        return;
                    }
                    if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                        AgentMobilityService.this.myLogger.log(Logger.FINE, "Destination container for agent " + agentID + " found");
                    }
                    transferState = 1;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ObjectOutputStream encoder = new ObjectOutputStream(out);
                    encoder.writeObject(a);
                    byte[] bytes = out.toByteArray();
                    if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                        AgentMobilityService.this.myLogger.log(Logger.FINE, "Agent " + agentID.getName() + " correctly serialized");
                    }
                    if ((classSiteName = (String)AgentMobilityService.this.sites.get(a)) == null) {
                        classSiteName = AgentMobilityService.this.getLocalNode().getName();
                    }
                    try {
                        dest.createAgent(agentID, bytes, classSiteName, false, false);
                    }
                    catch (IMTPException imtpe) {
                        dest = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(where.getName());
                        dest.createAgent(agentID, bytes, classSiteName, false, false);
                    }
                    transferState = 2;
                    if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                        AgentMobilityService.this.myLogger.log(Logger.FINE, "Agent " + agentID.getName() + " correctly created on destination container");
                    }
                    AgentMobilitySlice mainSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice("$$$Main-Slice$$$");
                    boolean transferResult = false;
                    try {
                        transferResult = mainSlice.transferIdentity(agentID, (ContainerID)AgentMobilityService.this.myContainer.here(), (ContainerID)where);
                    }
                    catch (IMTPException imtpe) {
                        mainSlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice("$$$Main-Slice$$$");
                        transferResult = mainSlice.transferIdentity(agentID, (ContainerID)AgentMobilityService.this.myContainer.here(), (ContainerID)where);
                    }
                    transferState = 3;
                    if (transferResult) {
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                            AgentMobilityService.this.myLogger.log(Logger.FINE, "Identity of agent " + agentID.getName() + " correctly transferred");
                        }
                        AgentMobilityService.this.myContainer.fillListFromMessageQueue(messages, a);
                        dest.handleTransferResult(agentID, transferResult, messages);
                        try {
                            a.changeStateTo(new LifeCycle(9){

                                public boolean alive() {
                                    return false;
                                }
                            });
                            AgentMobilityService.this.myContainer.removeLocalAgent(a.getAID());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        AgentMobilityService.this.sites.remove(a);
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                            AgentMobilityService.this.myLogger.log(Logger.FINE, "Agent " + agentID.getName() + " correctly gone");
                        }
                        break block47;
                    }
                    AgentMobilityService.this.myLogger.log(Logger.WARNING, "Error transferring identity of agent " + agentID.getName());
                    a.restoreBufferedState();
                    dest.handleTransferResult(agentID, transferResult, messages);
                    AgentMobilityService.this.myLogger.log(Logger.WARNING, "Migration of agent " + agentID.getName() + "aborted");
                }
                catch (IOException ioe) {
                    AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Error in agent serialization. Abort transfer. " + ioe);
                }
                catch (JADESecurityException ae) {
                    AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Permission to move not owned. Abort transfer. " + ae.getMessage());
                }
                catch (NotFoundException nfe) {
                    if (transferState == 0) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Destination container does not exist. Abort transfer. " + nfe.getMessage());
                    } else if (transferState == 2) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Transferring agent does not seem to be part of the platform. Abort transfer. " + nfe.getMessage());
                    } else if (transferState == 3) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Transferred agent not found on destination container. Can't roll back. " + nfe.getMessage());
                    }
                }
                catch (NameClashException nce) {
                    nce.printStackTrace();
                }
                catch (IMTPException imtpe) {
                    if (transferState == 0) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Can't retrieve destination container. Abort transfer. " + imtpe.getMessage());
                    } else if (transferState == 1) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Error creating agent on destination container. Abort transfer. " + imtpe.getMessage());
                    } else if (transferState == 2) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Error transferring agent identity. Abort transfer. " + imtpe.getMessage());
                        try {
                            dest.handleTransferResult(agentID, false, messages);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (transferState == 3) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Error activating transferred agent. Can't roll back!!!. " + imtpe.getMessage());
                    }
                }
                finally {
                    if (transferState <= 2) {
                        a.restoreBufferedState();
                    }
                    AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
                }
            }
        }

        private void handleInformCloned(VerticalCommand cmd) throws IMTPException, NotFoundException, NameClashException, JADESecurityException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            Location where = (Location)params[1];
            String newName = (String)params[2];
            try {
                String classSiteName;
                Agent a;
                String containerName = AgentMobilityService.this.myContainer.getID().getName();
                Agent agent = AgentMobilityService.this.myContainer.acquireLocalAgent(agentID);
                String codeContainerName = AgentMobilityService.this.getClassSite(agent);
                AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
                AgentManagementService amSrv = (AgentManagementService)AgentMobilityService.this.myFinder.findService("jade.core.management.AgentManagement");
                CodeLocator codeLocator = amSrv.getCodeLocator();
                if (codeContainerName == null) {
                    codeContainerName = containerName;
                }
                if (containerName.equals(codeContainerName)) {
                    if (codeLocator.isRegistered(agentID)) {
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                            AgentMobilityService.this.myLogger.log(Logger.FINE, " adding clone " + newName + " to code locator.");
                        }
                        codeLocator.cloneAgent(agentID, new AID(newName, false));
                    }
                } else {
                    AgentMobilitySlice codeSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(codeContainerName);
                    try {
                        codeSlice.cloneCodeLocatorEntry(agentID, new AID(newName, false));
                    }
                    catch (IMTPException imtpe) {
                        codeSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(codeContainerName);
                        codeSlice.cloneCodeLocatorEntry(agentID, new AID(newName, false));
                    }
                }
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.CONFIG)) {
                    AgentMobilityService.this.myLogger.log(Logger.CONFIG, "Cloning agent " + agentID + " on container " + where.getName());
                }
                if ((a = AgentMobilityService.this.myContainer.acquireLocalAgent(agentID)) == null) {
                    if (AgentMobilityService.this.myLogger.isLoggable(Logger.SEVERE)) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Internal error: handleClone() called with a wrong name (" + agentID + ") !!!");
                    }
                    return;
                }
                AgentMobilitySlice dest = (AgentMobilitySlice)AgentMobilityService.this.getSlice(where.getName());
                if (dest == null) {
                    AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Destination " + where.getName() + " does not exist or does not support mobility");
                    return;
                }
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                    AgentMobilityService.this.myLogger.log(Logger.FINE, "Destination container for agent " + agentID + " found");
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream encoder = new ObjectOutputStream(out);
                encoder.writeObject(a);
                byte[] bytes = out.toByteArray();
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                    AgentMobilityService.this.myLogger.log(Logger.FINE, "Agent " + agentID + " correctly serialized");
                }
                if ((classSiteName = (String)AgentMobilityService.this.sites.get(a)) == null) {
                    classSiteName = AgentMobilityService.this.getLocalNode().getName();
                }
                AID newID = new AID(newName, false);
                try {
                    dest.createAgent(newID, bytes, classSiteName, true, true);
                }
                catch (IMTPException imtpe) {
                    dest = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(where.getName());
                    dest.createAgent(newID, bytes, classSiteName, true, true);
                }
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                    AgentMobilityService.this.myLogger.log(Logger.FINE, "Cloned Agent " + newID + " correctly created on destination container");
                }
            }
            catch (IOException ioe) {
                throw new IMTPException("I/O serialization error in handleInformCloned()", ioe);
            }
            catch (ServiceException se) {
                throw new IMTPException("Destination container not found in handleInformCloned()", se);
            }
            finally {
                AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
            }
        }
    }
}

