/*
 * Decompiled with CFR 0.152.
 */
package jade.core.mobility;

import jade.core.IMTPException;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.mobility.AgentMobilitySlice;
import jade.util.Logger;

class MobileAgentClassLoader
extends ClassLoader {
    private AgentMobilitySlice classServer;
    private String agentName;
    private String sliceName;
    private ServiceFinder finder;
    private Logger myLogger = Logger.getMyLogger("jade.core.mobility.AgentMobility");

    public MobileAgentClassLoader(String an, String sn, ServiceFinder sf, ClassLoader parent) throws IMTPException, ServiceException {
        super(parent);
        this.agentName = an;
        this.sliceName = sn;
        this.finder = sf;
        this.classServer = (AgentMobilitySlice)this.finder.findSlice("jade.core.mobility.AgentMobility", this.sliceName);
        if (this.classServer == null) {
            throw new ServiceException("Code source container " + this.sliceName + " does not exist or does not support mobility");
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] classFile;
        try {
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Remote retrieval of code for class " + name);
            }
            try {
                classFile = this.classServer.fetchClassFile(name, this.agentName);
            }
            catch (IMTPException imtpe) {
                this.classServer = (AgentMobilitySlice)this.finder.findSlice("jade.core.mobility.AgentMobility", this.sliceName);
                classFile = this.classServer.fetchClassFile(name, this.agentName);
            }
        }
        catch (IMTPException imtpe) {
            imtpe.printStackTrace();
            throw new ClassNotFoundException(name);
        }
        catch (ServiceException se) {
            throw new ClassNotFoundException(name);
        }
        if (classFile != null) {
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Code of class " + name + " retrieved. Length is " + classFile.length);
            }
            return this.defineClass(name, classFile, 0, classFile.length);
        }
        throw new ClassNotFoundException(name);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        if (this.myLogger.isLoggable(Logger.FINER)) {
            this.myLogger.log(Logger.FINER, "Loading class " + name);
        }
        c = super.loadClass(name, resolve);
        if (this.myLogger.isLoggable(Logger.FINER)) {
            this.myLogger.log(Logger.FINER, "Class " + name + " loaded");
        }
        return c;
    }
}

