/*
 * Decompiled with CFR 0.152.
 */
package jade.core.replication;

import jade.core.GenericCommand;
import jade.core.Service;
import jade.core.ServiceFinder;
import jade.core.ServiceNotActiveException;
import jade.core.replication.MainReplicationService;
import jade.util.Logger;

public class MainReplicationHandle {
    private String myService;
    private MainReplicationService replicationService;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    public MainReplicationHandle(Service svc, ServiceFinder sf) {
        this.myService = svc.getName();
        try {
            this.replicationService = (MainReplicationService)sf.findService("jade.core.replication.MainReplication");
        }
        catch (ServiceNotActiveException snat) {
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Error accessing the local MainReplicationService.", e);
        }
    }

    public void invokeReplicatedMethod(String methodName, Object[] params) {
        if (this.replicationService != null) {
            GenericCommand cmd = new GenericCommand("14", "jade.core.replication.MainReplication", null);
            cmd.addParam(this.myService);
            cmd.addParam(methodName);
            cmd.addParam(params);
            try {
                this.replicationService.broadcastToReplicas(cmd, false);
            }
            catch (Exception e) {
                this.myLogger.log(Logger.WARNING, "Error propagating H-command " + cmd.getName() + " to replicas. Method to invoke on replicas was " + methodName, e);
            }
        }
    }
}

