/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.gui.AgentTree;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

class AgentTreePopupManager
extends MouseAdapter {
    AgentTree agentTree;

    public AgentTreePopupManager(AgentTree agentTree) {
        this.agentTree = agentTree;
    }

    public void mouseReleased(MouseEvent e) {
        this.handleMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.handleMouseEvent(e);
    }

    private void handleMouseEvent(MouseEvent e) {
        JPopupMenu popup;
        if (e.isPopupTrigger() && (popup = this.getPopup(e)) != null) {
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private JPopupMenu getPopup(MouseEvent e) {
        int selRow = this.agentTree.tree.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.agentTree.tree.getPathForLocation(e.getX(), e.getY());
        if (selRow != -1) {
            TreePath[] paths = this.agentTree.tree.getSelectionPaths();
            AgentTree.Node current = (AgentTree.Node)selPath.getLastPathComponent();
            String typeNode = current.getType();
            TreeSelectionModel model = this.agentTree.tree.getSelectionModel();
            if (!this.agentTree.tree.isRowSelected(selRow)) {
                model.setSelectionPath(selPath);
            } else {
                model.setSelectionPaths(paths);
            }
            return this.agentTree.getPopupMenu(typeNode);
        }
        return null;
    }
}

