/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.AID;
import jade.core.ContainerID;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.PlatformManager;
import jade.core.Service;
import jade.core.ServiceDescriptor;
import jade.core.SliceProxy;
import jade.core.messaging.GenericMessage;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ReceivedObject;
import jade.imtp.leap.Command;
import jade.imtp.leap.JICP.JICPAddress;
import jade.imtp.leap.LEAPSerializationException;
import jade.imtp.leap.NodeStub;
import jade.imtp.leap.PlatformManagerStub;
import jade.imtp.leap.Serializer;
import jade.imtp.leap.Stub;
import jade.imtp.leap.StubHelper;
import jade.imtp.leap.http.HTTPAddress;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.LEAPACLCodec;
import jade.mtp.MTPDescriptor;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.util.leap.ArrayList;
import jade.util.leap.Properties;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.Vector;

class DeliverableDataInputStream
extends DataInputStream {
    private StubHelper myStubHelper;

    public DeliverableDataInputStream(byte[] serialized_byte_array, StubHelper sh) {
        super(new ByteArrayInputStream(serialized_byte_array));
        this.myStubHelper = sh;
    }

    public Object readObject() throws LEAPSerializationException {
        Object className = null;
        try {
            boolean presenceFlag = this.readBoolean();
            if (presenceFlag) {
                byte id = this.readByte();
                switch (id) {
                    case 28: {
                        return this.deserializeHorizontalCommand();
                    }
                    case 0: {
                        return this.deserializeACL();
                    }
                    case 1: {
                        return this.deserializeAID();
                    }
                    case 2: {
                        return this.deserializeAIDArray();
                    }
                    case 35: {
                        return this.deserializeGenericMessage();
                    }
                    case 11: {
                        return this.readUTF();
                    }
                    case 5: {
                        return this.deserializeContainerID();
                    }
                    case 6: {
                        return this.deserializeContainerIDArray();
                    }
                    case 3: {
                        return new Boolean(this.readBoolean());
                    }
                    case 9: {
                        return new Integer(this.readInt());
                    }
                    case 7: {
                        return this.deserializeDate();
                    }
                    case 12: {
                        return this.deserializeStringArray();
                    }
                    case 13: {
                        return this.deserializeVector();
                    }
                    case 14: {
                        return this.deserializeMTPDescriptor();
                    }
                    case 10: {
                        return this.deserializeNodeDescriptor();
                    }
                    case 15: {
                        return this.deserializeNode();
                    }
                    case 34: {
                        return this.deserializePlatformManager();
                    }
                    case 16: {
                        return this.deserializeNodeArray();
                    }
                    case 17: {
                        return this.deserializeEnvelope();
                    }
                    case 18: {
                        return this.deserializeArrayList();
                    }
                    case 19: {
                        return this.deserializeByteArray();
                    }
                    case 20: {
                        return this.deserializeProperties();
                    }
                    case 21: {
                        return this.deserializeReceivedObject();
                    }
                    case 32: {
                        return this.deserializeServiceDescriptor();
                    }
                    case 36: {
                        return this.deserializeSliceProxy();
                    }
                    case 33: {
                        return this.deserializeServiceSliceProxy();
                    }
                    case 22: {
                        return this.deserializeJICPAddress();
                    }
                    case 23: {
                        return this.deserializeHTTPAddress();
                    }
                    case 29: {
                        return this.deserializeThrowable();
                    }
                    case 30: {
                        return this.deserializeProperty();
                    }
                    case 31: {
                        byte[] bytes = this.deserializeByteArray();
                        ByteArrayInputStream inp = new ByteArrayInputStream(bytes);
                        ObjectInputStream decoder = new ObjectInputStream(inp);
                        Object obj = decoder.readObject();
                        return obj;
                    }
                    case 8: {
                        String serName = this.readUTF();
                        Serializer s = (Serializer)Class.forName(serName).newInstance();
                        Object o = s.deserialize(this);
                        return o;
                    }
                }
                throw new LEAPSerializationException("Unknown class ID: " + id);
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LEAPSerializationException("I/O Error Deserializing a generic object");
        }
        catch (LEAPSerializationException leapse) {
            throw leapse;
        }
        catch (Exception e) {
            throw new LEAPSerializationException("Error creating (de)Serializer: " + e);
        }
    }

    public String readString() throws LEAPSerializationException {
        try {
            boolean presenceFlag = this.readBoolean();
            if (presenceFlag) {
                return this.readUTF();
            }
            return null;
        }
        catch (IOException e) {
            throw new LEAPSerializationException("Error deserializing String");
        }
    }

    public Date readDate() throws LEAPSerializationException {
        try {
            boolean presenceFlag = this.readBoolean();
            if (presenceFlag) {
                return this.deserializeDate();
            }
            return null;
        }
        catch (IOException e) {
            throw new LEAPSerializationException("Error deserializing Date");
        }
    }

    public StringBuffer readStringBuffer() throws LEAPSerializationException {
        try {
            boolean presenceFlag = this.readBoolean();
            if (presenceFlag) {
                return this.deserializeStringBuffer();
            }
            return null;
        }
        catch (IOException e) {
            throw new LEAPSerializationException("Error deserializing StringBuffer");
        }
    }

    public Vector readVector() throws LEAPSerializationException {
        try {
            boolean presenceFlag = this.readBoolean();
            if (presenceFlag) {
                return this.deserializeVector();
            }
            return null;
        }
        catch (IOException e) {
            throw new LEAPSerializationException("Error deserializing Vector");
        }
    }

    public String[] readStringArray() throws LEAPSerializationException {
        try {
            boolean presenceFlag = this.readBoolean();
            if (presenceFlag) {
                return this.deserializeStringArray();
            }
            return null;
        }
        catch (IOException e) {
            throw new LEAPSerializationException("Error deserializing String[]");
        }
    }

    public Date deserializeDate() throws IOException {
        return new Date(this.readLong());
    }

    public StringBuffer deserializeStringBuffer() throws IOException {
        return new StringBuffer(this.readUTF());
    }

    public Vector deserializeVector() throws IOException, LEAPSerializationException {
        int size = this.readInt();
        Vector<Object> v = new Vector<Object>(size);
        for (int i = 0; i < size; ++i) {
            v.addElement(this.readObject());
        }
        return v;
    }

    public String[] deserializeStringArray() throws IOException, LEAPSerializationException {
        String[] sa = new String[this.readInt()];
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = this.readString();
        }
        return sa;
    }

    private HorizontalCommand deserializeHorizontalCommand() throws LEAPSerializationException {
        try {
            String name = this.readUTF();
            String service = this.readUTF();
            String interaction = this.readString();
            GenericCommand result = new GenericCommand(name, service, interaction);
            int sz = this.readInt();
            for (int i = 0; i < sz; ++i) {
                result.addParam(this.readObject());
            }
            result.setPrincipal((JADEPrincipal)this.readObject());
            result.setCredentials((Credentials)this.readObject());
            return result;
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error deserializing horizontal command");
        }
    }

    private ACLMessage deserializeACL() throws IOException, LEAPSerializationException {
        ACLMessage msg = LEAPACLCodec.deserializeACL(this);
        if (this.readBoolean()) {
            Envelope env = this.deserializeEnvelope();
            msg.setEnvelope(env);
        }
        return msg;
    }

    public AID readAID() throws LEAPSerializationException {
        try {
            boolean presenceFlag = this.readBoolean();
            if (presenceFlag) {
                return this.deserializeAID();
            }
            return null;
        }
        catch (IOException e) {
            throw new LEAPSerializationException("Error deserializing AID");
        }
    }

    AID deserializeAID() throws IOException, LEAPSerializationException {
        return LEAPACLCodec.deserializeAID(this);
    }

    public AID[] deserializeAIDArray() throws IOException, LEAPSerializationException {
        AID[] aida = new AID[this.readInt()];
        for (int i = 0; i < aida.length; ++i) {
            aida[i] = this.readAID();
        }
        return aida;
    }

    private GenericMessage deserializeGenericMessage() throws IOException, LEAPSerializationException {
        byte[] payload = this.deserializeByteArray();
        Envelope env = (Envelope)this.readObject();
        GenericMessage gm = new GenericMessage(env, payload);
        gm.setAMSFailure(this.readBoolean());
        gm.setTraceID((String)this.readObject());
        return gm;
    }

    Command deserializeCommand() throws LEAPSerializationException {
        try {
            Command cmd = new Command(this.readInt(), this.readInt());
            int paramCnt = this.readInt();
            for (int i = 0; i < paramCnt; ++i) {
                cmd.addParam(this.readObject());
            }
            return cmd;
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error deserializing Command");
        }
    }

    private ContainerID deserializeContainerID() throws LEAPSerializationException {
        try {
            ContainerID cid = new ContainerID();
            cid.setName(this.readUTF());
            cid.setAddress(this.readUTF());
            return cid;
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error deserializing ContainerID");
        }
    }

    public ContainerID readContainerID() throws LEAPSerializationException {
        try {
            boolean presenceFlag = this.readBoolean();
            if (presenceFlag) {
                return this.deserializeContainerID();
            }
            return null;
        }
        catch (IOException e) {
            throw new LEAPSerializationException("Error deserializing AID");
        }
    }

    public ContainerID[] deserializeContainerIDArray() throws IOException, LEAPSerializationException {
        ContainerID[] cida = new ContainerID[this.readInt()];
        for (int i = 0; i < cida.length; ++i) {
            cida[i] = this.readContainerID();
        }
        return cida;
    }

    private MTPDescriptor deserializeMTPDescriptor() throws LEAPSerializationException {
        try {
            String name = this.readUTF();
            String className = this.readUTF();
            String[] addresses = this.readStringArray();
            String[] protoNames = this.readStringArray();
            return new MTPDescriptor(name, className, addresses, protoNames);
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error deserializing MTPDescriptor");
        }
    }

    private ServiceDescriptor deserializeServiceDescriptor() throws LEAPSerializationException {
        String name = null;
        String className = null;
        try {
            name = this.readUTF();
            className = this.readUTF();
            Service svc = (Service)Class.forName(className).newInstance();
            return new ServiceDescriptor(name, svc);
        }
        catch (ClassNotFoundException cnfe) {
            throw new LEAPSerializationException("Cannot deserialize ServiceDescriptor: class " + className + " for service " + name + " not found");
        }
        catch (Throwable t) {
            throw new LEAPSerializationException("Error deserializing ServiceDescriptor");
        }
    }

    private SliceProxy deserializeSliceProxy() throws LEAPSerializationException {
        String className = null;
        try {
            className = this.readUTF();
            SliceProxy proxy = (SliceProxy)Class.forName(className).newInstance();
            proxy.setNode(this.readNode());
            return proxy;
        }
        catch (ClassNotFoundException cnfe) {
            throw new LEAPSerializationException("Cannot deserialize SliceProxy: class " + className + " not found");
        }
        catch (Throwable t) {
            throw new LEAPSerializationException("Error deserializing SliceProxy");
        }
    }

    private Service.SliceProxy deserializeServiceSliceProxy() throws LEAPSerializationException {
        try {
            String className = this.readUTF();
            Service.SliceProxy proxy = (Service.SliceProxy)Class.forName(className).newInstance();
            proxy.setNode(this.readNode());
            return proxy;
        }
        catch (Throwable t) {
            throw new LEAPSerializationException("Error deserializing Service.SliceProxy");
        }
    }

    private NodeDescriptor deserializeNodeDescriptor() throws LEAPSerializationException {
        try {
            NodeDescriptor dsc = null;
            Node node = this.deserializeNode();
            if (this.readBoolean()) {
                ContainerID cid = this.deserializeContainerID();
                dsc = new NodeDescriptor(cid, node);
            } else {
                dsc = new NodeDescriptor(node);
            }
            dsc.setParentNode(this.readNode());
            dsc.setUsername(this.readString());
            dsc.setPassword((byte[])this.readObject());
            dsc.setPrincipal((JADEPrincipal)this.readObject());
            dsc.setOwnerPrincipal((JADEPrincipal)this.readObject());
            dsc.setOwnerCredentials((Credentials)this.readObject());
            return dsc;
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error deserializing NodeDescriptor");
        }
    }

    Node deserializeNode() throws LEAPSerializationException {
        try {
            String name = this.readString();
            boolean hasPM = this.readBoolean();
            NodeStub stub = (NodeStub)this.deserializeStub();
            stub.setName(name);
            stub.setPlatformManager(hasPM);
            return stub;
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error deserializing node");
        }
    }

    private PlatformManager deserializePlatformManager() throws LEAPSerializationException {
        String address = this.readString();
        PlatformManagerStub stub = (PlatformManagerStub)this.deserializeStub();
        stub.setLocalAddress(address);
        return stub;
    }

    private Stub deserializeStub() throws LEAPSerializationException {
        try {
            String stubClassName = this.readUTF();
            Stub stub = (Stub)Class.forName(stubClassName).newInstance();
            stub.remoteID = this.readInt();
            stub.platformName = this.readString();
            stub.remoteTAs = this.deserializeArrayList();
            stub.bind(this.myStubHelper);
            return stub;
        }
        catch (Throwable t) {
            throw new LEAPSerializationException("Error deserializing stub");
        }
    }

    private Node readNode() throws LEAPSerializationException {
        try {
            boolean presenceFlag = this.readBoolean();
            if (presenceFlag) {
                return this.deserializeNode();
            }
            return null;
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error deserializing Node");
        }
    }

    private Node[] deserializeNodeArray() throws LEAPSerializationException {
        try {
            Node[] nodes = new Node[this.readInt()];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = this.readNode();
            }
            return nodes;
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error deserializing Node[]");
        }
    }

    public Node[] readNodeArray() throws LEAPSerializationException {
        try {
            boolean presenceFlag = this.readBoolean();
            if (presenceFlag) {
                return this.deserializeNodeArray();
            }
            return null;
        }
        catch (IOException e) {
            throw new LEAPSerializationException("Error deserializing Node[]");
        }
    }

    private Envelope deserializeEnvelope() throws LEAPSerializationException {
        try {
            Envelope e = new Envelope();
            while (this.readBoolean()) {
                e.addTo(this.deserializeAID());
            }
            e.setFrom(this.readAID());
            e.setComments(this.readString());
            e.setAclRepresentation(this.readString());
            e.setPayloadLength(new Long(this.readLong()));
            e.setPayloadEncoding(this.readString());
            e.setDate(this.readDate());
            while (this.readBoolean()) {
                e.addIntendedReceiver(this.deserializeAID());
            }
            e.setReceived((ReceivedObject)this.readObject());
            while (this.readBoolean()) {
                e.addProperties(this.deserializeProperty());
            }
            return e;
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error deserializing Envelope");
        }
    }

    private ArrayList deserializeArrayList() throws LEAPSerializationException {
        try {
            ArrayList l = new ArrayList();
            int size = this.readInt();
            for (int i = 0; i < size; ++i) {
                l.add(this.readObject());
            }
            return l;
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error deserializing ArrayList");
        }
    }

    private byte[] deserializeByteArray() throws LEAPSerializationException {
        try {
            byte[] ba = new byte[this.readInt()];
            this.read(ba, 0, ba.length);
            return ba;
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error deserializing Byte Array");
        }
    }

    private Properties deserializeProperties() throws LEAPSerializationException {
        try {
            Properties p = new Properties();
            int size = this.readInt();
            for (int i = 0; i < size; ++i) {
                p.setProperty((String)this.readObject(), (String)this.readObject());
            }
            return p;
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error deserializing Properties");
        }
    }

    private ReceivedObject deserializeReceivedObject() throws LEAPSerializationException {
        ReceivedObject r = new ReceivedObject();
        r.setBy(this.readString());
        r.setFrom(this.readString());
        r.setDate(this.readDate());
        r.setId(this.readString());
        r.setVia(this.readString());
        return r;
    }

    private Property deserializeProperty() throws LEAPSerializationException {
        Property p = new Property();
        p.setName(this.readString());
        p.setValue(this.readObject());
        return p;
    }

    private JICPAddress deserializeJICPAddress() throws LEAPSerializationException {
        String protocol = this.readString();
        if (!"jicp".equals(protocol)) {
            throw new LEAPSerializationException("Unexpected protocol \"" + protocol + "\" when \"" + "jicp" + "\" was expected.");
        }
        String host = this.readString();
        String port = this.readString();
        String file = this.readString();
        String anchor = this.readString();
        return new JICPAddress(host, port, file, anchor);
    }

    private HTTPAddress deserializeHTTPAddress() throws LEAPSerializationException {
        String protocol = this.readString();
        if (!"http".equals(protocol)) {
            throw new LEAPSerializationException("Unexpected protocol \"" + protocol + "\" when \"" + "http" + "\" was expected.");
        }
        String host = this.readString();
        String port = this.readString();
        String file = this.readString();
        String anchor = this.readString();
        return new HTTPAddress(host, port, file, anchor);
    }

    private Throwable deserializeThrowable() throws LEAPSerializationException {
        String className = this.readString();
        String message = this.readString();
        try {
            Throwable result = (Throwable)Class.forName(className).newInstance();
            return result;
        }
        catch (Throwable t) {
            return new Exception(message + " [Original exception was: " + className + "]");
        }
    }
}

