/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.core.Profile;
import jade.imtp.leap.ICP;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.ConnectionFactory;
import jade.imtp.leap.JICP.JICPClient;
import jade.imtp.leap.JICP.JICPConnection;
import jade.imtp.leap.JICP.JICPProtocol;
import jade.imtp.leap.JICP.JICPServer;
import jade.imtp.leap.JICP.ProtocolManager;
import jade.imtp.leap.TransportProtocol;
import jade.mtp.TransportAddress;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class JICPPeer
implements ICP,
ProtocolManager {
    private static final int POOL_SIZE = 50;
    private JICPClient client;
    private JICPServer server;
    private Ticker ticker;
    private String myID;
    private int connectionTimeout = 0;
    public static final String CONNECTION_TIMEOUT = "jade_imtp_leap_JICP_JICPPeer_connectiontimeout";

    public TransportAddress activate(ICP.Listener l, String peerID, Profile p) throws ICPException {
        this.myID = peerID;
        this.connectionTimeout = Integer.parseInt(p.getParameter(CONNECTION_TIMEOUT, "0"));
        this.client = new JICPClient(this.getProtocol(), this.getConnectionFactory(), 50, this.connectionTimeout);
        this.server = new JICPServer(p, this, l, this.getConnectionFactory(), 50);
        this.server.start();
        this.ticker = new Ticker(60000L);
        this.ticker.start();
        TransportAddress localTA = this.getProtocol().buildAddress(this.server.getLocalHost(), String.valueOf(this.server.getLocalPort()), null, null);
        return localTA;
    }

    public void deactivate() throws ICPException {
        if (this.server == null) {
            throw new ICPException("No external listener was activated.");
        }
        this.client.shutdown();
        this.server.shutdown();
        this.ticker.shutdown();
    }

    public byte[] deliverCommand(TransportAddress ta, byte[] payload, boolean requireFreshConnection) throws ICPException {
        byte[] respPayload = this.client.send(ta, (byte)0, payload, requireFreshConnection);
        return respPayload;
    }

    final String getID() {
        return this.myID;
    }

    String getAddress(String pingURL) throws ICPException {
        byte[] respPayload = null;
        try {
            TransportAddress pingAddr = this.getProtocol().stringToAddr(pingURL);
            respPayload = this.client.send(pingAddr, (byte)21, new byte[0], false);
        }
        catch (ICPException icpe) {
            throw new ICPException("JICP GET_ADDRESS error. Cannot retrieve local hostname: " + icpe.getMessage());
        }
        return new String(respPayload);
    }

    public TransportProtocol getProtocol() {
        return JICPProtocol.getInstance();
    }

    public ConnectionFactory getConnectionFactory() {
        return new ConnectionFactory(){

            public Connection createConnection(Socket s) {
                return new JICPConnection(s);
            }

            public Connection createConnection(TransportAddress ta) throws IOException {
                JICPConnection con = new JICPConnection(ta, JICPPeer.this.connectionTimeout);
                return con;
            }
        };
    }

    protected ServerSocket getServerSocket(String host, int port, boolean changePortIfBusy) throws ICPException {
        try {
            return new ServerSocket(port, 50, host != null ? InetAddress.getByName(host) : null);
        }
        catch (SocketException be) {
            if (changePortIfBusy) {
                try {
                    return new ServerSocket(0, 50, host != null ? InetAddress.getByName(host) : null);
                }
                catch (IOException ioe) {
                    throw new ICPException("Cannot create server socket on a free port. ", ioe);
                }
            }
            throw new ICPException("Cannot bind server socket to " + (host != null ? "host " + host : "localhost") + " port " + port);
        }
        catch (IOException ioe2) {
            throw new ICPException("Cannot create server socket. ", ioe2);
        }
    }

    private class Ticker
    extends Thread {
        private long period;
        private boolean active = false;

        private Ticker(long period) {
            this.period = period;
        }

        public void start() {
            this.active = true;
            super.start();
        }

        public void run() {
            while (this.active) {
                try {
                    Thread.sleep(this.period);
                    long currentTime = System.currentTimeMillis();
                    JICPPeer.this.client.tick(currentTime);
                    JICPPeer.this.server.tick(currentTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void shutdown() {
            this.active = false;
            this.interrupt();
        }
    }
}

