/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.Node;
import jade.core.PlatformManager;
import jade.core.PlatformManagerImpl;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.SliceProxy;
import jade.core.Specifier;
import jade.core.UnreachableException;
import jade.imtp.leap.CommandDispatcher;
import jade.imtp.leap.DispatcherException;
import jade.imtp.leap.ICP;
import jade.imtp.leap.NodeLEAP;
import jade.imtp.leap.NodeSkel;
import jade.imtp.leap.PlatformManagerSkel;
import jade.imtp.leap.TransportProtocol;
import jade.mtp.TransportAddress;
import jade.util.Logger;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.net.InetAddress;

public class LEAPIMTPManager
implements IMTPManager {
    static final String MAIN_URL = "main-url";
    public static final String CHANGE_PORT_IF_BUSY = "jade_imtp_leap_LEAPIMTPManager_changeportifbusy";
    private static final String ICPS = "icps";
    private static final String ROUTER_URL = "router-url";
    private CommandDispatcher theDispatcher = null;
    private Profile theProfile = null;
    private String masterPMAddr;
    private String localAddr;
    private NodeLEAP localNode;
    Logger logger = Logger.getMyLogger(this.getClass().getName());

    public void initialize(Profile p) throws IMTPException {
        Iterator it;
        block8: {
            this.theProfile = p;
            String platformName = p.getParameter("platform-id", null);
            this.theDispatcher = CommandDispatcher.getDispatcher(platformName);
            try {
                this.setDefaults();
                List l = this.theProfile.getSpecifiers(ICPS);
                it = l.iterator();
                while (it.hasNext()) {
                    Specifier s = (Specifier)it.next();
                    try {
                        ICP peer = (ICP)Class.forName(s.getClassName()).newInstance();
                        String id = s.getArgs() != null ? (String)s.getArgs()[0] : null;
                        this.theDispatcher.addICP(peer, id, this.theProfile);
                    }
                    catch (Exception e) {
                        if (!this.logger.isLoggable(Logger.SEVERE)) continue;
                        this.logger.log(Logger.SEVERE, "Error adding ICP. " + e);
                    }
                }
                this.localNode = new NodeLEAP("No-Name", this.theProfile.getBooleanProperty("main", true), this.theDispatcher);
                NodeSkel skel = new NodeSkel(this.localNode);
                this.theDispatcher.registerSkeleton(skel, this.localNode);
            }
            catch (ProfileException pe) {
                if (!this.logger.isLoggable(Logger.SEVERE)) break block8;
                this.logger.log(Logger.SEVERE, "Profile error. " + pe.getMessage());
            }
        }
        List URLs = this.theDispatcher.getLocalURLs();
        if (URLs.size() == 0) {
            throw new IMTPException("No ICP active");
        }
        this.localAddr = (String)URLs.get(0);
        it = URLs.iterator();
        StringBuffer sb = new StringBuffer("Listening for intra-platform commands on address:\n");
        while (it.hasNext()) {
            sb.append("- " + (String)it.next() + "\n");
        }
        this.logger.log(Logger.INFO, sb.toString());
        this.adjustMainURL();
        if (this.theProfile.isBackupMain()) {
            this.masterPMAddr = this.theProfile.getParameter(MAIN_URL, null);
        }
        this.theDispatcher.setRouterAddress(this.theProfile.getParameter(ROUTER_URL, null));
    }

    private void adjustMainURL() {
        try {
            String mainURL = this.theProfile.getParameter(MAIN_URL, null);
            TransportAddress ta = this.theDispatcher.stringToAddr(mainURL);
            InetAddress ad = InetAddress.getByName(ta.getHost());
            TransportProtocol tp = this.theDispatcher.getProtocol(ta.getProto());
            String hostAddr = ad.getHostAddress();
            if (hostAddr.equals("127.0.0.1")) {
                hostAddr = ad.getHostName();
            }
            ta = tp.buildAddress(hostAddr, ta.getPort(), ta.getFile(), ta.getAnchor());
            this.theProfile.setParameter(MAIN_URL, tp.addrToString(ta));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Node getLocalNode() throws IMTPException {
        return this.localNode;
    }

    public void exportPlatformManager(PlatformManager mgr) throws IMTPException {
        PlatformManagerSkel skel = new PlatformManagerSkel(mgr, this);
        mgr.setLocalAddress(this.localAddr);
        this.theDispatcher.registerSkeleton(skel, mgr);
        if (this.masterPMAddr != null) {
            PlatformManager masterPM = this.theDispatcher.getPlatformManagerStub(this.masterPMAddr);
            try {
                ((PlatformManagerImpl)mgr).setPlatformName(masterPM.getPlatformName());
                this.logger.log(Logger.INFO, "Connecting to master Main Container at address " + this.masterPMAddr);
                mgr.addReplica(this.masterPMAddr, true);
                masterPM.addReplica(this.localAddr, false);
            }
            catch (ServiceException se) {
                throw new IMTPException("Cannot attach to the original PlatformManager.", se);
            }
            catch (IMTPException imtpe) {
                Throwable t = imtpe.getNested();
                if (t != null && t instanceof UnreachableException) {
                    this.logger.log(Logger.INFO, "No master Main Container found at address " + this.masterPMAddr + ". Take the leadership");
                    this.masterPMAddr = null;
                    this.theProfile.setParameter("backupmain", "false");
                }
                throw imtpe;
            }
        }
    }

    public void unexportPlatformManager(PlatformManager pm) throws IMTPException {
        this.theDispatcher.deregisterSkeleton(pm);
    }

    public PlatformManager getPlatformManagerProxy() throws IMTPException {
        return this.theDispatcher.getPlatformManagerProxy(this.theProfile);
    }

    public PlatformManager getPlatformManagerProxy(String addr) throws IMTPException {
        return this.theDispatcher.getPlatformManagerStub(addr);
    }

    public void reconnected(PlatformManager pm) {
        this.theDispatcher.setPlatformManagerProxy(pm);
    }

    public Service.Slice createSliceProxy(String serviceName, Class itf, Node where) throws IMTPException {
        try {
            Class<?> proxyClass = Class.forName(serviceName + "Proxy");
            Service.Slice proxy = (Service.Slice)proxyClass.newInstance();
            if (proxy instanceof SliceProxy) {
                ((SliceProxy)proxy).setNode(where);
            } else if (proxy instanceof Service.SliceProxy) {
                ((Service.SliceProxy)proxy).setNode(where);
            } else {
                throw new IMTPException("Class " + proxyClass.getName() + " is not a slice proxy.");
            }
            return proxy;
        }
        catch (Exception e) {
            throw new IMTPException("Error creating a slice proxy", e);
        }
    }

    public void shutDown() {
        try {
            if (this.localNode != null) {
                this.localNode.exit();
                this.theDispatcher.deregisterSkeleton(this.localNode);
            }
        }
        catch (IMTPException imtpe) {
            imtpe.printStackTrace();
        }
    }

    public List getLocalAddresses() {
        return this.theDispatcher.getLocalTAs();
    }

    private void setDefaults() throws ProfileException {
        String mainHost;
        String mainURL = this.theProfile.getParameter(MAIN_URL, null);
        if (mainURL == null && (mainHost = this.getMainHost()) != null) {
            String mainProto = this.theProfile.getParameter("proto", "jicp");
            String mainPort = this.theProfile.getParameter("port", null);
            mainPort = mainPort != null ? ":" + mainPort : ":1099";
            mainURL = new String(mainProto + "://" + mainHost + mainPort);
            this.theProfile.setParameter(MAIN_URL, mainURL);
        }
        if (!this.theProfile.getBooleanProperty("main", true)) {
            if (this.theProfile.getParameter(ICPS, null) == null) {
                String jvm = this.theProfile.getParameter("jvm", null);
                if ("midp".equals(jvm)) {
                    throw new ProfileException("Stand-alone execution mode not supported in MIDP");
                }
                if (this.theDispatcher.getLocalURLs().size() == 0) {
                    this.theProfile.setParameter(ICPS, "jade.imtp.leap.JICP.JICPPeer");
                }
            }
        } else if (this.theProfile.getParameter(ICPS, null) == null) {
            this.theProfile.setParameter(ICPS, "jade.imtp.leap.JICP.JICPPeer");
        }
    }

    private String getMainHost() {
        String host = this.theProfile.getParameter("host", null);
        if (host == null) {
            host = Profile.getDefaultNetworkName();
        }
        return host;
    }

    public TransportAddress stringToAddr(String addr) throws IMTPException {
        try {
            return this.theDispatcher.stringToAddr(addr);
        }
        catch (DispatcherException de) {
            throw new IMTPException(de.getMessage());
        }
    }
}

