/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.IMTPException;
import jade.core.Timer;
import jade.core.TimerDispatcher;
import jade.core.TimerListener;
import jade.imtp.leap.Command;
import jade.imtp.leap.ConnectionDropped;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.ICPDispatchException;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.LEAPSerializationException;
import jade.imtp.leap.SerializationEngine;
import jade.util.Logger;
import java.util.Vector;

public class MicroStub {
    public static final long MINIMUM_TIMEOUT = 3000L;
    protected Dispatcher myDispatcher;
    protected Vector pendingCommands = new Vector();
    private boolean flushing = false;
    private Thread flushingThread;
    private Vector dispatchingThreads = new Vector();
    protected Logger logger;

    public MicroStub(Dispatcher d) {
        this.myDispatcher = d;
        this.logger = Logger.getMyLogger(this.getClass().getName());
    }

    protected Command executeRemotely(Command c, long timeout) throws IMTPException {
        return this.executeRemotely(c, timeout, -1);
    }

    private Command executeRemotely(Command c, long timeout, int sessionId) throws IMTPException {
        long start = System.currentTimeMillis();
        try {
            Command r;
            this.beginDispatch();
            byte[] cmd = SerializationEngine.serialize(c);
            this.logger.log(Logger.FINE, "Dispatching command " + c.getCode() + ". SF-timeout=" + timeout + ", old-SID=" + sessionId);
            byte[] rsp = this.myDispatcher.dispatch(cmd, this.flushing, sessionId);
            if (this.pendingCommands.size() > 0) {
                this.logger.log(Logger.FINE, "############# Dispatch succeeded with " + this.pendingCommands.size() + " pending commands.");
            }
            if ((r = SerializationEngine.deserialize(rsp)).getCode() == 2) {
                if (!((Boolean)r.getParamAt(0)).booleanValue()) {
                    String msg = new String("Exception " + (String)r.getParamAt(1) + " occurred in remote site processing command " + c.getCode() + ". " + (String)r.getParamAt(2));
                    this.logger.log(Logger.SEVERE, msg);
                    throw new IMTPException(msg);
                }
                if (((String)r.getParamAt(1)).equals("jade.core.IMTPException")) {
                    throw new IMTPException((String)r.getParamAt(2));
                }
            }
            Command msg = r;
            return msg;
        }
        catch (ICPException icpe) {
            if (timeout == 0L && icpe instanceof ConnectionDropped) {
                timeout = 30000L;
            }
            if (timeout == 0L) {
                throw new IMTPException("Destination unreachable", icpe);
            }
            if (timeout > 0L) {
                long elapsedTime = System.currentTimeMillis() - start;
                long remainingTime = timeout - elapsedTime;
                timeout = remainingTime > 3000L ? remainingTime : 3000L;
            }
            int dispatchSessionId = -1;
            if (icpe instanceof ICPDispatchException) {
                dispatchSessionId = ((ICPDispatchException)icpe).getSessionId();
            }
            this.postpone(c, timeout, dispatchSessionId, icpe);
            this.logger.log(Logger.WARNING, "Dispatch failed. Command postponed [SF-timeout=" + timeout + ", SID=" + dispatchSessionId + "]. " + icpe.getMessage());
            Command command = null;
            return command;
        }
        catch (FlushDeadlock fd) {
            throw new IMTPException("Flush deadlock detected. Try again later");
        }
        catch (LEAPSerializationException lse) {
            throw new IMTPException("Serialization error", lse);
        }
        finally {
            this.endDispatch();
        }
    }

    private void postpone(Command c, long timeout, int sessionId, ICPException icpe) {
        int size;
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, Thread.currentThread().toString() + ": Command " + c.getCode() + " postponed");
        }
        final PostponedCommand pc = new PostponedCommand(c, sessionId, icpe);
        this.pendingCommands.addElement(pc);
        if (timeout > 0L) {
            this.logger.log(Logger.INFO, Thread.currentThread().toString() + ": Activating Timer for Command " + c.getCode());
            pc.timer = TimerDispatcher.getTimerDispatcher().add(new Timer(System.currentTimeMillis() + timeout, new TimerListener(){

                public void doTimeOut(Timer t) {
                    if (t == pc.timer) {
                        MicroStub.this.logger.log(Logger.INFO, Thread.currentThread().toString() + ": Timer for Command " + pc.command.getCode() + " expired!!!");
                        MicroStub.this.manageTimerExpired(pc);
                    }
                }
            }));
        }
        if ((size = this.pendingCommands.size()) > 100 && size < 110) {
            this.logger.log(Logger.WARNING, size + " postponed commands");
        }
    }

    public boolean flush() {
        Thread t = this.checkFlush();
        if (t != null) {
            t.start();
            return true;
        }
        return false;
    }

    public Thread checkFlush() {
        if (this.beginFlush()) {
            this.flushingThread = new Thread(){

                public void run() {
                    MicroStub.this.logger.log(Logger.INFO, "Start flushing");
                    int flushedCnt = 0;
                    PostponedCommand pc = null;
                    while ((pc = MicroStub.this.removeFirst()) != null) {
                        try {
                            if (MicroStub.this.logger.isLoggable(Logger.FINE)) {
                                MicroStub.this.logger.log(Logger.FINE, "Flushing command: code = " + pc.command.getCode());
                            }
                            Command r = MicroStub.this.executeRemotely(pc.command, 0L, pc.sessionId);
                            if (pc.timer != null) {
                                TimerDispatcher.getTimerDispatcher().remove(pc.timer);
                            }
                            ++flushedCnt;
                            if (r.getCode() != 2) continue;
                            MicroStub.this.logger.log(Logger.SEVERE, "Remote exception in command asynchronous delivery. " + r.getParamAt(2));
                        }
                        catch (Exception ex) {
                            MicroStub.this.logger.log(Logger.WARNING, "Exception in command asynchronous delivery. " + ex);
                            if (ex instanceof ICPDispatchException) {
                                pc.sessionId = ((ICPDispatchException)ex).getSessionId();
                            }
                            MicroStub.this.pendingCommands.insertElementAt(pc, 0);
                            break;
                        }
                    }
                    MicroStub.this.logger.log(Logger.FINE, "########## " + MicroStub.this.pendingCommands.size() + " pending commands after flush");
                    MicroStub.this.endFlush();
                    MicroStub.this.logger.log(Logger.INFO, "Flushing thread terminated (" + flushedCnt + ")");
                }
            };
            return this.flushingThread;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.pendingCommands.size() == 0 && !this.flushing;
    }

    protected void handlePostponedCommandExpired(Command c, ICPException exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginDispatch() {
        if (Thread.currentThread() != this.flushingThread) {
            Vector vector = this.pendingCommands;
            synchronized (vector) {
                while (this.flushing) {
                    try {
                        this.pendingCommands.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.dispatchingThreads.addElement(Thread.currentThread());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endDispatch() {
        if (Thread.currentThread() != this.flushingThread) {
            Vector vector = this.pendingCommands;
            synchronized (vector) {
                this.dispatchingThreads.removeElement(Thread.currentThread());
                if (this.dispatchingThreads.isEmpty()) {
                    this.pendingCommands.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beginFlush() {
        Vector vector = this.pendingCommands;
        synchronized (vector) {
            if (this.dispatchingThreads.contains(Thread.currentThread())) {
                throw new FlushDeadlock();
            }
            while (this.dispatchingThreads.size() > 0) {
                try {
                    this.pendingCommands.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.pendingCommands.isEmpty()) {
                return false;
            }
            this.flushing = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endFlush() {
        Vector vector = this.pendingCommands;
        synchronized (vector) {
            this.flushing = false;
            this.pendingCommands.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PostponedCommand removeFirst() {
        Vector vector = this.pendingCommands;
        synchronized (vector) {
            PostponedCommand pc = null;
            if (this.pendingCommands.size() > 0) {
                pc = (PostponedCommand)this.pendingCommands.elementAt(0);
                this.pendingCommands.removeElementAt(0);
            }
            return pc;
        }
    }

    private void manageTimerExpired(final PostponedCommand pc) {
        Thread t = new Thread(){

            public void run() {
                MicroStub.this.beginDispatch();
                boolean found = MicroStub.this.pendingCommands.removeElement(pc);
                MicroStub.this.endDispatch();
                if (found) {
                    MicroStub.this.handlePostponedCommandExpired(pc.command, pc.icpe);
                }
            }
        };
        t.start();
    }

    private class FlushDeadlock
    extends RuntimeException {
    }

    protected class PostponedCommand {
        private Command command;
        private int sessionId;
        private ICPException icpe;
        private Timer timer;

        public PostponedCommand(Command c, int sessionId, ICPException icpe) {
            this.command = c;
            this.sessionId = sessionId;
            this.icpe = icpe;
        }

        public Command getCommand() {
            return this.command;
        }

        public ICPException getException() {
            return this.icpe;
        }
    }
}

