/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.http;

import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.http.HTTPRequest;
import jade.imtp.leap.http.HTTPResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class HTTPHelper {
    public static final String RECIPIENT_ID_FIELD = "recipient-id";

    public static JICPPacket readPacketFromHttp(byte[] input) throws IOException {
        return HTTPHelper.readPacketFromHttp(new ByteArrayInputStream(input));
    }

    public static JICPPacket readPacketFromHttp(InputStream is) throws IOException {
        HTTPRequest request = new HTTPRequest();
        request.readFrom(is);
        if (request.getMethod().equals("GET")) {
            String recipientID = request.getField(RECIPIENT_ID_FIELD);
            JICPPacket pkt = new JICPPacket(23, 0, recipientID, null);
            return pkt;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(request.getPayload());
        return JICPPacket.readFrom(bis);
    }

    public static HTTPResponse wrapInHttp(byte[] jicpPacket) throws IOException {
        HTTPResponse response = new HTTPResponse();
        response.setCode("200");
        response.setMessage("OK");
        response.setHttpType("HTTP/1.1");
        response.setPayload(jicpPacket);
        return response;
    }

    public static HTTPResponse wrapInHttp(JICPPacket pkt) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(pkt.getLength());
        pkt.writeTo(os);
        return HTTPHelper.wrapInHttp(os.toByteArray());
    }
}

