/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.tools.gui.ACLMessageNode;
import jade.tools.gui.ACLStatisticsFrame_itemComboBox_itemAdapter;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ACLStatisticsFrame
extends JFrame {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JScrollPane tableScrollPane = new JScrollPane();
    JButton closeButton = new JButton();
    JComboBox itemComboBox = new JComboBox();
    JTable statisticsTable = new JTable();
    DefaultComboBoxModel itemBoxModel = new DefaultComboBoxModel();
    DefaultTreeModel aclTreeModel;
    ACLStatiscticsTableModel aclTableModel;

    public ACLStatisticsFrame(DefaultTreeModel aclTreeModel) {
        this.aclTreeModel = aclTreeModel;
        this.aclTableModel = new ACLStatiscticsTableModel(aclTreeModel);
        try {
            this.jbInit();
            this.setFrameIcon("images/details.gif");
            this.statisticsTable.setModel(this.aclTableModel);
            this.statisticsTable.updateUI();
            this.itemBoxModel.addElement("performative");
            this.itemBoxModel.addElement("send-to");
            this.itemBoxModel.addElement("received-from");
            this.itemBoxModel.addElement("ontology");
            this.itemBoxModel.addElement("traffic");
            this.itemComboBox.setModel(this.itemBoxModel);
            this.itemComboBox.setRenderer(new SomeLabelRenderer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void show(DefaultTreeModel aclModel) {
        ACLStatisticsFrame frame = new ACLStatisticsFrame(aclModel);
        frame.setSize(300, 300);
        frame.setVisible(true);
    }

    void closeButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    void itemComboBox_itemStateChanged(ItemEvent e) {
        Object o = this.itemComboBox.getSelectedItem();
        if (o == null) {
            return;
        }
        String item = (String)o;
        this.aclTableModel.fillThis(item);
        this.statisticsTable.validate();
        this.statisticsTable.updateUI();
    }

    private void setFrameIcon(String iconpath) {
        ImageIcon image = new ImageIcon(this.getClass().getResource(iconpath));
        this.setIconImage(image.getImage());
    }

    private void jbInit() throws Exception {
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setText("statistics:");
        this.setForeground(Color.white);
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.closeButton.setBackground(Color.white);
        this.closeButton.setFont(new Font("Dialog", 0, 11));
        this.closeButton.setText("close");
        this.closeButton.addActionListener(new ACLStatisticsFrame_closeButton_actionAdapter(this));
        this.statisticsTable.setFont(new Font("Dialog", 0, 11));
        this.tableScrollPane.getViewport().setBackground(Color.white);
        this.itemComboBox.addItemListener(new ACLStatisticsFrame_itemComboBox_itemAdapter(this));
        this.itemComboBox.setBackground(Color.white);
        this.itemComboBox.setFont(new Font("Dialog", 0, 11));
        this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.tableScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tableScrollPane.getViewport().add((Component)this.statisticsTable, null);
        this.getContentPane().add((Component)this.closeButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.itemComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private class SomeLabelRenderer
    extends JLabel
    implements ListCellRenderer {
        public SomeLabelRenderer() {
            this.setOpaque(true);
            this.setFont(new Font("Dialog", 0, 10));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                String sValue = (String)value;
                this.setText((String)value);
                this.setText((String)value);
            }
            this.setBackground(isSelected ? Color.blue : Color.white);
            this.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }
    }

    private class ACLStatisticsFrame_closeButton_actionAdapter
    implements ActionListener {
        ACLStatisticsFrame adaptee;

        ACLStatisticsFrame_closeButton_actionAdapter(ACLStatisticsFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.closeButton_actionPerformed(e);
        }
    }

    private class ACLStatiscticsTableModel
    extends DefaultTableModel {
        HashMap countTable = new HashMap();
        String theItem;
        DefaultTreeModel aclModel;

        public ACLStatiscticsTableModel(DefaultTreeModel aclModel) {
            this.aclModel = aclModel;
            this.fillThis("performative");
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return this.theItem;
            }
            if (column == 1) {
                return "number";
            }
            return "?";
        }

        public Object getValueAt(int row, int column) {
            Vector v = this.getDataVector().elementAt(row);
            String result = "<?>";
            if (column == 0) {
                result = (String)v.get(0);
            }
            if (column == 1) {
                result = (String)v.get(1);
            }
            return result;
        }

        public void fillThis(String item) {
            this.getDataVector().clear();
            DefaultMutableTreeNode aclRoot = (DefaultMutableTreeNode)this.aclModel.getRoot();
            this.theItem = item;
            this.countTable.clear();
            for (int i = 0; i < aclRoot.getChildCount(); ++i) {
                Object o;
                ACLMessageNode mn = (ACLMessageNode)aclRoot.getChildAt(i);
                String toCount = "<unknown>";
                if (this.theItem.equals("performative")) {
                    toCount = mn.getDirection() + ":" + mn.getPerformative();
                }
                if (this.theItem.equals("send-to")) {
                    toCount = mn.getDirection() + ":" + mn.getSendTo();
                }
                if (this.theItem.equals("received-from")) {
                    toCount = mn.getDirection() + ":" + mn.receivedFrom();
                }
                if (this.theItem.equals("ontology")) {
                    toCount = mn.getDirection() + ":" + mn.getOntology();
                }
                if (this.theItem.equals("traffic")) {
                    toCount = mn.getDirection();
                }
                if ((o = this.countTable.get(toCount)) == null) {
                    this.countTable.put(toCount, "1");
                    continue;
                }
                int value = Integer.parseInt((String)o);
                this.countTable.remove(toCount);
                this.countTable.put(toCount, "" + ++value);
            }
            Iterator itor = this.countTable.keySet().iterator();
            while (itor.hasNext()) {
                Vector<String> v = new Vector<String>();
                String key = (String)itor.next();
                String value = (String)this.countTable.get(key);
                v.add(key);
                v.add(value);
                this.getDataVector().add(v);
            }
        }
    }
}

