/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.examples.ping;

import bdi4jade.annotation.Belief;
import bdi4jade.plan.Plan;
import bdi4jade.plan.planbody.AbstractPlanBody;
import jade.core.AID;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PingPlanBody
extends AbstractPlanBody {
    private static final Log log = LogFactory.getLog(PingPlanBody.class);
    public static final String MSG_CONTENT = "ping";
    private static final long serialVersionUID = -6288758975856575305L;
    private int counter;
    private MessageTemplate mt;
    @Belief
    private bdi4jade.belief.Belief<String, String> neighbour;
    @Belief
    private bdi4jade.belief.Belief<String, Integer> pingTimes;
    private boolean sent;

    public void action() {
        if (!this.sent) {
            ACLMessage msg = new ACLMessage(7);
            msg.setContent(MSG_CONTENT);
            msg.addReceiver(new AID((String)this.neighbour.getValue(), false));
            msg.setConversationId("cin" + System.currentTimeMillis());
            msg.setReplyWith("inform" + System.currentTimeMillis());
            this.myAgent.send(msg);
            this.mt = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchConversationId((String)msg.getConversationId()), (MessageTemplate)MessageTemplate.MatchInReplyTo((String)msg.getReplyWith()));
            this.sent = true;
            log.info((Object)("Ping sent to agent " + (String)this.neighbour.getValue() + "!"));
        } else {
            ACLMessage reply = this.myAgent.receive(this.mt);
            if (reply != null) {
                log.info((Object)("Pong received from " + reply.getSender().getName() + "!"));
                log.info((Object)("Content: " + reply.getContent()));
                ++this.counter;
                if (this.counter == (Integer)this.pingTimes.getValue()) {
                    this.setEndState(Plan.EndState.SUCCESSFUL);
                } else {
                    this.sent = false;
                }
            } else {
                this.block();
            }
        }
    }

    public void onStart() {
        this.sent = false;
        this.counter = 0;
    }
}

