/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.examples.planselection;

import bdi4jade.event.GoalEvent;
import bdi4jade.event.GoalListener;
import bdi4jade.examples.BDI4JADEExamplesApp;
import bdi4jade.examples.planselection.GenericValueFunction;
import bdi4jade.examples.planselection.TransportationAgent;
import jade.BootProfileImpl;
import jade.core.Agent;
import jade.core.Profile;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.wrapper.AgentContainer;
import jade.wrapper.AgentController;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;

public class ExperimentRunner
implements GoalListener {
    public static final int ITERATIONS = 5000;
    private ProfileImpl bootProfile;
    private int iteration;
    private final Log log = LogFactory.getLog(this.getClass());
    private Runtime runtime;
    private final TransportationAgent transportationAgent;

    public static void main(String[] args) {
        PropertyConfigurator.configure((URL)BDI4JADEExamplesApp.class.getResource("log4j.properties"));
        ExperimentRunner runner = new ExperimentRunner();
        runner.run();
    }

    public ExperimentRunner() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("-gui");
        params.add("-detect-main:false");
        this.log.info((Object)("Plataform parameters: " + params));
        this.bootProfile = new BootProfileImpl(params.toArray(new String[0]));
        this.runtime = Runtime.instance();
        AgentContainer controller = this.runtime.createMainContainer((Profile)this.bootProfile);
        this.transportationAgent = new TransportationAgent();
        try {
            AgentController ac = controller.acceptNewAgent(((Object)((Object)this.transportationAgent)).getClass().getSimpleName(), (Agent)this.transportationAgent);
            ac.start();
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        this.iteration = 0;
    }

    public void goalPerformed(GoalEvent event) {
        if (event.getStatus().isFinished() && event.getGoal() instanceof TransportationAgent.TransportationGoal) {
            if (this.iteration < 5000) {
                this.run();
            } else {
                this.log.info((Object)"Iterations finished!!");
                this.log.info((Object)((GenericValueFunction)this.transportationAgent.getCapability().getBeliefBase().getBelief((Object)"Satisfaction").getValue()).stats());
            }
        }
    }

    public void run() {
        this.transportationAgent.updatePreferences();
        this.transportationAgent.addGoal(new TransportationAgent.TransportationGoal(), this);
        ++this.iteration;
    }
}

