/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.examples.planselection;

import bdi4jade.annotation.Belief;
import bdi4jade.examples.planselection.GenericValueFunction;
import bdi4jade.examples.planselection.Softgoals;
import bdi4jade.examples.planselection.TransportationPlan;
import bdi4jade.extension.planselection.utilitybased.SoftgoalPreferences;
import bdi4jade.plan.Plan;
import bdi4jade.plan.planbody.AbstractPlanBody;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportationPlanBody
extends AbstractPlanBody {
    private static final long serialVersionUID = -9039447524062487795L;
    private Log log;
    private TransportationPlan plan;
    @Belief(name="SoftgoalPreferences")
    private SoftgoalPreferences preferences;
    @Belief(name="Satisfaction")
    private bdi4jade.belief.Belief<String, GenericValueFunction<Integer>> satisfaction;

    public void action() {
        this.log.debug((Object)("Plan executed: " + this.plan.getId()));
        Scenario scenario = new Scenario();
        double satisfaction = scenario.getSatisfaction();
        ((GenericValueFunction)this.satisfaction.getValue()).addValue(((GenericValueFunction)this.satisfaction.getValue()).getCount() + 1, satisfaction);
        this.log.debug((Object)"Plan finished!");
        this.setEndState(Plan.EndState.SUCCESSFUL);
    }

    public void onStart() {
        this.log = LogFactory.getLog(((Object)((Object)this)).getClass());
        this.plan = (TransportationPlan)this.getPlan();
    }

    class Scenario {
        Double comfort;
        Double cost;
        Boolean crashed;
        Random rand = new Random(System.currentTimeMillis());
        Boolean robbed;
        Double timeTaken;

        public Scenario() {
            this.crashed = this.occurred(this.rand, TransportationPlanBody.this.plan.getCrashProbability());
            this.comfort = TransportationPlanBody.this.plan.getComfort();
            this.timeTaken = 90.0;
            this.cost = TransportationPlanBody.this.plan.getCost();
            if (!this.crashed.booleanValue()) {
                this.timeTaken = new Double(this.rand.nextInt(TransportationPlanBody.this.plan.getMaxTime() - TransportationPlanBody.this.plan.getMinTime()) + TransportationPlanBody.this.plan.getMinTime());
            } else if (!TransportationPlanBody.this.plan.isCostConstant()) {
                this.cost = 1.0;
            }
            this.robbed = this.occurred(this.rand, TransportationPlanBody.this.plan.getBeingRobbedProbability());
        }

        public Double getSatisfaction() {
            double safetySatisfaction = this.crashed != false ? 0.0 : 1.0;
            TransportationPlanBody.this.log.debug((Object)("safetySatisfaction = " + safetySatisfaction));
            double costSatisfaction = 1.0 - this.cost;
            TransportationPlanBody.this.log.debug((Object)("costSatisfaction = " + costSatisfaction));
            double comfortSatisfaction = this.comfort;
            TransportationPlanBody.this.log.debug((Object)("comfortSatisfaction = " + comfortSatisfaction));
            double performanceSatisfaction = this.crashed != false ? 0.0 : 1.0 - this.timeTaken / 90.0;
            TransportationPlanBody.this.log.debug((Object)("performanceSatisfaction = " + performanceSatisfaction));
            double securitySatisfaction = this.robbed != false ? 0.0 : 1.0;
            TransportationPlanBody.this.log.debug((Object)("securitySatisfaction = " + securitySatisfaction));
            double satisfaction = TransportationPlanBody.this.preferences.getPreferenceForSoftgoal(Softgoals.SAFETY) * safetySatisfaction + TransportationPlanBody.this.preferences.getPreferenceForSoftgoal(Softgoals.COST) * costSatisfaction + TransportationPlanBody.this.preferences.getPreferenceForSoftgoal(Softgoals.COMFORT) * comfortSatisfaction + TransportationPlanBody.this.preferences.getPreferenceForSoftgoal(Softgoals.PERFORMANCE) * performanceSatisfaction + TransportationPlanBody.this.preferences.getPreferenceForSoftgoal(Softgoals.SECURITY) * securitySatisfaction;
            TransportationPlanBody.this.log.debug((Object)("Total Satisfaction = " + satisfaction));
            return satisfaction;
        }

        private boolean occurred(Random rand, double probability) {
            double number = rand.nextDouble();
            return number < probability;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[ crashed = ").append(this.crashed).append(", cost = ").append(this.cost).append(", time taken = ").append(this.timeTaken).append(", robbed = ").append(this.robbed).append(" ]");
            return sb.toString();
        }
    }
}

