/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.core;

import bdi4jade.annotation.AssociatedCapability;
import bdi4jade.annotation.Belief;
import bdi4jade.annotation.PartCapability;
import bdi4jade.annotation.Plan;
import bdi4jade.belief.BeliefBase;
import bdi4jade.belief.TransientBelief;
import bdi4jade.belief.TransientBeliefSet;
import bdi4jade.core.AbstractBDIAgent;
import bdi4jade.core.BDIAgent;
import bdi4jade.core.Intention;
import bdi4jade.goal.Goal;
import bdi4jade.plan.PlanLibrary;
import bdi4jade.reasoning.BeliefRevisionStrategy;
import bdi4jade.reasoning.DefaultBeliefRevisionStrategy;
import bdi4jade.reasoning.DefaultDeliberationFunction;
import bdi4jade.reasoning.DefaultOptionGenerationFunction;
import bdi4jade.reasoning.DefaultPlanSelectionStrategy;
import bdi4jade.reasoning.DeliberationFunction;
import bdi4jade.reasoning.OptionGenerationFunction;
import bdi4jade.reasoning.PlanSelectionStrategy;
import bdi4jade.util.ReflectionUtils;
import jade.lang.acl.ACLMessage;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Capability
implements Serializable {
    private static final long serialVersionUID = -4922359927943108421L;
    private static final Log log = LogFactory.getLog(Capability.class);
    private final Set<Capability> associationSources;
    private final Set<Capability> associationTargets;
    protected final BeliefBase beliefBase;
    private BeliefRevisionStrategy beliefRevisionStrategy;
    private DeliberationFunction deliberationFunction;
    private Map<Class<? extends Capability>, Set<Capability>> fullAccessOwnersMap;
    protected final String id;
    private final Collection<Intention> intentions = new LinkedList<Intention>();
    private BDIAgent myAgent;
    private OptionGenerationFunction optionGenerationFunction;
    private final List<Class<? extends Capability>> parentCapabilities = this.generateParentCapabilities();
    private final Set<Capability> partCapabilities;
    protected final PlanLibrary planLibrary;
    private PlanSelectionStrategy planSelectionStrategy;
    private Map<Class<? extends Capability>, Set<Capability>> restrictedAccessOwnersMap;
    private boolean started;
    private Capability wholeCapability;

    public Capability() {
        this(null, null, null, null, null);
    }

    public Capability(Set<bdi4jade.belief.Belief<?, ?>> initialBeliefs, Set<bdi4jade.plan.Plan> initialPlans) {
        this(null, null, initialBeliefs, null, initialPlans);
    }

    public Capability(String id) {
        this(id, null, null, null, null);
    }

    protected Capability(String id, BeliefBase beliefBase, Set<bdi4jade.belief.Belief<?, ?>> initialBeliefs, PlanLibrary planLibrary, Set<bdi4jade.plan.Plan> initialPlans) {
        log.debug((Object)("Parent capabilities: " + this.parentCapabilities));
        this.started = false;
        this.id = id == null ? (this.getClass().getCanonicalName() == null || Capability.class.equals(this.getClass()) ? String.valueOf(Capability.class.getName()) + System.currentTimeMillis() : this.getClass().getName()) : id;
        this.beliefBase = beliefBase == null ? new BeliefBase(this, initialBeliefs) : beliefBase;
        this.planLibrary = planLibrary == null ? new PlanLibrary(this, initialPlans) : planLibrary;
        this.wholeCapability = null;
        this.partCapabilities = new HashSet<Capability>();
        this.associationSources = new HashSet<Capability>();
        this.associationTargets = new HashSet<Capability>();
        this.setBeliefRevisionStrategy(null);
        this.setOptionGenerationFunction(null);
        this.setDeliberationFunction(null);
        this.setPlanSelectionStrategy(null);
        this.computeGoalOwnersMap();
    }

    public Capability(String id, Set<bdi4jade.belief.Belief<?, ?>> initialBeliefs, Set<bdi4jade.plan.Plan> initialPlans) {
        this(id, null, initialBeliefs, null, initialPlans);
    }

    protected void addAnnotatedFields(Class<? extends Capability> capabilityClass) {
        Field[] fieldArray = capabilityClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b;
            Field field;
            block13: {
                field = fieldArray[n2];
                b = field.isAccessible();
                field.setAccessible(true);
                try {
                    Capability capability;
                    Object value;
                    String name;
                    Annotation annotation;
                    if (field.isAnnotationPresent(Belief.class)) {
                        if (bdi4jade.belief.Belief.class.isAssignableFrom(field.getType())) {
                            bdi4jade.belief.Belief belief = (bdi4jade.belief.Belief)field.get(this);
                            this.getBeliefBase().addBelief(belief);
                            break block13;
                        }
                        throw new ClassCastException("Field " + field.getName() + " should be a Belief");
                    }
                    if (field.isAnnotationPresent(bdi4jade.annotation.TransientBelief.class)) {
                        annotation = field.getAnnotation(bdi4jade.annotation.TransientBelief.class);
                        name = "".equals(annotation.name()) ? field.getName() : annotation.name();
                        value = field.get(this);
                        this.getBeliefBase().addBelief(new TransientBelief<String, Object>(name, value));
                        break block13;
                    }
                    if (field.isAnnotationPresent(bdi4jade.annotation.TransientBeliefSet.class)) {
                        annotation = field.getAnnotation(bdi4jade.annotation.TransientBeliefSet.class);
                        name = "".equals(annotation.name()) ? field.getName() : annotation.name();
                        value = field.get(this);
                        if (Set.class.isAssignableFrom(field.getType())) {
                            this.getBeliefBase().addBelief(new TransientBeliefSet(name, (Set)value));
                        }
                        break block13;
                    }
                    if (field.isAnnotationPresent(Plan.class)) {
                        if (bdi4jade.plan.Plan.class.isAssignableFrom(field.getType())) {
                            bdi4jade.plan.Plan plan = (bdi4jade.plan.Plan)field.get(this);
                            this.getPlanLibrary().addPlan(plan);
                            break block13;
                        }
                        throw new ClassCastException("Field " + field.getName() + " should be a Plan");
                    }
                    if (field.isAnnotationPresent(AssociatedCapability.class)) {
                        if (Capability.class.isAssignableFrom(field.getType())) {
                            capability = (Capability)field.get(this);
                            this.addAssociatedCapability(capability);
                            break block13;
                        }
                        throw new ClassCastException("Field " + field.getName() + " should be a Capability");
                    }
                    if (!field.isAnnotationPresent(PartCapability.class)) break block13;
                    if (Capability.class.isAssignableFrom(field.getType())) {
                        capability = (Capability)field.get(this);
                        this.addPartCapability(capability);
                        break block13;
                    }
                    throw new ClassCastException("Field " + field.getName() + " should be a Capability");
                }
                catch (Exception exc) {
                    log.warn((Object)exc);
                    exc.printStackTrace();
                }
            }
            field.setAccessible(b);
            ++n2;
        }
    }

    public final void addAssociatedCapability(Capability capability) {
        this.associationTargets.add(capability);
        capability.associationSources.add(this);
        this.computeGoalOwnersMap();
        capability.computeGoalOwnersMap();
        this.resetAgentCapabilities();
    }

    public void addCandidatePlans(Goal goal, Map<Capability, Set<bdi4jade.plan.Plan>> candidatePlansMap) {
        Set<bdi4jade.plan.Plan> plans = this.planLibrary.getCandidatePlans(goal);
        if (!plans.isEmpty()) {
            candidatePlansMap.put(this, plans);
        }
        for (Capability part : this.partCapabilities) {
            part.addCandidatePlans(goal, candidatePlansMap);
        }
    }

    final void addIntention(Intention intention) {
        this.intentions.add(intention);
    }

    public final void addPartCapability(Capability partCapability) {
        if (partCapability.wholeCapability != null) {
            throw new IllegalArgumentException("Part capability already binded to another whole capability.");
        }
        partCapability.wholeCapability = this;
        this.partCapabilities.add(partCapability);
        partCapability.computeGoalOwnersMap();
        this.computeGoalOwnersMap();
        this.resetAgentCapabilities();
    }

    final Set<Capability> addRelatedCapabilities(Set<Capability> capabilities) {
        for (Capability part : this.partCapabilities) {
            if (capabilities.contains(part)) continue;
            capabilities.add(part);
            part.addRelatedCapabilities(capabilities);
        }
        for (Capability target : this.associationTargets) {
            if (capabilities.contains(target)) continue;
            capabilities.add(target);
            target.addRelatedCapabilities(capabilities);
        }
        return capabilities;
    }

    public boolean canAchieve(Goal goal) {
        if (this.planLibrary.canAchieve(goal)) {
            return true;
        }
        for (Capability part : this.partCapabilities) {
            if (!part.canAchieve(goal)) continue;
            return true;
        }
        return false;
    }

    public boolean canHandle(ACLMessage msg) {
        if (this.planLibrary.canHandle(msg)) {
            return true;
        }
        for (Capability part : this.partCapabilities) {
            if (!part.canHandle(msg)) continue;
            return true;
        }
        return false;
    }

    private final void computeGoalOwnersMap() {
        this.fullAccessOwnersMap = new HashMap<Class<? extends Capability>, Set<Capability>>();
        ReflectionUtils.addGoalOwner(this.fullAccessOwnersMap, this);
        if (this.wholeCapability != null) {
            ReflectionUtils.addGoalOwner(this.fullAccessOwnersMap, this.wholeCapability);
        }
        this.restrictedAccessOwnersMap = new HashMap<Class<? extends Capability>, Set<Capability>>();
        for (Capability capability : this.associationTargets) {
            ReflectionUtils.addGoalOwner(this.restrictedAccessOwnersMap, capability);
        }
        for (Capability capability : this.partCapabilities) {
            ReflectionUtils.addGoalOwner(this.restrictedAccessOwnersMap, capability);
        }
        log.debug((Object)("Full access owners: " + this.fullAccessOwnersMap));
        log.debug((Object)("Restricted access owners: " + this.restrictedAccessOwnersMap));
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Capability)) {
            return false;
        }
        return this.getFullId().equals(((Capability)obj).getFullId());
    }

    private final List<Class<? extends Capability>> generateParentCapabilities() {
        LinkedList<Class<? extends Capability>> parentCapabilities = new LinkedList<Class<? extends Capability>>();
        Class<?> currentClass = this.getClass().getSuperclass();
        while (Capability.class.isAssignableFrom(currentClass) && !Capability.class.equals(currentClass)) {
            parentCapabilities.add(currentClass);
            currentClass = currentClass.getSuperclass();
        }
        return parentCapabilities;
    }

    public final Set<Capability> getAssociatedCapabilities() {
        return this.associationTargets;
    }

    public final BeliefBase getBeliefBase() {
        return this.beliefBase;
    }

    public final BeliefRevisionStrategy getBeliefRevisionStrategy() {
        return this.beliefRevisionStrategy;
    }

    public final DeliberationFunction getDeliberationFunction() {
        return this.deliberationFunction;
    }

    public final String getFullId() {
        StringBuffer sb = new StringBuffer();
        this.getFullId(sb);
        return sb.toString();
    }

    private final void getFullId(StringBuffer sb) {
        if (this.wholeCapability != null) {
            this.wholeCapability.getFullId(sb);
            sb.append(".");
        }
        sb.append(this.id);
    }

    public final Set<Capability> getGoalOwner(Class<? extends Capability> owner, boolean internal) {
        Set<Capability> restrictedAccessOwners;
        HashSet<Capability> owners = new HashSet<Capability>();
        Set<Capability> fullAccessOwners = this.fullAccessOwnersMap.get(owner);
        if (fullAccessOwners != null) {
            owners.addAll(fullAccessOwners);
        }
        if (!internal && (restrictedAccessOwners = this.restrictedAccessOwnersMap.get(owner)) != null) {
            owners.addAll(restrictedAccessOwners);
        }
        return owners;
    }

    public String getId() {
        return this.id;
    }

    final Collection<Intention> getIntentions() {
        return this.intentions;
    }

    public final BDIAgent getMyAgent() {
        return this.myAgent;
    }

    public final OptionGenerationFunction getOptionGenerationFunction() {
        return this.optionGenerationFunction;
    }

    public final List<Class<? extends Capability>> getParentCapabilities() {
        return this.parentCapabilities;
    }

    public final Set<Capability> getPartCapabilities() {
        return this.partCapabilities;
    }

    public final PlanLibrary getPlanLibrary() {
        return this.planLibrary;
    }

    public final PlanSelectionStrategy getPlanSelectionStrategy() {
        return this.planSelectionStrategy;
    }

    public final Capability getWholeCapability() {
        return this.wholeCapability;
    }

    public final int hashCode() {
        return this.getFullId().hashCode();
    }

    public final void removeAssociatedCapability(Capability capability) {
        this.associationTargets.remove(capability);
        capability.associationSources.remove(this);
        this.computeGoalOwnersMap();
        this.resetAgentCapabilities();
    }

    final void removeIntention(Intention intention) {
        this.intentions.remove(intention);
    }

    public final boolean removePartCapability(Capability partCapability) {
        boolean removed = this.partCapabilities.remove(partCapability);
        if (removed) {
            partCapability.wholeCapability = null;
            this.computeGoalOwnersMap();
            this.resetAgentCapabilities();
        }
        return removed;
    }

    private final void resetAgentCapabilities() {
        if (this.myAgent != null && this.myAgent instanceof AbstractBDIAgent) {
            ((AbstractBDIAgent)this.myAgent).resetAllCapabilities();
        }
    }

    public final void setBeliefRevisionStrategy(BeliefRevisionStrategy beliefRevisionStrategy) {
        if (beliefRevisionStrategy == null) {
            this.beliefRevisionStrategy = new DefaultBeliefRevisionStrategy();
        } else {
            this.beliefRevisionStrategy.setCapability(null);
            this.beliefRevisionStrategy = beliefRevisionStrategy;
        }
        this.beliefRevisionStrategy.setCapability(this);
    }

    public final void setDeliberationFunction(DeliberationFunction deliberationFunction) {
        if (deliberationFunction == null) {
            this.deliberationFunction = new DefaultDeliberationFunction();
        } else {
            this.deliberationFunction.setCapability(null);
            this.deliberationFunction = deliberationFunction;
        }
        this.deliberationFunction.setCapability(this);
    }

    final synchronized void setMyAgent(BDIAgent myAgent) {
        if (this.myAgent != null && myAgent == null) {
            this.takeDown();
        }
        this.myAgent = myAgent;
        if (this.myAgent != null && !this.started) {
            this.addAnnotatedFields(this.getClass());
            for (Class<? extends Capability> parentCapabilityClass : this.parentCapabilities) {
                this.addAnnotatedFields(parentCapabilityClass);
            }
            this.setup();
            this.started = true;
        }
    }

    public final void setOptionGenerationFunction(OptionGenerationFunction optionGenerationFunction) {
        if (optionGenerationFunction == null) {
            this.optionGenerationFunction = new DefaultOptionGenerationFunction();
        } else {
            this.optionGenerationFunction.setCapability(null);
            this.optionGenerationFunction = optionGenerationFunction;
        }
        this.optionGenerationFunction.setCapability(this);
    }

    public final void setPlanSelectionStrategy(PlanSelectionStrategy planSelectionStrategy) {
        if (planSelectionStrategy == null) {
            this.planSelectionStrategy = new DefaultPlanSelectionStrategy();
        } else {
            this.planSelectionStrategy.setCapability(null);
            this.planSelectionStrategy = planSelectionStrategy;
        }
        this.planSelectionStrategy.setCapability(this);
    }

    protected void setup() {
    }

    protected void takeDown() {
    }

    public String toString() {
        return this.id;
    }
}

