/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.plan;

import bdi4jade.core.BDIAgent;
import bdi4jade.core.Capability;
import bdi4jade.exception.PlanInstantiationException;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalTemplate;
import bdi4jade.goal.GoalTemplateFactory;
import bdi4jade.plan.AbstractPlan;
import bdi4jade.plan.Plan;
import bdi4jade.plan.planbody.PlanBody;
import jade.lang.acl.MessageTemplate;
import java.lang.reflect.Modifier;

public class DefaultPlan
extends AbstractPlan {
    protected final Class<? extends PlanBody> planBodyClass;

    private static String generateId(Class<? extends Goal> goalClass, GoalTemplate goalTemplate, MessageTemplate messageTemplate, Class<? extends PlanBody> planBodyClass) {
        StringBuffer sb = new StringBuffer("[");
        if (goalClass != null) {
            sb.append(" ").append(goalClass.getName());
        }
        if (goalTemplate != null) {
            sb.append(" ").append(goalTemplate);
        }
        if (messageTemplate != null) {
            sb.append(" ").append(messageTemplate);
        }
        sb.append(" ] :: ");
        sb.append(planBodyClass.getName());
        return sb.toString();
    }

    public DefaultPlan(Class<? extends Goal> goalClass, Class<? extends PlanBody> planBodyClass) {
        super(DefaultPlan.generateId(goalClass, null, null, planBodyClass), GoalTemplateFactory.goalOfType(goalClass));
        this.planBodyClass = planBodyClass;
    }

    public DefaultPlan(Class<? extends PlanBody> planBodyClass) {
        super(DefaultPlan.generateId(null, null, null, planBodyClass));
        this.planBodyClass = planBodyClass;
    }

    public DefaultPlan(GoalTemplate goalTemplate, Class<? extends PlanBody> planBodyClass) {
        super(DefaultPlan.generateId(null, goalTemplate, null, planBodyClass), goalTemplate);
        this.planBodyClass = planBodyClass;
    }

    public DefaultPlan(GoalTemplate goalTemplate, MessageTemplate messageTemplate, Class<? extends PlanBody> planBodyClass) {
        super(DefaultPlan.generateId(null, goalTemplate, messageTemplate, planBodyClass), goalTemplate, messageTemplate);
        this.planBodyClass = planBodyClass;
    }

    public DefaultPlan(MessageTemplate messageTemplate, Class<? extends PlanBody> planBodyClass) {
        super(DefaultPlan.generateId(null, null, messageTemplate, planBodyClass), messageTemplate);
        this.planBodyClass = planBodyClass;
    }

    public DefaultPlan(String id, Class<? extends PlanBody> planBodyClass) {
        super(id);
        this.planBodyClass = planBodyClass;
    }

    public DefaultPlan(String id, GoalTemplate goalTemplate, Class<? extends PlanBody> planBodyClass) {
        super(id, goalTemplate);
        this.planBodyClass = planBodyClass;
    }

    public DefaultPlan(String id, GoalTemplate goalTemplate, MessageTemplate messageTemplate, Class<? extends PlanBody> planBodyClass) {
        super(id, goalTemplate, messageTemplate);
        this.planBodyClass = planBodyClass;
    }

    public DefaultPlan(String id, MessageTemplate messageTemplate, Class<? extends PlanBody> planBodyClass) {
        super(id, messageTemplate);
        this.planBodyClass = planBodyClass;
    }

    @Override
    public PlanBody createPlanBody() throws PlanInstantiationException {
        try {
            Class<?> enclosingClass = this.planBodyClass.getEnclosingClass();
            if (!Modifier.isStatic(this.planBodyClass.getModifiers()) && enclosingClass != null) {
                if (BDIAgent.class.isAssignableFrom(enclosingClass)) {
                    return this.planBodyClass.getDeclaredConstructor(enclosingClass).newInstance(this.getPlanLibrary().getCapability().getMyAgent());
                }
                if (Capability.class.isAssignableFrom(enclosingClass)) {
                    return this.planBodyClass.getDeclaredConstructor(enclosingClass).newInstance(this.getPlanLibrary().getCapability());
                }
                assert (Plan.class.isAssignableFrom(enclosingClass));
                return this.planBodyClass.getDeclaredConstructor(enclosingClass).newInstance(this);
            }
            return this.planBodyClass.newInstance();
        }
        catch (Exception e) {
            throw new PlanInstantiationException(e);
        }
    }

    public Class<? extends PlanBody> getPlanBodyClass() {
        return this.planBodyClass;
    }
}

